/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.configuracion;

import es.aeat.pftw.mtrc.utilidades.StringUtility;
import es.aeat.pftw.mtrp.configuracion.IRegRegla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class RegRegla
implements Serializable,
IRegRegla {
    private static final long serialVersionUID = 1L;
    private int idRegla = 0;
    private String condicion = "";
    private String operacionV = "";
    private String operacionF = "";
    private String destino = "";
    private String discriminante = "";
    private int orden = Integer.MAX_VALUE;
    private String usuarioDepurando;
    private String separadorDestinos = ";";
    private List<String> partidas = null;
    private String tipoRegla;

    @Override
    public void inicializaRegRegla(int idReg, String condic, String opVerdadero, String opFalsa, String destn, String discrim, String tipoReg) {
        this.idRegla = idReg;
        this.setCondicion(condic);
        this.setOperacionV(opVerdadero);
        this.setOperacionF(opFalsa);
        this.setDestino(destn);
        this.setDiscriminante(discrim);
        this.setTipoRegla(tipoReg);
        this.partidas = new ArrayList<String>();
        this.usuarioDepurando = "";
        this.orden = Integer.MAX_VALUE;
    }

    @Override
    public int getIdRegla() {
        return this.idRegla;
    }

    @Override
    public void setIdRegla(int id) {
        this.idRegla = id;
    }

    @Override
    public void setIdRegla(String id) {
        try {
            this.idRegla = Integer.valueOf(id);
        }
        catch (Exception ex) {
            this.idRegla = 0;
        }
    }

    @Override
    public String getCondicion() {
        return this.condicion;
    }

    @Override
    public void setCondicion(String c) {
        this.condicion = c == null ? "" : c;
    }

    @Override
    public String getOperacionV() {
        return this.operacionV;
    }

    @Override
    public void setOperacionV(String opv) {
        this.operacionV = opv == null ? "" : opv;
    }

    @Override
    public String getOperacionF() {
        return this.operacionF;
    }

    @Override
    public void setOperacionF(String opf) {
        this.operacionF = opf == null ? "" : opf;
    }

    @Override
    public String getDestino() {
        return this.destino;
    }

    @Override
    public String[] getDestinos() throws ExceptionMotor {
        String[] res = StringUtility.getStringUtility().split(this.destino, this.separadorDestinos);
        for (int i = 0; i < res.length; ++i) {
            res[i] = res[i].trim();
        }
        return res;
    }

    @Override
    public String getSeparadorDestinos() {
        return this.separadorDestinos;
    }

    @Override
    public void setSeparadorDestinos(String valor) {
        this.separadorDestinos = valor;
    }

    @Override
    public void setDestino(String des) {
        this.destino = des == null ? "" : des;
    }

    @Override
    public String getDiscriminante() {
        return this.discriminante;
    }

    @Override
    public void setDiscriminante(String dis) {
        this.discriminante = dis == null ? "" : dis;
    }

    @Override
    public String getTipoRegla() {
        return this.tipoRegla;
    }

    @Override
    public void setTipoRegla(String sTipoRegla) {
        this.tipoRegla = sTipoRegla == null ? "" : sTipoRegla;
    }

    @Override
    public List<String> getPartidas() {
        return this.partidas;
    }

    @Override
    public void setPartidas(List<String> arr) {
        this.partidas = arr;
    }

    @Override
    public int addPartida(String partida) {
        this.partidas.add(partida);
        return this.partidas.size();
    }

    @Override
    public int getOrden() {
        return this.orden;
    }

    @Override
    public void setOrden(int o) {
        this.orden = o == 0 ? Integer.MAX_VALUE : o;
    }

    @Override
    public void setUsuarioDepurando(String usuarioDepurando) {
        this.usuarioDepurando = usuarioDepurando;
    }

    @Override
    public String getUsuarioDepurando() {
        return this.usuarioDepurando;
    }

    public String toString() {
        return "Regla " + this.getIdRegla() + " (" + this.getTipoRegla() + ")";
    }

    @Override
    public IRegRegla clone() throws CloneNotSupportedException {
        RegRegla r = new RegRegla();
        r.setCondicion(this.getCondicion());
        r.setDestino(this.getDestino());
        r.setDiscriminante(this.getDiscriminante());
        r.setIdRegla(this.getIdRegla());
        r.setOperacionF(this.getOperacionF());
        r.setOperacionV(this.getOperacionV());
        r.setOrden(this.getOrden());
        r.setPartidas((List)((ArrayList)this.getPartidas()).clone());
        r.setSeparadorDestinos(this.getSeparadorDestinos());
        r.setTipoRegla(this.getTipoRegla());
        r.setUsuarioDepurando(this.getUsuarioDepurando());
        return r;
    }
}

