/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.configuracion;

import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class RegEntrada
implements Serializable,
IRegEntrada {
    private static final long serialVersionUID = 1L;
    private Map<String, String> arrayDePropiedades = new HashMap<String, String>();

    public RegEntrada() {
        this.arrayDePropiedades.clear();
        this.arrayDePropiedades.put("ESTADO".toUpperCase(), String.valueOf(255));
        this.arrayDePropiedades.put("NUMERODECIMALES".toUpperCase(), "0");
    }

    @Override
    public void inicializaRegEntrada(String idVariable, String idTabla, String tipoDato, String valorInicial) {
        this.setIdVariable(idVariable);
        this.setIdPartida(idVariable);
        this.setTipoDato(tipoDato);
        this.setValorPorDefecto(valorInicial);
        this.setIdTabla(idTabla);
    }

    @Override
    public void setPropiedad(String nombrePropiedad, String valor) {
        if (nombrePropiedad.equalsIgnoreCase("TIPODATO")) {
            this.setTipoDato(valor);
        } else {
            this.arrayDePropiedades.put(nombrePropiedad.toUpperCase(), valor);
        }
    }

    @Override
    public String getPropiedad(String nombrePropiedad) {
        return this.arrayDePropiedades.get(nombrePropiedad.toUpperCase());
    }

    @Override
    public Map<String, String> getPropiedades() {
        return this.arrayDePropiedades;
    }

    @Override
    public String getIdPartida() {
        try {
            return this.getPropiedad("IDPARTIDA").toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public void setIdPartida(String idPar) {
        if (idPar == null) {
            this.setPropiedad("IDPARTIDA", "");
        } else {
            this.setPropiedad("IDPARTIDA", idPar);
        }
    }

    @Override
    public String getIdVariable() {
        try {
            return this.getPropiedad("IDVARIABLE").toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public void setIdVariable(String idVar) {
        if (idVar == null) {
            this.setPropiedad("IDVARIABLE", "");
        } else {
            this.setPropiedad("IDVARIABLE", idVar);
        }
    }

    @Override
    public String getIdTabla() {
        try {
            return this.getPropiedad("idTabla").toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public void setIdTabla(String tab) {
        if (tab == null) {
            this.setPropiedad("idTabla", "");
        } else {
            this.setPropiedad("idTabla", tab);
        }
    }

    @Override
    public String getTipoDato() {
        try {
            return this.getPropiedad("TIPODATO").toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public void setTipoDato(String valor) {
        if (valor.equalsIgnoreCase("Cadena")) {
            valor = "CADENA";
        } else if (valor.equalsIgnoreCase("Email")) {
            valor = "EMAIL";
        } else if (valor.equalsIgnoreCase("CadNum")) {
            valor = "CADENA_NUMERICA";
        } else if (valor.equalsIgnoreCase("CadNum2")) {
            valor = "CADENA_NUMERICA_2";
        } else if (valor.equalsIgnoreCase("Logico")) {
            valor = "LOGICO";
        } else if (valor.equalsIgnoreCase("Entero")) {
            valor = "ENTERO";
        } else if (valor.equalsIgnoreCase("Doble")) {
            valor = "DOBLE";
        } else if (valor.equalsIgnoreCase("Fecha")) {
            valor = "FECHA";
        } else if (valor.equalsIgnoreCase("Tel")) {
            valor = "TEL";
        } else if (valor.equalsIgnoreCase("BigDecimal")) {
            valor = "BIGDECIMAL";
        }
        this.arrayDePropiedades.put("TIPODATO", valor);
        this.estimarValorInicial();
    }

    @Override
    public int getNumDecimales() {
        try {
            return Integer.valueOf(this.getPropiedad("NUMERODECIMALES").toString());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public void setNumDecimales(int numeroDecimales) {
        this.setPropiedad("NUMERODECIMALES", String.valueOf(numeroDecimales));
    }

    @Override
    public void setNumDecimales(String numeroDecimales) {
        int numDecimales;
        try {
            numDecimales = Integer.valueOf(numeroDecimales);
        }
        catch (Exception ex) {
            numDecimales = 0;
        }
        this.setNumDecimales(numDecimales);
    }

    @Override
    public void setEstadoInicial(int valor) {
        this.setPropiedad("ESTADO", String.valueOf(valor));
    }

    @Override
    public void setEstadoInicial(String valor) {
        int estadoInicial;
        try {
            estadoInicial = Integer.valueOf(valor);
        }
        catch (Exception ex) {
            estadoInicial = 0;
        }
        this.setEstadoInicial(estadoInicial);
    }

    @Override
    public int getEstadoInicial() {
        try {
            return Integer.valueOf(this.getPropiedad("ESTADO").toString());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public void setValorPorDefecto(String valor) {
        this.setPropiedad("VALORPORDEFECTO", valor);
    }

    @Override
    public String getValorInicial() {
        try {
            return this.getPropiedad("VALORPORDEFECTO").toString();
        }
        catch (Exception ex) {
            this.estimarValorInicial();
            String ret = this.getPropiedad("VALORPORDEFECTO");
            if (ret == null) {
                return "";
            }
            return ret.toString();
        }
    }

    private void estimarValorInicial() {
        try {
            if (this.getPropiedad("TIPODATO") != null) {
                String tipoDato = this.getPropiedad("TIPODATO").toString();
                if (tipoDato.equalsIgnoreCase("ENTERO") || tipoDato.equalsIgnoreCase("DOBLE") || tipoDato.equalsIgnoreCase("BIGDECIMAL") || tipoDato.equalsIgnoreCase("CADENA_NUMERICA")) {
                    this.setPropiedad("VALORPORDEFECTO", "0");
                } else if (tipoDato.equalsIgnoreCase("LOGICO")) {
                    this.setPropiedad("VALORPORDEFECTO", "false");
                } else {
                    this.setPropiedad("VALORPORDEFECTO", "");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean esValorPorDefecto(String valor) {
        try {
            if (this.getPropiedad("TIPODATO") != null) {
                String tipoDato = this.getPropiedad("TIPODATO").toString();
                if (this.esTipoNumerico()) {
                    try {
                        if (Double.valueOf(valor.toString()).doubleValue() == Double.valueOf(this.getValorInicial()).doubleValue()) {
                            return true;
                        }
                    }
                    catch (Exception ex) {}
                } else if (tipoDato.equalsIgnoreCase("LOGICO")) {
                    try {
                        if (Boolean.valueOf(valor.toString()).booleanValue() == Boolean.valueOf(this.getValorInicial()).booleanValue()) {
                            return true;
                        }
                    }
                    catch (Exception ex) {}
                } else {
                    try {
                        if (valor.trim().equalsIgnoreCase(this.getValorInicial().trim())) {
                            return true;
                        }
                        if ((valor.equalsIgnoreCase("0") || valor.equalsIgnoreCase("")) && (tipoDato.equalsIgnoreCase("CADENA_NUMERICA") || tipoDato.equalsIgnoreCase("CADENA_NUMERICA_2"))) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public String getLanzaVentana() {
        try {
            return this.getPropiedad("LANZAVENTANA").toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public int getTamannioTotal() {
        try {
            if (this.getPropiedad("NUMEROENTEROS") != null && this.getPropiedad("NUMEROENTEROS").trim().length() > 0) {
                return Integer.parseInt(this.getPropiedad("NUMEROENTEROS")) + Integer.parseInt(this.getPropiedad("NUMERODECIMALES"));
            }
            if (this.getPropiedad("NUMERODECIMALES") != null && this.getPropiedad("NUMERODECIMALES").trim().length() > 0) {
                return Integer.parseInt(this.getPropiedad("LONGITUD")) + Integer.parseInt(this.getPropiedad("NUMERODECIMALES"));
            }
            return this.getTamannioCampo();
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int getTamannioCampo() {
        try {
            return Integer.valueOf(this.getPropiedad("LONGITUD").toString());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int getAdmiteNegativo() {
        try {
            String an = this.getPropiedad("ADMITENEGATIVOS").toString();
            if (an.equalsIgnoreCase("true") || an.equalsIgnoreCase("S") || an.equalsIgnoreCase("T")) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public boolean getMultiLinea() {
        try {
            return Integer.valueOf(this.getPropiedad("MULTILINEA").toString()) == 1;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean esTipoNumerico() {
        return this.getTipoDato().equalsIgnoreCase("ENTERO") || this.getTipoDato().equalsIgnoreCase("DOBLE") || this.getTipoDato().equalsIgnoreCase("BIGDECIMAL");
    }

    @Override
    public IRegEntrada clone() throws CloneNotSupportedException {
        RegEntrada r = new RegEntrada();
        Set<String> s = this.arrayDePropiedades.keySet();
        String campo = "";
        Iterator<String> it = s.iterator();
        while (it.hasNext()) {
            campo = it.next().toString();
            r.setPropiedad(campo, this.arrayDePropiedades.get(campo));
        }
        return r;
    }
}

