/*
 * Decompiled with CFR 0.152.
 */
package es.aeat.pftw.mtrc.configuracion;

import es.aeat.pftw.mtrc.configuracion.IGestorConfiguracion;
import es.aeat.pftw.mtrc.utilidades.FuncionesUtiles;
import es.aeat.pftw.mtrp.configuracion.IRegEntrada;
import es.aeat.pftw.mtrp.configuracion.IRegError;
import es.aeat.pftw.mtrp.configuracion.IRegRegla;
import es.aeat.pftw.mtrp.configuracion.IRegRelacionada;
import es.aeat.pftw.mtrp.configuracion.IRegTabla;
import es.aeat.pftw.mtrp.excepciones.ExceptionMotor;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GestorConfiguracion
implements IGestorConfiguracion,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String clave = null;
    protected boolean conexionAbierta = false;
    protected Map<String, IRegEntrada> conjuntoDeEntradas = new HashMap<String, IRegEntrada>();
    protected Map<String, IRegError> conjuntoDeErrores = new HashMap<String, IRegError>();
    protected Map<String, IRegRegla> conjuntoDeReglas = new HashMap<String, IRegRegla>();
    protected Map<String, List<String>> conjuntoDePartidaConReglas = new HashMap<String, List<String>>();
    protected Map<String, IRegRelacionada> conjuntoDeRelacionadas = new HashMap<String, IRegRelacionada>();
    protected Map<String, IRegTabla> conjuntoDeTablas = new HashMap<String, IRegTabla>();
    protected Map<String, List<String>> conjuntoDeCamposDeTabla = new HashMap<String, List<String>>();
    protected Map<String, String> conjuntoDeAlias2Ruta = new HashMap<String, String>();
    protected Map<String, String> conjuntoDeRuta2Alias = new HashMap<String, String>();
    protected boolean guardarEnMayusculas = false;

    @Override
    public IRegEntrada getEntrada(String nombreEntrada) throws ExceptionMotor {
        try {
            String entrada = FuncionesUtiles.getFuncionesUtiles().dameNombrePartidaSinParentesis(nombreEntrada);
            return this.getConjuntoDeEntradas().get(this.string2uppercase(entrada));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Entrada " + nombreEntrada);
        }
    }

    @Override
    public IRegError getError(long numeroError) throws ExceptionMotor {
        return this.getError(String.valueOf(numeroError));
    }

    @Override
    public IRegError getError(int numeroError) throws ExceptionMotor {
        return this.getError(String.valueOf(numeroError));
    }

    @Override
    public IRegError getError(String numeroError) throws ExceptionMotor {
        try {
            return this.getConjuntoDeErrores().get(numeroError);
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Error " + numeroError);
        }
    }

    @Override
    public IRegError getErrorIfExists(String numeroError) throws ExceptionMotor {
        try {
            return this.getConjuntoDeErrores().get(numeroError);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public IRegTabla getTablaNivel(int nivel) throws ExceptionMotor {
        try {
            Collection<IRegTabla> col = this.getConjuntoDeTablas().values();
            Iterator<IRegTabla> i = col.iterator();
            IRegTabla t = null;
            while (i.hasNext()) {
                t = i.next();
                if (t.getNivel() != nivel) continue;
                return t;
            }
            return null;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Nivel " + nivel);
        }
    }

    protected IRegTabla getTable(String nombreTabla) throws ExceptionMotor {
        try {
            IRegTabla ret = this.getConjuntoDeTablas().get(this.string2uppercase(nombreTabla));
            if (ret == null) {
                Collection<IRegTabla> col = this.getConjuntoDeTablas().values();
                Iterator<IRegTabla> i = col.iterator();
                IRegTabla t = null;
                while (i.hasNext()) {
                    t = i.next();
                    if (!t.getIdTabla().toUpperCase().equalsIgnoreCase(nombreTabla)) continue;
                    return t;
                }
            }
            return ret;
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public IRegTabla getTabla(String nombreTabla) throws ExceptionMotor {
        return this.getTable(nombreTabla);
    }

    @Override
    public List<String> getCamposDeTabla(String nombreTabla) throws ExceptionMotor {
        try {
            return this.getConjuntoDeCamposDeTabla().get(this.string2uppercase(nombreTabla));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    @Override
    public IRegRegla getRegla(long numeroRegla) throws ExceptionMotor {
        return this.getRegla(String.valueOf(numeroRegla));
    }

    @Override
    public IRegRegla getRegla(int numeroRegla) throws ExceptionMotor {
        return this.getRegla(String.valueOf(numeroRegla));
    }

    @Override
    public IRegRegla getRegla(String numeroRegla) throws ExceptionMotor {
        try {
            return this.getConjuntoDeReglas().get(this.string2uppercase(numeroRegla));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Regla " + numeroRegla);
        }
    }

    @Override
    public List<IRegRegla> getReglasDePartida(String nombrePartida) {
        try {
            List<String> res = this.getConjuntoDePartidaConReglas().get(this.string2uppercase(nombrePartida));
            if (res == null) {
                return new ArrayList<IRegRegla>();
            }
            ArrayList<IRegRegla> r = new ArrayList<IRegRegla>();
            for (int i = 0; i < res.size(); ++i) {
                r.add(this.getConjuntoDeReglas().get(res.get(i).toString()));
                if (r.get(r.size() - 1) != null) continue;
                r.remove(r.size() - 1);
            }
            return r;
        }
        catch (Exception ex) {
            return new ArrayList<IRegRegla>();
        }
    }

    @Override
    public Map<String, List<IRegRegla>> getReglasDePartidaClasificadas(String nombrePartida) {
        try {
            List<String> res = this.getConjuntoDePartidaConReglas().get(this.string2uppercase(nombrePartida));
            if (res == null) {
                return new HashMap<String, List<IRegRegla>>();
            }
            ArrayList<IRegRegla> grupoTipoRegla = null;
            IRegRegla reg = null;
            HashMap<String, List<IRegRegla>> ret = new HashMap<String, List<IRegRegla>>();
            String tipoRegla = "";
            for (int i = 0; i < res.size(); ++i) {
                reg = this.getConjuntoDeReglas().get(res.get(i));
                if (reg == null) continue;
                tipoRegla = reg.getTipoRegla().toString();
                grupoTipoRegla = (ArrayList<IRegRegla>)ret.get(tipoRegla);
                if (grupoTipoRegla == null) {
                    grupoTipoRegla = new ArrayList<IRegRegla>();
                }
                grupoTipoRegla.add(reg);
                ret.put(tipoRegla, grupoTipoRegla);
                grupoTipoRegla = null;
            }
            return ret;
        }
        catch (Exception ex) {
            return new HashMap<String, List<IRegRegla>>();
        }
    }

    @Override
    public IRegRelacionada getRelacionada(String nombreTabla) throws ExceptionMotor {
        try {
            return this.getConjuntoDeRelacionadas().get(this.string2uppercase(nombreTabla));
        }
        catch (ExceptionMotor ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex, "Tabla " + nombreTabla);
        }
    }

    protected String estimarLoQueGuardar(String nombreEntrada, String valor) throws Exception {
        try {
            if (nombreEntrada.equalsIgnoreCase("IDPARTIDA")) {
                return this.string2uppercase(valor);
            }
            if (nombreEntrada.equalsIgnoreCase("TIPODATO")) {
                return this.string2uppercase(valor);
            }
            if (nombreEntrada.equalsIgnoreCase("IDVARIABLE")) {
                return this.string2uppercase(valor);
            }
            if (nombreEntrada.equalsIgnoreCase("idTabla")) {
                return this.string2uppercase(valor);
            }
            return valor;
        }
        catch (Exception ex) {
            return this.string2uppercase(valor);
        }
    }

    @Override
    public abstract boolean abrirAlmacenamiento(List<Object> var1) throws ExceptionMotor;

    @Override
    public IGestorConfiguracion getGestorConfiguracionGeneradoSinDependencias() {
        return null;
    }

    protected boolean esRuta(Object obj) {
        try {
            File f = new File(obj.toString());
            if (f.exists()) {
                f = null;
                return true;
            }
            f = null;
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected boolean esInputStream(Object obj) {
        try {
            if ((InputStream)obj != null) {
                return true;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public boolean cerrarAlmacenamiento() throws ExceptionMotor {
        try {
            if (this.getConjuntoDeTablas() != null) {
                this.getConjuntoDeTablas().clear();
                this.setConjuntoDeTablas(null);
            }
            if (this.getConjuntoDePartidaConReglas() != null) {
                this.getConjuntoDePartidaConReglas().clear();
                this.setConjuntoDePartidaConReglas(null);
            }
            if (this.getConjuntoDeEntradas() != null) {
                this.getConjuntoDeEntradas().clear();
                this.setConjuntoDeEntradas(null);
            }
            if (this.getConjuntoDeErrores() != null) {
                this.getConjuntoDeErrores().clear();
                this.setConjuntoDeErrores(null);
            }
            if (this.getConjuntoDeReglas() != null) {
                this.getConjuntoDeReglas().clear();
                this.setConjuntoDeReglas(null);
            }
            if (this.getConjuntoDeRelacionadas() != null) {
                this.getConjuntoDeRelacionadas().clear();
                this.setConjuntoDeRelacionadas(null);
            }
            if (this.getConjuntoDeCamposDeTabla() != null) {
                this.getConjuntoDeCamposDeTabla().clear();
                this.setConjuntoDeCamposDeTabla(null);
            }
            if (this.getConjuntoDeAlias2Ruta() != null) {
                this.getConjuntoDeAlias2Ruta().clear();
                this.setConjuntoDeAlias2Ruta(null);
            }
            if (this.getConjuntoDeRuta2Alias() != null) {
                this.getConjuntoDeRuta2Alias().clear();
                this.setConjuntoDeRuta2Alias(null);
            }
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected String string2uppercase(String cadena) throws Exception {
        if (this.isGuardarEnMayusculas()) {
            return cadena.toUpperCase();
        }
        return cadena;
    }

    @Override
    public Map<String, IRegEntrada> getConjuntoDeEntradas() {
        return this.conjuntoDeEntradas;
    }

    @Override
    public Map<String, IRegError> getConjuntoDeErrores() {
        return this.conjuntoDeErrores;
    }

    @Override
    public Map<String, IRegRegla> getConjuntoDeReglas() {
        return this.conjuntoDeReglas;
    }

    @Override
    public Map<String, List<String>> getConjuntoDePartidaConReglas() {
        return this.conjuntoDePartidaConReglas;
    }

    @Override
    public Map<String, IRegRelacionada> getConjuntoDeRelacionadas() {
        return this.conjuntoDeRelacionadas;
    }

    @Override
    public Map<String, IRegTabla> getConjuntoDeTablas() {
        return this.conjuntoDeTablas;
    }

    @Override
    public Map<String, List<String>> getConjuntoDeCamposDeTabla() {
        return this.conjuntoDeCamposDeTabla;
    }

    @Override
    public void addConjuntoDeCamposDeTabla(String tabla) {
        this.getConjuntoDeCamposDeTabla().put(tabla, new ArrayList());
    }

    @Override
    public String getAlias(String path) {
        try {
            String ret = this.getConjuntoDeRuta2Alias().get(this.string2uppercase(path));
            if (ret == null) {
                return "";
            }
            return ret;
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public String getRuta(String alias) {
        try {
            String ret = this.getConjuntoDeAlias2Ruta().get(this.string2uppercase(alias));
            if (ret == null) {
                return "";
            }
            return ret;
        }
        catch (Exception ex) {
            return "";
        }
    }

    protected boolean sanearRelacionadas(Map<String, IRegRelacionada> nodo) throws ExceptionMotor {
        try {
            Set<String> s = nodo.keySet();
            String tabla = "";
            IRegRelacionada rel = null;
            List<String> relacionadas = null;
            ArrayList<String> relacionadasNueva = null;
            Iterator<String> it = s.iterator();
            while (it.hasNext()) {
                tabla = it.next().toString();
                rel = nodo.get(tabla);
                relacionadas = rel.getTablaRelacionada();
                if (relacionadas != null && relacionadas.size() > 1) {
                    relacionadasNueva = new ArrayList<String>();
                    for (int i = 0; i < relacionadas.size(); ++i) {
                        if (relacionadasNueva.contains(relacionadas.get(i))) continue;
                        relacionadasNueva.add(relacionadas.get(i));
                    }
                    if (relacionadasNueva.size() != relacionadas.size()) {
                        rel.setTablaRelacionada(relacionadasNueva);
                    }
                }
                relacionadasNueva = null;
                relacionadas = null;
                rel = null;
                tabla = "";
            }
            return true;
        }
        catch (Exception ex) {
            throw new ExceptionMotor(ex);
        }
    }

    protected void setConexionAbierta(boolean conexionAbierta) {
        this.conexionAbierta = conexionAbierta;
    }

    protected boolean isConexionAbierta() {
        return this.conexionAbierta;
    }

    protected void setConjuntoDeEntradas(Map<String, IRegEntrada> conjuntoDeEntradas) {
        this.conjuntoDeEntradas = conjuntoDeEntradas;
    }

    protected void setConjuntoDeErrores(Map<String, IRegError> conjuntoDeErrores) {
        this.conjuntoDeErrores = conjuntoDeErrores;
    }

    protected void setConjuntoDeReglas(Map<String, IRegRegla> conjuntoDeReglas) {
        this.conjuntoDeReglas = conjuntoDeReglas;
    }

    protected void setConjuntoDePartidaConReglas(Map<String, List<String>> conjuntoDePartidaConReglas) {
        this.conjuntoDePartidaConReglas = conjuntoDePartidaConReglas;
    }

    protected void setConjuntoDeRelacionadas(Map<String, IRegRelacionada> conjuntoDeRelacionadas) {
        this.conjuntoDeRelacionadas = conjuntoDeRelacionadas;
    }

    protected void setConjuntoDeTablas(Map<String, IRegTabla> conjuntoDeTablas) {
        this.conjuntoDeTablas = conjuntoDeTablas;
    }

    protected void setConjuntoDeCamposDeTabla(Map<String, List<String>> conjuntoDeCamposDeTabla) {
        this.conjuntoDeCamposDeTabla = conjuntoDeCamposDeTabla;
    }

    protected void setConjuntoDeAlias2Ruta(Map<String, String> conjuntoDeAlias2Ruta) {
        this.conjuntoDeAlias2Ruta = conjuntoDeAlias2Ruta;
    }

    protected Map<String, String> getConjuntoDeAlias2Ruta() {
        return this.conjuntoDeAlias2Ruta;
    }

    protected void setConjuntoDeRuta2Alias(Map<String, String> conjuntoDeRuta2Alias) {
        this.conjuntoDeRuta2Alias = conjuntoDeRuta2Alias;
    }

    protected Map<String, String> getConjuntoDeRuta2Alias() {
        return this.conjuntoDeRuta2Alias;
    }

    protected void setGuardarEnMayusculas(boolean guardarEnMayusculas) {
        this.guardarEnMayusculas = guardarEnMayusculas;
    }

    protected boolean isGuardarEnMayusculas() {
        return this.guardarEnMayusculas;
    }

    @Override
    public String getModKeyBBDD() {
        return this.clave;
    }

    @Override
    public void setModKeyBBDD(String clave) throws ExceptionMotor {
        this.clave = clave;
    }
}

