/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.IDateEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.MaskFormatter;

public class JTextFieldDateEditor
extends JFormattedTextField
implements IDateEditor,
CaretListener,
FocusListener,
ActionListener {
    private static final long serialVersionUID = -8901842591101625304L;
    protected Date date;
    protected SimpleDateFormat dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);
    protected MaskFormatter maskFormatter;
    protected String datePattern;
    protected String maskPattern;
    protected char placeholder;
    protected Color darkGreen;
    private boolean isMaskVisible;
    private boolean ignoreDatePatternChange;

    public JTextFieldDateEditor() {
        this(false, null, null, ' ');
    }

    public JTextFieldDateEditor(String datePattern, String maskPattern, char placeholder) {
        this(true, datePattern, maskPattern, placeholder);
    }

    public JTextFieldDateEditor(boolean showMask, String datePattern, String maskPattern, char placeholder) {
        this.dateFormatter.setLenient(false);
        if (datePattern == null) {
            this.datePattern = this.dateFormatter.toPattern();
        } else {
            this.datePattern = datePattern;
            this.dateFormatter.applyPattern(this.datePattern);
            this.ignoreDatePatternChange = true;
        }
        this.placeholder = placeholder;
        this.maskPattern = maskPattern == null ? this.createMaskFromDatePattern(this.datePattern) : maskPattern;
        this.setToolTipText(this.datePattern);
        this.setMaskVisible(showMask);
        this.addCaretListener(this);
        this.addFocusListener(this);
        this.addActionListener(this);
        this.darkGreen = new Color(0, 150, 0);
    }

    public Date getDate() {
        try {
            this.date = this.dateFormatter.parse(this.getText());
        }
        catch (ParseException e) {
            this.date = null;
        }
        return this.date;
    }

    public void setDate(Date date) {
        this.setDate(date, true);
    }

    protected void setDate(Date date, boolean firePropertyChange) {
        Date oldDate = this.date;
        this.date = date;
        if (date == null) {
            this.setText("");
        } else {
            String formattedDate = this.dateFormatter.format(date);
            try {
                this.setText(formattedDate);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.setForeground(Color.BLACK);
        if (firePropertyChange) {
            this.firePropertyChange("date", oldDate, date);
        }
    }

    public void setDateFormatString(String dateFormatString) {
        if (this.ignoreDatePatternChange) {
            return;
        }
        if (dateFormatString == null) {
            this.datePattern = this.dateFormatter.toPattern();
        } else {
            this.datePattern = dateFormatString;
            this.dateFormatter.applyPattern(this.datePattern);
        }
        this.setToolTipText(this.datePattern);
        this.setDate(this.date, false);
    }

    public String getDateFormatString() {
        return this.datePattern;
    }

    public JComponent getUiComponent() {
        return this;
    }

    public void caretUpdate(CaretEvent event) {
        String text = this.getText().trim();
        String emptyMask = this.maskPattern.replace('#', this.placeholder);
        if (text.length() == 0 || text.equals(emptyMask)) {
            this.setForeground(Color.BLACK);
            return;
        }
        try {
            this.dateFormatter.parse(this.getText());
            this.setForeground(this.darkGreen);
        }
        catch (Exception e) {
            this.setForeground(Color.RED);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        try {
            Date date = this.dateFormatter.parse(this.getText());
            this.setDate(date, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void setLocale(Locale locale) {
        if (locale == this.getLocale() || this.ignoreDatePatternChange) {
            return;
        }
        super.setLocale(locale);
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2, locale);
        this.setToolTipText(this.dateFormatter.toPattern());
        this.setDate(this.date, false);
        this.doLayout();
    }

    public String createMaskFromDatePattern(String datePattern) {
        String symbols = "GyMdkHmsSEDFwWahKzZ";
        String mask = "";
        int i = 0;
        while (i < datePattern.length()) {
            char ch = datePattern.charAt(i);
            boolean symbolFound = false;
            int n = 0;
            while (n < symbols.length()) {
                if (symbols.charAt(n) == ch) {
                    mask = String.valueOf(mask) + "#";
                    symbolFound = true;
                    break;
                }
                ++n;
            }
            if (!symbolFound) {
                mask = String.valueOf(mask) + ch;
            }
            ++i;
        }
        return mask;
    }

    public boolean isMaskVisible() {
        return this.isMaskVisible;
    }

    public void setMaskVisible(boolean isMaskVisible) {
        this.isMaskVisible = isMaskVisible;
        if (isMaskVisible && this.maskFormatter == null) {
            try {
                this.maskFormatter = new MaskFormatter(this.createMaskFromDatePattern(this.datePattern));
                this.maskFormatter.setPlaceholderCharacter(this.placeholder);
                this.maskFormatter.install(this);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.datePattern != null) {
            return new JTextField(this.datePattern).getPreferredSize();
        }
        return super.getPreferredSize();
    }

    public void actionPerformed(ActionEvent e) {
        this.focusLost(null);
    }
}

