/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.IDateEditor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;

public class JSpinnerDateEditor
extends JSpinner
implements IDateEditor,
FocusListener {
    private static final long serialVersionUID = 5692204052306085316L;
    protected Date date;
    protected String dateFormatString;
    protected SimpleDateFormat dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2);

    public JSpinnerDateEditor() {
        super(new SpinnerDateModel());
        ((JSpinner.DateEditor)this.getEditor()).getTextField().addFocusListener(this);
    }

    public Date getDate() {
        return ((SpinnerDateModel)this.getModel()).getDate();
    }

    public void setDate(Date date) {
        this.date = date;
        if (date == null) {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern("");
            ((JSpinner.DateEditor)this.getEditor()).getTextField().setText("");
        } else {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern(this.dateFormatString);
            ((SpinnerDateModel)this.getModel()).setValue(date);
        }
    }

    public void setDateFormatString(String dateFormatString) {
        if (dateFormatString == null) {
            this.dateFormatString = this.dateFormatter.toPattern();
        } else {
            this.dateFormatString = dateFormatString;
            this.dateFormatter.applyPattern(this.dateFormatString);
        }
        if (this.date != null) {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern(this.dateFormatString);
        } else {
            ((JSpinner.DateEditor)this.getEditor()).getFormat().applyPattern("");
        }
        if (this.date != null) {
            String text = this.dateFormatter.format(this.date);
            ((JSpinner.DateEditor)this.getEditor()).getTextField().setText(text);
        }
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public JComponent getUiComponent() {
        return this;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.dateFormatter = (SimpleDateFormat)DateFormat.getDateInstance(2, locale);
        this.setDateFormatString(null);
    }

    public void focusLost(FocusEvent focusEvent) {
        String text = ((JSpinner.DateEditor)this.getEditor()).getTextField().getText();
        if (text.length() == 0) {
            this.setDate(null);
        }
    }

    public void focusGained(FocusEvent e) {
    }
}

