/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputEncryptor;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    public CMSEnvelopedDataGenerator() {
    }

    public CMSEnvelopedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    private CMSEnvelopedData generate(final CMSProcessable content, String encryptionOID, int keySize, Provider encProvider, Provider provider) throws NoSuchAlgorithmException, CMSException {
        this.convertOldRecipients(this.rand, provider);
        JceCMSContentEncryptorBuilder builder = keySize != -1 ? new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(encryptionOID), keySize) : new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(encryptionOID));
        builder.setProvider(encProvider);
        builder.setSecureRandom(this.rand);
        return this.doGenerate(new CMSTypedData(){

            @Override
            public ASN1ObjectIdentifier getContentType() {
                return CMSObjectIdentifiers.data;
            }

            @Override
            public void write(OutputStream out) throws IOException, CMSException {
                content.write(out);
            }

            @Override
            public Object getContent() {
                return content;
            }
        }, builder.build());
    }

    private CMSEnvelopedData doGenerate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        if (!this.oldRecipientInfoGenerators.isEmpty()) {
            throw new IllegalStateException("can only use addRecipientGenerator() with this method");
        }
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            OutputStream cOut = contentEncryptor.getOutputStream(bOut);
            content.write(cOut);
            cOut.close();
        }
        catch (IOException e) {
            throw new CMSException("");
        }
        byte[] encryptedContent = bOut.toByteArray();
        AlgorithmIdentifier encAlgId = contentEncryptor.getAlgorithmIdentifier();
        BEROctetString encContent = new BEROctetString(encryptedContent);
        GenericKey encKey = contentEncryptor.getKey();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add(recipient.generate(encKey));
        }
        EncryptedContentInfo eci = new EncryptedContentInfo(content.getContentType(), encAlgId, encContent);
        BERSet unprotectedAttrSet = null;
        if (this.unprotectedAttributeGenerator != null) {
            AttributeTable attrTable = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            unprotectedAttrSet = new BERSet(attrTable.toASN1EncodableVector());
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.envelopedData, new EnvelopedData(this.originatorInfo, new DERSet(recipientInfos), eci, unprotectedAttrSet));
        return new CMSEnvelopedData(contentInfo);
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, encryptionOID, CMSUtils.getProvider(provider));
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        return this.generate(content, encryptionOID, -1, keyGen.getProvider(), provider);
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, int keySize, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, encryptionOID, keySize, CMSUtils.getProvider(provider));
    }

    public CMSEnvelopedData generate(CMSProcessable content, String encryptionOID, int keySize, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        return this.generate(content, encryptionOID, keySize, keyGen.getProvider(), provider);
    }

    public CMSEnvelopedData generate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        return this.doGenerate(content, contentEncryptor);
    }
}

