/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.perl;

import org.apache.oro.text.PatternCache;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.util.Cache;
import org.apache.oro.util.CacheLRU;

public final class Perl5Util
implements MatchResult {
    private static final String __matchExpression = "m?(\\W)(.*)\\1([imsx]*)";
    private final PatternCache __patternCache;
    private final Cache __expressionCache;
    private final Perl5Matcher __matcher = new Perl5Matcher();
    private Pattern __matchPattern;
    private MatchResult __lastMatch;

    Perl5Util(PatternCache cache) {
        this.__patternCache = cache;
        this.__expressionCache = new CacheLRU(cache.capacity());
        this.__compilePatterns();
    }

    public Perl5Util() {
        this(new PatternCacheLRU());
    }

    private void __compilePatterns() {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.__matchPattern = compiler.compile(__matchExpression, 16);
        }
        catch (MalformedPatternException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Pattern __parseMatchExpression(String pattern) throws MalformedPerl5PatternException {
        Object obj = this.__expressionCache.getElement(pattern);
        try {
            if (obj != null) {
                return (Pattern)obj;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (!this.__matcher.matches(pattern, this.__matchPattern)) {
            throw new MalformedPerl5PatternException("Invalid expression: " + pattern);
        }
        MatchResult result = this.__matcher.getMatch();
        String regex = result.group(2);
        int compileOptions = 0;
        String options = result.group(3);
        if (options != null) {
            int index = options.length();
            while (index-- > 0) {
                switch (options.charAt(index)) {
                    case 'i': {
                        compileOptions |= 1;
                        break;
                    }
                    case 'm': {
                        compileOptions |= 8;
                        break;
                    }
                    case 's': {
                        compileOptions |= 0x10;
                        break;
                    }
                    case 'x': {
                        compileOptions |= 0x20;
                        break;
                    }
                    default: {
                        throw new MalformedPerl5PatternException("Invalid options: " + options);
                    }
                }
            }
        }
        Pattern ret = this.__patternCache.getPattern(regex, compileOptions);
        this.__expressionCache.addElement(pattern, ret);
        return ret;
    }

    public synchronized boolean match(String pattern, char[] input) throws MalformedPerl5PatternException {
        this.__parseMatchExpression(pattern);
        boolean result = this.__matcher.contains(input, this.__parseMatchExpression(pattern));
        if (result) {
            this.__lastMatch = this.__matcher.getMatch();
        }
        return result;
    }

    public synchronized boolean match(String pattern, String input) throws MalformedPerl5PatternException {
        return this.match(pattern, input.toCharArray());
    }

    public synchronized MatchResult getMatch() {
        return this.__lastMatch;
    }

    @Override
    public synchronized int length() {
        return this.__lastMatch.length();
    }

    @Override
    public synchronized int groups() {
        return this.__lastMatch.groups();
    }

    @Override
    public synchronized String group(int group) {
        return this.__lastMatch.group(group);
    }

    @Override
    public synchronized int begin(int group) {
        return this.__lastMatch.begin(group);
    }

    @Override
    public synchronized int end(int group) {
        return this.__lastMatch.end(group);
    }

    @Override
    public synchronized int beginOffset(int group) {
        return this.__lastMatch.beginOffset(group);
    }

    @Override
    public synchronized int endOffset(int group) {
        return this.__lastMatch.endOffset(group);
    }

    @Override
    public synchronized String toString() {
        if (this.__lastMatch == null) {
            return null;
        }
        return this.__lastMatch.toString();
    }
}

