/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.UnsupportedTypeException;
import org.apache.oro.text.perl.Perl5Util;

public class MagicMatcher
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1109707428218614961L;
    private final ArrayList<MagicMatcher> subMatchers = new ArrayList(0);
    private MagicMatch match = null;

    public void setMatch(MagicMatch match) {
        this.match = match;
    }

    public MagicMatch getMatch() {
        return this.match;
    }

    public boolean isValid() {
        if (this.match == null || this.match.getTest() == null) {
            return false;
        }
        String type = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        String description = this.match.getDescription();
        String test = new String(this.match.getTest().array());
        return !type.equals("") && comparator != '\u0000' && (comparator == '=' || comparator == '!' || comparator == '>' || comparator == '<') && description != null && !description.equals("") && !test.equals("");
    }

    public void addSubMatcher(MagicMatcher m) {
        this.subMatchers.add(m);
    }

    public void setSubMatchers(Collection<MagicMatcher> a) {
        this.subMatchers.clear();
        this.subMatchers.addAll(a);
    }

    public Collection<MagicMatcher> getSubMatchers() {
        return this.subMatchers;
    }

    public MagicMatch test(File f, boolean onlyMimeMatch) throws IOException, UnsupportedTypeException {
        int offset = this.match.getOffset();
        this.match.getDescription();
        String type = this.match.getType();
        this.match.getMimeType();
        RandomAccessFile file = null;
        file = new RandomAccessFile(f, "r");
        int length = 0;
        if (type.equals("byte")) {
            length = 1;
        } else if (type.equals("short") || type.equals("leshort") || type.equals("beshort")) {
            length = 4;
        } else if (type.equals("long") || type.equals("lelong") || type.equals("belong")) {
            length = 8;
        } else if (type.equals("string")) {
            length = this.match.getTest().capacity();
        } else if (type.equals("regex")) {
            length = (int)file.length() - offset;
            if (length < 0) {
                length = 0;
            }
        } else if (type.equals("detector")) {
            length = (int)file.length() - offset;
            if (length < 0) {
                length = 0;
            }
        } else {
            throw new UnsupportedTypeException("unsupported test type '" + type + "'");
        }
        if ((long)length > file.length() - (long)offset) {
            return null;
        }
        byte[] buf = new byte[length];
        file.seek(offset);
        int bytesRead = 0;
        int size = 0;
        boolean done = false;
        while (!done) {
            size = file.read(buf, 0, length - bytesRead);
            if (size == -1) {
                file.close();
                throw new IOException("reached end of file before all bytes were read");
            }
            if ((bytesRead += size) != length) continue;
            done = true;
        }
        MagicMatch match1 = null;
        MagicMatch submatch = null;
        if (this.testInternal(buf)) {
            match1 = this.getMatch();
            if (!onlyMimeMatch && this.subMatchers != null && this.subMatchers.size() > 0) {
                int i = 0;
                while (i < this.subMatchers.size()) {
                    MagicMatcher m = this.subMatchers.get(i);
                    submatch = m.test(f, false);
                    if (submatch != null) {
                        match1.addSubMatch(submatch);
                    }
                    ++i;
                }
            }
        }
        MagicMatch magicMatch = match1;
        return magicMatch;
        finally {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
    }

    public MagicMatch test(byte[] data, boolean onlyMimeMatch) throws IOException, UnsupportedTypeException {
        int offset = this.match.getOffset();
        this.match.getDescription();
        String type = this.match.getType();
        this.match.getMimeType();
        int length = 0;
        if (type.equals("byte")) {
            length = 1;
        } else if (type.equals("short") || type.equals("leshort") || type.equals("beshort")) {
            length = 4;
        } else if (type.equals("long") || type.equals("lelong") || type.equals("belong")) {
            length = 8;
        } else if (type.equals("string")) {
            length = this.match.getTest().capacity();
        } else if (type.equals("regex")) {
            length = data.length - offset - 1;
            if (length < 0) {
                length = 0;
            }
        } else if (type.equals("detector")) {
            length = data.length - offset - 1;
            if (length < 0) {
                length = 0;
            }
        } else {
            throw new UnsupportedTypeException("unsupported test type " + type);
        }
        byte[] buf = new byte[length];
        if (offset + length < data.length) {
            System.arraycopy(data, offset, buf, 0, length);
            MagicMatch match1 = null;
            MagicMatch submatch = null;
            if (this.testInternal(buf)) {
                match1 = this.getMatch();
                if (!onlyMimeMatch && this.subMatchers != null && this.subMatchers.size() > 0) {
                    int i = 0;
                    while (i < this.subMatchers.size()) {
                        MagicMatcher m = this.subMatchers.get(i);
                        submatch = m.test(data, false);
                        if (submatch != null) {
                            match1.addSubMatch(submatch);
                        }
                        ++i;
                    }
                }
            }
            return match1;
        }
        return null;
    }

    private boolean testInternal(byte[] data) {
        if (data.length == 0) {
            return false;
        }
        String type = this.match.getType();
        String test = new String(this.match.getTest().array());
        this.match.getMimeType();
        this.match.getDescription();
        ByteBuffer buffer = ByteBuffer.allocate(data.length);
        if (type != null && test.length() > 0) {
            if (type.equals("string")) {
                buffer = buffer.put(data);
                return this.testString(buffer);
            }
            if (type.equals("byte")) {
                buffer = buffer.put(data);
                return this.testByte(buffer);
            }
            if (type.equals("short")) {
                buffer = buffer.put(data);
                return this.testShort(buffer);
            }
            if (type.equals("leshort")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                return this.testShort(buffer);
            }
            if (type.equals("beshort")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.BIG_ENDIAN);
                return this.testShort(buffer);
            }
            if (type.equals("long")) {
                buffer = buffer.put(data);
                return this.testLong(buffer);
            }
            if (type.equals("lelong")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                return this.testLong(buffer);
            }
            if (type.equals("belong")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.BIG_ENDIAN);
                return this.testLong(buffer);
            }
            if (type.equals("regex")) {
                return this.testRegex(new String(data));
            }
            if (type.equals("detector")) {
                buffer = buffer.put(data);
                return this.testDetector(buffer);
            }
        }
        return false;
    }

    private boolean testByte(ByteBuffer data) {
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        long bitmask = this.match.getBitmask();
        byte b = data.get(0);
        b = (byte)((long)b & bitmask);
        byte tst = Integer.decode(test).byteValue();
        byte t = (byte)(tst & 0xFF);
        switch (comparator) {
            case '=': {
                return t == b;
            }
            case '!': {
                return t != b;
            }
            case '>': {
                return t > b;
            }
            case '<': {
                return t < b;
            }
        }
        return false;
    }

    private boolean testString(ByteBuffer data) {
        ByteBuffer test = this.match.getTest();
        char comparator = this.match.getComparator();
        byte[] b = data.array();
        byte[] t = test.array();
        boolean diff = false;
        int i = 0;
        i = 0;
        while (i < t.length) {
            if (t[i] != b[i]) {
                diff = true;
                break;
            }
            ++i;
        }
        switch (comparator) {
            case '=': {
                return !diff;
            }
            case '!': {
                return diff;
            }
            case '>': {
                return t[i] > b[i];
            }
            case '<': {
                return t[i] < b[i];
            }
        }
        return false;
    }

    private boolean testShort(ByteBuffer data) {
        short val = 0;
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        long bitmask = this.match.getBitmask();
        val = MagicMatcher.byteArrayToShort(data);
        val = (short)(val & (short)bitmask);
        short tst = 0;
        try {
            tst = Integer.decode(test).shortValue();
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (comparator) {
            case '=': {
                return val == tst;
            }
            case '!': {
                return val != tst;
            }
            case '>': {
                return val > tst;
            }
            case '<': {
                return val < tst;
            }
        }
        return false;
    }

    private boolean testLong(ByteBuffer data) {
        long val = 0L;
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        long bitmask = this.match.getBitmask();
        val = MagicMatcher.byteArrayToLong(data);
        val &= bitmask;
        long tst = Long.decode(test);
        switch (comparator) {
            case '=': {
                return val == tst;
            }
            case '!': {
                return val != tst;
            }
            case '>': {
                return val > tst;
            }
            case '<': {
                return val < tst;
            }
        }
        return false;
    }

    private boolean testRegex(String text) {
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        Perl5Util utility = new Perl5Util();
        if (comparator == '=') {
            return utility.match(test, text);
        }
        if (comparator == '!') {
            return !utility.match(test, text);
        }
        return false;
    }

    private boolean testDetector(ByteBuffer data) {
        String detectorClassName = new String(this.match.getTest().array());
        try {
            Class<?> detectorClass = MagicMatcher.classForName(detectorClassName);
            Object detectorObject = detectorClass.newInstance();
            Method processMethod = detectorClass.getDeclaredMethod("process", byte[].class, Integer.TYPE, Integer.TYPE, Long.TYPE, Character.TYPE, String.class, Map.class);
            String[] types = (String[])processMethod.invoke(detectorObject, data.array(), this.match.getOffset(), this.match.getLength(), this.match.getBitmask(), Character.valueOf(this.match.getComparator()), this.match.getMimeType(), this.match.getProperties());
            if (types != null && types.length > 0) {
                this.match.setMimeType(types[0]);
                return true;
            }
        }
        catch (Throwable e) {
            Logger.getAnonymousLogger().warning(e.toString());
        }
        return false;
    }

    public String[] getDetectorExtensions() {
        String detectorClassName = new String(this.match.getTest().array()).trim();
        try {
            Class<?> detectorClass = MagicMatcher.classForName(detectorClassName);
            Object detectorObject = detectorClass.newInstance();
            Method getHandledTypesMethod = detectorClass.getDeclaredMethod("getHandledTypes", new Class[0]);
            return (String[])getHandledTypesMethod.invoke(detectorObject, new Object[0]);
        }
        catch (Exception e) {
            Logger.getLogger("es.gob.afirma").warning("Error cargando e instanciando la clase " + detectorClassName + ": " + e);
            e.printStackTrace();
            return new String[0];
        }
    }

    private static short byteArrayToShort(ByteBuffer data) {
        return data.getShort(0);
    }

    private static long byteArrayToLong(ByteBuffer data) {
        return data.getInt(0);
    }

    protected Object clone() throws CloneNotSupportedException {
        MagicMatcher clone = new MagicMatcher();
        clone.setMatch((MagicMatch)this.match.clone());
        Iterator<MagicMatcher> i = this.subMatchers.iterator();
        ArrayList<MagicMatcher> sub = new ArrayList<MagicMatcher>();
        while (i.hasNext()) {
            MagicMatcher m = i.next();
            sub.add((MagicMatcher)m.clone());
        }
        clone.setSubMatchers(sub);
        return clone;
    }

    static Class<?> classForName(String className) throws ClassNotFoundException {
        return MagicMatcher.getCleanClassLoader().loadClass(className);
    }

    private static ClassLoader getCleanClassLoader() {
        ClassLoader classLoader = MagicMatcher.class.getClassLoader();
        if (classLoader instanceof URLClassLoader && !classLoader.getClass().toString().contains("sun.plugin2.applet.JNLP2ClassLoader")) {
            ArrayList<URL> urls = new ArrayList<URL>();
            URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                if (url.toString().endsWith(".jar")) {
                    urls.add(url);
                }
                ++n2;
            }
            classLoader = new URLClassLoader(urls.toArray(new URL[0]));
        }
        return classLoader;
    }
}

