/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.CancelledOperationException;
import java.awt.Component;
import java.awt.Dimension;
import javax.security.auth.callback.PasswordCallback;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class UIPasswordCallback
extends PasswordCallback {
    private static final long serialVersionUID = 1719174318602363633L;
    private String message = null;
    private Component parent = null;
    private String title = null;

    public UIPasswordCallback(String prompt, Component parent, String message, String title) {
        super(prompt, false);
        this.parent = parent;
        this.message = prompt != null ? prompt : message;
        this.title = title;
    }

    @Override
    public char[] getPassword() {
        final JPasswordField pwd = new JPasswordField(10);
        JLabel lbText = new JLabel(this.message);
        lbText.setMinimumSize(new Dimension(lbText.getFontMetrics(lbText.getFont()).stringWidth(this.message), lbText.getSize().height));
        lbText.setLabelFor(pwd);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(lbText);
        panel.add(pwd);
        JOptionPane pane = new JOptionPane(panel, 3, 2, new ImageIcon(this.getClass().getResource("/dnie_logo.png"))){
            private static final long serialVersionUID = -3012522768561175760L;

            @Override
            public void selectInitialValue() {
                pwd.requestFocusInWindow();
            }
        };
        pane.createDialog(this.parent, this.title).setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return new char[0];
        }
        if ((Integer)selectedValue == 0) {
            return pwd.getPassword();
        }
        throw new CancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
    }
}

