/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.Timer;

final class JSecurePasswordLabel
extends JLabel {
    private static final long serialVersionUID = -4343328489072897605L;
    private final int delay = 500;
    private final char[] pass;
    private final int maxChars;
    int passwordLength;
    private Timer timer;
    private boolean showCursor;

    char[] getPass() {
        return this.pass;
    }

    Timer getTimer() {
        return this.timer;
    }

    int getMaxChars() {
        return this.maxChars;
    }

    JSecurePasswordLabel(int maxLength) {
        this.maxChars = maxLength;
        this.pass = new char[maxLength];
        this.clearPassword();
        this.addKeyListener(new KeyAdapter(){

            private boolean isValid(char c) {
                if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                    return true;
                }
                return c == '.' || c == '!' || c == '?' || c == '&' || c == '%' || c == '=' || c == '+' || c == '-' || c == '_' || c == '(' || c == ')' || c == '<' || c == '>';
            }

            @Override
            public void keyTyped(KeyEvent ke) {
                if (this.isValid(ke.getKeyChar()) && JSecurePasswordLabel.this.getPasswordLength() < JSecurePasswordLabel.this.getMaxChars()) {
                    JSecurePasswordLabel.this.getPass()[JSecurePasswordLabel.this.passwordLength++] = ke.getKeyChar();
                    ke.setKeyChar('\u0000');
                }
                JSecurePasswordLabel.this.updateText();
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyCode() == 8 && JSecurePasswordLabel.this.getPasswordLength() > 0) {
                    JSecurePasswordLabel.this.clearPassword(JSecurePasswordLabel.this.getPasswordLength() - 1);
                } else if (arg0.getKeyCode() == 127) {
                    JSecurePasswordLabel.this.clearPassword();
                }
                JSecurePasswordLabel.this.updateText();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                JSecurePasswordLabel.this.setBackground(Color.WHITE);
                JSecurePasswordLabel.this.getTimer().start();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                JSecurePasswordLabel.this.setShowCursor(false);
                JSecurePasswordLabel.this.setBackground(JSecurePasswordLabel.this.getParent().getBackground());
                JSecurePasswordLabel.this.getTimer().stop();
                JSecurePasswordLabel.this.updateText();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JSecurePasswordLabel.this.requestFocus();
            }
        });
        this.setFocusable(true);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setShowCursor(false);
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getSource().equals(JSecurePasswordLabel.this.getTimer()) && JSecurePasswordLabel.this.hasFocus()) {
                    JSecurePasswordLabel.this.setShowCursor(!JSecurePasswordLabel.this.getShowCursor());
                    JSecurePasswordLabel.this.updateText();
                }
            }
        });
        this.timer.stop();
    }

    synchronized void updateText() {
        String text = " ";
        int i = 0;
        while (i < this.passwordLength) {
            text = String.valueOf(text) + "*";
            ++i;
        }
        text = String.valueOf(text) + (this.getShowCursor() ? "|" : " ");
        this.setText(text);
    }

    void clearPassword() {
        this.clearPassword(0);
    }

    void clearPassword(int position) {
        int i = position;
        while (i < this.pass.length) {
            this.pass[i] = '\u0000';
            ++i;
        }
        this.passwordLength = position;
        this.updateText();
    }

    char[] getPassword() {
        char[] returned = new char[this.passwordLength];
        int i = 0;
        while (i < this.passwordLength) {
            returned[i] = this.pass[i];
            ++i;
        }
        this.clearPassword();
        return returned;
    }

    int getPasswordLength() {
        return this.passwordLength;
    }

    synchronized void setShowCursor(boolean show) {
        this.showCursor = show;
    }

    synchronized boolean getShowCursor() {
        return this.showCursor;
    }
}

