/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.CancelledOperationException;
import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.gui.GeneralConfig;
import es.gob.jmulticard.ui.passwordcallback.gui.IconLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.InfoLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.JAccessibilityCustomDialog;
import es.gob.jmulticard.ui.passwordcallback.gui.JSecurePasswordLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.RequestFocusListener;
import es.gob.jmulticard.ui.passwordcallback.gui.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;

public final class CustomDialog
extends JAccessibilityCustomDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private InfoLabel infoLabel = null;
    private JPanel buttonsPanel = null;
    private JPanel accessibilityButtonsPanel = null;
    private JPanel mainPanel = null;
    private JSecurePasswordLabel component = null;
    private final IconLabel iconLabel = new IconLabel();
    private static JButton okButton = null;
    private JButton noButton = null;
    private static JButton cancelButton = null;
    private JButton restoreButton = null;
    private JButton maximizeButton = null;
    private int answer;
    private static String cancellText = Messages.getString("PrincipalGUI.cancelar");

    JSecurePasswordLabel getComponent() {
        return this.component;
    }

    static JButton getOkButton() {
        return okButton;
    }

    JButton getNoButton() {
        return this.noButton;
    }

    static JButton getCancelButton() {
        return cancelButton;
    }

    JButton getRestoreButton() {
        return this.restoreButton;
    }

    JButton getMaximizeButton() {
        return this.maximizeButton;
    }

    private CustomDialog(JDialog componentParent, boolean modal, String message, String title, int typeMessage, boolean isInputDialog) {
        super(componentParent, modal, isInputDialog);
        this.initComponents(message, title, typeMessage, isInputDialog);
        this.setLocationRelativeTo(componentParent);
        this.pack();
    }

    private CustomDialog(Component componentParent, boolean modal, String message, String title, int typeMessage, boolean isInputDialog) {
        super(isInputDialog);
        this.setModal(modal);
        this.initComponents(message, title, typeMessage, isInputDialog);
        this.setLocationRelativeTo(componentParent);
        this.pack();
    }

    private CustomDialog(JFrame componentParent, boolean modal, String message, String title, int typeMessage, boolean isInputDialog) {
        super(componentParent, modal, isInputDialog);
        this.initComponents(message, title, typeMessage, isInputDialog);
        this.setLocationRelativeTo(componentParent);
        this.pack();
    }

    private static int getInitialX(int width) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return screenSize.width / 2 - width / 2;
    }

    private static int getInitialY(int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return screenSize.height / 2 - height / 2;
    }

    private void initComponents(String message, String title, int typeMessage, boolean isInputDialog) {
        int maxWidth = this.getMaxWidth();
        int maxHeight = this.getMaxHeight();
        this.setMinimumSize(new Dimension(this.getInitialWidth(), this.getInitialHeight()));
        this.setPreferredSize(new Dimension(this.getInitialWidth(), this.getInitialHeight()));
        this.setMaximumSize(new Dimension(maxWidth, maxHeight));
        if (GeneralConfig.isMaximized()) {
            this.setBounds(0, 0, maxWidth, maxHeight);
        } else if (GeneralConfig.isBigFontSize() || GeneralConfig.isFontBold()) {
            this.setMinimumSize(new Dimension(555, 250));
        }
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.answer = 1;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 10, 0, 10);
        this.setIconLabel();
        JPanel iconPanel = new JPanel(new GridBagLayout());
        GridBagConstraints consIconPanel = new GridBagConstraints();
        consIconPanel.fill = 1;
        iconPanel.add((Component)this.iconLabel, consIconPanel);
        c.insets = new Insets(10, 5, 0, 10);
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        if (isInputDialog) {
            this.infoLabel = new InfoLabel(message);
            this.infoLabel.setHorizontalAlignment(2);
            this.infoLabel.setVerticalAlignment(0);
        } else {
            this.infoLabel = new InfoLabel(message, false);
            this.infoLabel.setHorizontalAlignment(0);
            this.infoLabel.addAncestorListener(new RequestFocusListener());
            this.infoLabel.setVerticalAlignment(0);
        }
        this.mainPanel.add((Component)this.infoLabel, c);
        this.createMainButtonsPanel();
        this.createAccessibilityButtonsPanel();
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 2;
        cons.gridheight = 1;
        cons.weighty = 0.0;
        cons.weightx = 0.1;
        container.add((Component)this.accessibilityButtonsPanel, cons);
        cons.gridx = 2;
        cons.gridy = 0;
        cons.gridwidth = 6;
        cons.gridheight = isInputDialog ? 2 : 3;
        cons.weighty = isInputDialog ? 0.35 : 0.65;
        cons.weightx = 0.9;
        container.add((Component)this.mainPanel, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 2;
        cons.gridheight = 3;
        cons.weighty = 0.9;
        cons.weightx = 0.0;
        container.add((Component)iconPanel, cons);
        cons.gridx = 2;
        cons.gridy = 3;
        cons.gridwidth = 6;
        cons.gridheight = 1;
        cons.weighty = isInputDialog ? 0.65 : 0.35;
        cons.weightx = 0.0;
        container.add((Component)this.buttonsPanel, cons);
        this.pack();
    }

    private void setIconLabel() {
        ImageIcon icon = new ImageIcon(CustomDialog.class.getResource("/images/dnie.png"));
        Dimension dimensionInicial = new Dimension(100, (int)(100.0f / (float)icon.getIconWidth() * (float)icon.getIconHeight()));
        this.iconLabel.setOriginalIcon(icon);
        this.iconLabel.setOriginalDimension(dimensionInicial);
        icon = new ImageIcon(icon.getImage().getScaledInstance(dimensionInicial.width, dimensionInicial.height, 4));
        this.iconLabel.setIcon(icon);
    }

    private void createAccessibilityButtonsPanel() {
        this.accessibilityButtonsPanel = new JPanel(new GridBagLayout());
        final JWindow tip = new JWindow();
        final JLabel tipText = new JLabel();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints consButtons = new GridBagConstraints();
        consButtons.fill = 1;
        consButtons.gridx = 0;
        consButtons.gridy = 0;
        consButtons.weightx = 1.0;
        consButtons.weighty = 1.0;
        consButtons.insets = new Insets(0, 0, 0, 0);
        JPanel restorePanel = new JPanel();
        ImageIcon imageIconRestore = new ImageIcon(CustomDialog.class.getResource("/images/restore.png"));
        this.restoreButton = new JButton(imageIconRestore);
        this.restoreButton.setMnemonic(82);
        this.restoreButton.setToolTipText(Messages.getString("Wizard.restaurar.description"));
        this.restoreButton.getAccessibleContext().setAccessibleName(this.restoreButton.getToolTipText());
        this.restoreButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                Utils.showToolTip(false, tip, CustomDialog.this.getRestoreButton(), tipText);
            }

            @Override
            public void focusGained(FocusEvent e) {
                Utils.showToolTip(true, tip, CustomDialog.this.getRestoreButton(), tipText);
            }
        });
        Dimension dimension = new Dimension(20, 20);
        this.restoreButton.setPreferredSize(dimension);
        this.restoreButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (10 == ke.getKeyCode()) {
                    CustomDialog.this.getRestoreButton().doClick();
                }
            }
        });
        this.restoreButton.setName("restaurar");
        restorePanel.add(this.restoreButton);
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomDialog.this.restaurarActionPerformed();
            }
        });
        Utils.remarcar(this.restoreButton);
        panel.add((Component)restorePanel, consButtons);
        consButtons.gridx = 1;
        consButtons.insets = new Insets(0, 0, 0, 0);
        JPanel maximizePanel = new JPanel();
        ImageIcon imageIconMaximize = new ImageIcon(CustomDialog.class.getResource("/images/maximize.png"));
        this.maximizeButton = new JButton(imageIconMaximize);
        this.maximizeButton.setMnemonic(77);
        this.maximizeButton.setToolTipText(Messages.getString("Wizard.maximizar.description"));
        this.maximizeButton.getAccessibleContext().setAccessibleName(this.maximizeButton.getToolTipText());
        this.maximizeButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (10 == ke.getKeyCode()) {
                    CustomDialog.this.getMaximizeButton().doClick();
                }
            }
        });
        this.maximizeButton.setName("maximizar");
        this.maximizeButton.setPreferredSize(dimension);
        Utils.remarcar(this.maximizeButton);
        maximizePanel.add(this.maximizeButton);
        this.maximizeButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                Utils.showToolTip(false, tip, CustomDialog.this.getMaximizeButton(), tipText);
            }

            @Override
            public void focusGained(FocusEvent e) {
                Utils.showToolTip(true, tip, CustomDialog.this.getMaximizeButton(), tipText);
            }
        });
        this.maximizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomDialog.this.maximizarActionPerformed();
            }
        });
        panel.add((Component)maximizePanel, consButtons);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 15;
        this.accessibilityButtonsPanel.add((Component)panel, c);
        if (GeneralConfig.isMaximized()) {
            this.maximizeButton.setEnabled(false);
            this.restoreButton.setEnabled(true);
        } else {
            this.maximizeButton.setEnabled(true);
            this.restoreButton.setEnabled(false);
        }
    }

    void createMainButtonsPanel() {
        this.buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints consButtons = new GridBagConstraints();
        consButtons.fill = 0;
        consButtons.gridx = 0;
        consButtons.gridy = 0;
        consButtons.insets = new Insets(0, 10, 0, 10);
        consButtons.anchor = 10;
        JPanel okPanel = new JPanel();
        okButton = this.getButton(Messages.getString("PrincipalGUI.aceptar"), 65);
        okButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (10 == ke.getKeyCode()) {
                    CustomDialog.getOkButton().doClick();
                }
            }
        });
        okPanel.add(okButton);
        this.buttonsPanel.add((Component)okPanel, consButtons);
        okButton.addActionListener(this);
    }

    public static int showConfirmDialog(Component componentParent, boolean modal, String message, String title, int typeOption, int typeMessage) {
        CustomDialog customDialog = CustomDialog.getInstanceCustomDialog(componentParent, modal, message, title, typeMessage, false);
        okButton.setEnabled(true);
        customDialog.getRootPane().setDefaultButton(null);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.gridy = 0;
        cons.insets = new Insets(0, 0, 0, 10);
        if (typeOption != 0) {
            throw new UnsupportedOperationException("Solo se soportan dialogos de tipo Si/No");
        }
        okButton.setText(Messages.getString("CustomDialog.confirmDialog.yes"));
        okButton.setMnemonic(83);
        customDialog.noButton = customDialog.getButton(Messages.getString("CustomDialog.confirmDialog.no"), 78);
        customDialog.noButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (10 == ke.getKeyCode()) {
                    CustomDialog.this.getNoButton().doClick();
                }
            }
        });
        JPanel noPanel = new JPanel();
        noPanel.add(customDialog.noButton);
        customDialog.buttonsPanel.add((Component)noPanel, cons);
        customDialog.noButton.addActionListener(customDialog);
        customDialog.infoLabel.setHorizontalAlignment(0);
        customDialog.pack();
        customDialog.setSize(customDialog.getInitialWidth() + 1, customDialog.getInitialHeight() + 1);
        customDialog.setVisible(true);
        return customDialog.getAnswer();
    }

    public static char[] showInputPasswordDialog(Component componentParent, boolean modal, boolean beep, String message, int mnemonic, String title, int typeMessage) {
        CustomDialog customDialog = CustomDialog.getInstanceCustomDialog(componentParent, modal, message, title, typeMessage, true);
        okButton.setEnabled(false);
        customDialog.getRootPane().setDefaultButton(null);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.5;
        c.gridwidth = 2;
        c.insets = new Insets(2, 5, 2, 10);
        customDialog.component = new JSecurePasswordLabel(16);
        customDialog.component.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent ke) {
                int length = CustomDialog.this.getComponent().getPasswordLength();
                if (length > 7 && length < 17) {
                    CustomDialog.getOkButton().setEnabled(true);
                    if (10 == ke.getKeyCode()) {
                        CustomDialog.getOkButton().doClick();
                    }
                } else {
                    CustomDialog.getOkButton().setEnabled(false);
                }
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
        customDialog.component.addAncestorListener(new RequestFocusListener());
        Utils.remarcar(customDialog.component);
        Utils.setContrastColor(customDialog.component);
        Utils.setFontBold(customDialog.component);
        customDialog.component.getAccessibleContext().setAccessibleName(String.valueOf(message.replaceAll("<br>", "")) + "  ALT + " + mnemonic + ". ");
        customDialog.mainPanel.add((Component)customDialog.component, c);
        customDialog.infoLabel.setLabelFor(customDialog.component);
        customDialog.infoLabel.setDisplayedMnemonic(mnemonic);
        String text = Utils.remarkMnemonic(customDialog.infoLabel.getText(), mnemonic);
        customDialog.infoLabel.setText(text);
        c.insets = new Insets(0, 0, 0, 10);
        c.gridy = 2;
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(0, 0, 0, 10);
        cancelButton = customDialog.getButton(cancellText, 67);
        JPanel cancelPanel = new JPanel();
        cancelPanel.add(cancelButton);
        customDialog.buttonsPanel.add((Component)cancelPanel, cons);
        cancelButton.addActionListener(customDialog);
        cancelButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (10 == ke.getKeyCode()) {
                    CustomDialog.getCancelButton().doClick();
                }
            }
        });
        customDialog.infoLabel.setHorizontalAlignment(2);
        customDialog.component.setVisible(true);
        cancelButton.addActionListener(customDialog);
        customDialog.pack();
        customDialog.setSize(customDialog.getInitialWidth() + 1, customDialog.getInitialHeight() + 1);
        customDialog.setVisible(true);
        if (customDialog.getAnswer() == 0) {
            char[] finalPin = customDialog.getComponent().getPassword();
            customDialog.getComponent().setText("");
            customDialog.getComponent().setText(null);
            customDialog.component = null;
            customDialog.dispose();
            System.runFinalization();
            System.gc();
            return finalPin;
        }
        throw new CancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
    }

    private JButton getButton(String text, int mnemonic) {
        JButton button = new JButton(text);
        button.setMnemonic(mnemonic);
        Utils.remarcar(button);
        Utils.setContrastColor(button);
        Utils.setFontBold(button);
        if (text.equalsIgnoreCase(cancellText)) {
            String cancelKey = "cancel";
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.getRootPane().getActionMap().put("cancel", new ButtonAbstractAction());
        }
        return button;
    }

    @Override
    public int getMinimumRelation() {
        return 7;
    }

    private int getAnswer() {
        return this.answer;
    }

    void maximizarActionPerformed() {
        CustomDialog.setActualPositionX(this.getX());
        CustomDialog.setActualPositionY(this.getY());
        CustomDialog.setActualWidth(this.getWidth());
        CustomDialog.setActualHeight(this.getHeight());
        int maxWidth = this.getMaxWidth();
        int maxHeight = this.getMaxHeight();
        this.setBounds(CustomDialog.getInitialX(maxWidth), CustomDialog.getInitialY(maxHeight), maxWidth, maxHeight);
        this.maximizeButton.setEnabled(false);
        this.restoreButton.setEnabled(true);
    }

    void restaurarActionPerformed() {
        int minWidth = this.getInitialWidth();
        int minHeight = this.getInitialHeight();
        if (GeneralConfig.isBigFontSize() || GeneralConfig.isFontBold() || this.isBigSizeDefault()) {
            minWidth = 555;
            minHeight = 250;
        }
        this.setMinimumSize(new Dimension(minWidth, minHeight));
        if (CustomDialog.getActualPositionX() != -1 && CustomDialog.getActualPositionY() != -1 && CustomDialog.getActualWidth() != -1 && CustomDialog.getActualHeight() != -1) {
            this.setBounds(CustomDialog.getActualPositionX(), CustomDialog.getActualPositionY(), CustomDialog.getActualWidth(), CustomDialog.getActualHeight());
        } else {
            this.setBounds(CustomDialog.getInitialX(minWidth), CustomDialog.getInitialY(minHeight), minWidth, minHeight);
        }
        this.maximizeButton.setEnabled(true);
        this.restoreButton.setEnabled(false);
    }

    static CustomDialog getInstanceCustomDialog(Component componentParent, boolean modal, String message, String title, int typeMessage, boolean isInputDialog) {
        CustomDialog customDialog = null;
        customDialog = componentParent instanceof JDialog ? new CustomDialog((JDialog)componentParent, modal, message, title, typeMessage, isInputDialog) : (componentParent instanceof JFrame ? new CustomDialog((JFrame)componentParent, modal, message, title, typeMessage, isInputDialog) : new CustomDialog(componentParent, modal, message, title, typeMessage, isInputDialog));
        return customDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.answer = e.getSource().equals(okButton) ? 0 : (e.getSource().equals(this.noButton) ? 1 : 2);
        this.setVisible(false);
    }

    private static final class ButtonAbstractAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ButtonAbstractAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CustomDialog.getCancelButton().doClick();
        }
    }
}

