/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.CancelledOperationException;
import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.NoConsoleException;
import java.io.Console;
import javax.security.auth.callback.PasswordCallback;

final class ConsolePasswordCallback
extends PasswordCallback {
    private static final long serialVersionUID = -4044214967262414899L;
    private final String prompt;

    ConsolePasswordCallback(String p) {
        super(p, true);
        this.prompt = p;
    }

    private static String removeHTML(String input) {
        return input.replace("<br/>", "").replaceAll("&nbsp;", "");
    }

    @Override
    public char[] getPassword() {
        Console console = System.console();
        if (console == null) {
            throw new NoConsoleException("No hay consola para solicitar el PIN");
        }
        char[] password = console.readPassword(String.valueOf(ConsolePasswordCallback.removeHTML(this.prompt)) + ":\n", new Object[0]);
        if (password == null) {
            throw new CancelledOperationException("Se ha cancelado la introduccion de PIN en consola");
        }
        if (password.length < 8 || password.length > 16) {
            console.printf(String.valueOf(Messages.getString("ConsolePasswordCallback.1")) + "\n", new Object[0]);
            int i = 0;
            while (i < password.length) {
                password[i] = '\u0000';
                ++i;
            }
            return this.getPassword();
        }
        console.flush();
        console = null;
        return password;
    }
}

