/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.PasswordCallbackManager;
import es.gob.jmulticard.ui.passwordcallback.gui.ConsolePasswordCallback;
import es.gob.jmulticard.ui.passwordcallback.gui.UIPasswordCallbackAccessibility;
import java.awt.HeadlessException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class CommonPasswordCallback
extends PasswordCallback {
    private static boolean headless = false;
    private static final long serialVersionUID = 5514503307266079255L;
    private final String title;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                CommonPasswordCallback.setHeadLess(Boolean.getBoolean("java.awt.headless"));
                return null;
            }
        });
    }

    static void setHeadLess(boolean hl) {
        headless = hl;
    }

    private CommonPasswordCallback(String prompt, String title) {
        super(prompt, true);
        if (prompt == null) {
            throw new IllegalArgumentException("El texto de solicitud no puede ser nulo");
        }
        this.title = title == null ? prompt : title;
    }

    @Override
    public char[] getPassword() {
        if (!headless) {
            try {
                UIPasswordCallbackAccessibility psc = new UIPasswordCallbackAccessibility(this.getPrompt(), PasswordCallbackManager.getDialogOwner(), this.getPrompt(), 80, this.title);
                char[] pss = psc.getPassword();
                psc.clearPassword();
                psc = null;
                return pss;
            }
            catch (HeadlessException e) {
                Logger.getLogger("es.gob.jmulticard").info("No hay entorno grafico, se revierte a consola: " + e);
            }
        }
        ConsolePasswordCallback cpc = new ConsolePasswordCallback(this.getPrompt());
        char[] pss = cpc.getPassword();
        cpc.clearPassword();
        cpc = null;
        return pss;
    }

    public static PasswordCallback getDnieBadPinPasswordCallback(int retriesLeft) {
        return new CommonPasswordCallback(String.valueOf(Messages.getString("CommonPasswordCallback.0")) + " " + Integer.toString(retriesLeft), Messages.getString("CommonPasswordCallback.1"));
    }

    public static PasswordCallback getDniePinForCertificateReadingPasswordCallback() {
        return new CommonPasswordCallback(Messages.getString("CommonPasswordCallback.4"), Messages.getString("CommonPasswordCallback.1"));
    }
}

