/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.iso7816four;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.StatusWord;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.apdu.iso7816four.GetChallengeApduCommand;
import es.gob.jmulticard.apdu.iso7816four.MseSetVerificationKeyApduCommand;
import es.gob.jmulticard.apdu.iso7816four.ReadBinaryApduCommand;
import es.gob.jmulticard.apdu.iso7816four.SelectDfByNameApduCommand;
import es.gob.jmulticard.apdu.iso7816four.SelectFileApduResponse;
import es.gob.jmulticard.apdu.iso7816four.SelectFileByIdApduCommand;
import es.gob.jmulticard.apdu.iso7816four.VerifyApduCommand;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.SmartCard;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.security.auth.callback.PasswordCallback;

public abstract class Iso7816FourCard
extends SmartCard {
    private static final byte ERROR_PIN_SW1 = 99;
    private static final boolean PIN_AUTO_RETRY = true;

    public Iso7816FourCard(byte c, ApduConnection conn) throws ApduConnectionException {
        super(c, conn);
    }

    private ResponseApdu readBinary(byte msbOffset, byte lsbOffset, byte readLength) throws ApduConnectionException {
        ResponseApdu res = this.getConnection().transmit(new ReadBinaryApduCommand(this.getCla(), msbOffset, lsbOffset, readLength));
        if (res.isOk()) {
            return res;
        }
        throw new ApduConnectionException("Respuesta invalida en la lectura de binario con el codigo: " + res.getStatusWord());
    }

    public byte[] readBinaryComplete(int len) throws IOException {
        int off = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (off < len) {
            byte msbOffset = (byte)(off >> 8);
            byte lsbOffset = (byte)(off & 0xFF);
            int left = len - off;
            ResponseApdu readResponse = left < 239 ? this.readBinary(msbOffset, lsbOffset, (byte)left) : this.readBinary(msbOffset, lsbOffset, (byte)-17);
            if (!readResponse.isOk()) {
                return readResponse.getStatusWord().getBytes();
            }
            out.write(readResponse.getData());
            off += 239;
        }
        return out.toByteArray();
    }

    public void selectFileByName(String name) throws ApduConnectionException, FileNotFoundException {
        ResponseApdu response = this.getConnection().transmit(new SelectDfByNameApduCommand(this.getCla(), name.getBytes()));
        if (response.isOk()) {
            return;
        }
        if (HexUtils.arrayEquals(response.getBytes(), new byte[]{106, -126})) {
            throw new FileNotFoundException(name);
        }
    }

    public int selectFileById(byte[] id) throws ApduConnectionException, Iso7816FourCardException {
        ResponseApdu res = this.getConnection().transmit(new SelectFileByIdApduCommand(this.getCla(), id));
        if (HexUtils.arrayEquals(res.getBytes(), new byte[]{106, -126})) {
            throw new FileNotFoundException(id);
        }
        SelectFileApduResponse response = new SelectFileApduResponse(res);
        if (response.isOk()) {
            return response.getFileLength();
        }
        StatusWord sw = response.getStatusWord();
        if (sw.equals(new StatusWord(106, -126))) {
            throw new FileNotFoundException(id);
        }
        throw new Iso7816FourCardException(sw);
    }

    public byte[] selectFileByIdAndRead(byte[] id) throws Iso7816FourCardException, IOException {
        int fileLength = this.selectFileById(id);
        return this.readBinaryComplete(fileLength);
    }

    public int selectFileByLocation(Location location) throws ApduConnectionException, Iso7816FourCardException {
        int fileLength = 0;
        Location loc = location;
        this.selectMasterFile();
        while (loc != null) {
            byte[] id = loc.getFile();
            fileLength = this.selectFileById(id);
            loc = loc.getChild();
        }
        return fileLength;
    }

    public byte[] selectFileByLocationAndRead(Location location) throws IOException, Iso7816FourCardException {
        int fileLenght = this.selectFileByLocation(location);
        return this.readBinaryComplete(fileLenght);
    }

    protected abstract void selectMasterFile() throws ApduConnectionException, FileNotFoundException;

    public void setPublicKeyToVerification(byte[] refPublicKey) throws SecureChannelException, ApduConnectionException {
        MseSetVerificationKeyApduCommand apdu = new MseSetVerificationKeyApduCommand(0, refPublicKey);
        ResponseApdu res = this.getConnection().transmit(apdu);
        if (!res.isOk()) {
            throw new SecureChannelException("Error al seleccionar una clave publica para verificacion. Se obtuvo el error: " + HexUtils.hexify(res.getBytes(), true));
        }
    }

    public byte[] getChallenge() throws ApduConnectionException {
        ResponseApdu res = this.getConnection().transmit(new GetChallengeApduCommand(0));
        if (res.isOk()) {
            return res.getData();
        }
        throw new ApduConnectionException("Respuesta invalida en la obtencion de desafio con el codigo: " + res.getStatusWord());
    }

    public void verifyPin(PasswordCallback pinPc) throws ApduConnectionException, BadPinException {
        this.verifyPin(pinPc, Integer.MAX_VALUE);
    }

    private void verifyPin(PasswordCallback pinPc, int retriesLeft) throws ApduConnectionException, BadPinException {
        PasswordCallback psc = null;
        try {
            Class<?> commonPasswordCallbackClass;
            if (pinPc != null) {
                psc = pinPc;
            } else if (retriesLeft < Integer.MAX_VALUE) {
                commonPasswordCallbackClass = Class.forName("es.gob.jmulticard.ui.passwordcallback.gui.CommonPasswordCallback");
                Method getDnieBadPinPasswordCallbackMethod = commonPasswordCallbackClass.getMethod("getDnieBadPinPasswordCallback", Integer.TYPE);
                psc = (PasswordCallback)getDnieBadPinPasswordCallbackMethod.invoke(null, retriesLeft);
            } else {
                commonPasswordCallbackClass = Class.forName("es.gob.jmulticard.ui.passwordcallback.gui.CommonPasswordCallback");
                Method getDniePinForCertificateReadingPasswordCallbackMethod = commonPasswordCallbackClass.getMethod("getDniePinForCertificateReadingPasswordCallback", new Class[0]);
                psc = (PasswordCallback)getDniePinForCertificateReadingPasswordCallbackMethod.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("pinPc no puede ser nulo cuando no hay un PasswordCallback por defecto", e);
        }
        VerifyApduCommand verifyCommandApdu = new VerifyApduCommand(0, psc);
        ResponseApdu verifyResponse = this.getConnection().transmit(verifyCommandApdu);
        verifyCommandApdu = null;
        psc.clearPassword();
        if (!verifyResponse.isOk()) {
            if (verifyResponse.getStatusWord().getMsb() == 99) {
                this.verifyPin(pinPc, verifyResponse.getStatusWord().getLsb() - -64);
            } else if (verifyResponse.getStatusWord().getMsb() == 105 && verifyResponse.getStatusWord().getLsb() == -125) {
                throw new AuthenticationModeLockedException();
            }
        }
    }
}

