/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class FakeX509Certificate
extends X509Certificate {
    private static final long serialVersionUID = 1L;
    private final Principal subjectDn;
    private final Principal issuerDn;
    private final BigInteger serialNumber;
    private final boolean authCert;

    FakeX509Certificate(String subject, String issuer, BigInteger serial, boolean auth) {
        this.subjectDn = new X500Principal(subject);
        this.issuerDn = new X500Principal(issuer);
        this.serialNumber = serial;
        this.authCert = auth;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        HashSet<String> set = new HashSet<String>(2);
        set.add("2.5.29.15");
        set.add("2.5.29.19");
        return set;
    }

    @Override
    public byte[] getExtensionValue(String e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("2.5.29.14");
        set.add("2.5.29.9");
        set.add("1.3.6.1.5.5.7.1.1");
        set.add("1.3.6.1.5.5.7.1.2");
        set.add("2.16.724.1.2.2.4.1");
        set.add("2.5.29.32");
        set.add("1.3.6.1.5.5.7.1.3");
        set.add("2.5.29.35");
        return set;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
    }

    @Override
    public void checkValidity(Date d) throws CertificateExpiredException, CertificateNotYetValidException {
    }

    @Override
    public int getBasicConstraints() {
        return -1;
    }

    @Override
    public Principal getIssuerDN() {
        return this.issuerDn;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getKeyUsage() {
        if (this.authCert) {
            boolean[] blArray = new boolean[9];
            blArray[0] = true;
            return blArray;
        }
        boolean[] blArray = new boolean[9];
        blArray[1] = true;
        return blArray;
    }

    @Override
    public Date getNotAfter() {
        return new Date();
    }

    @Override
    public Date getNotBefore() {
        return new Date();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String getSigAlgName() {
        return "SHA1withRSA";
    }

    @Override
    public String getSigAlgOID() {
        return "1.2.840.113549.1.1.5";
    }

    @Override
    public byte[] getSigAlgParams() {
        return null;
    }

    @Override
    public byte[] getSignature() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal getSubjectDN() {
        return this.subjectDn;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PublicKey getPublicKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "Certificado impostado: \n Emisor: " + this.issuerDn.toString() + "\n Titular: " + this.subjectDn.toString() + "\n Numero de serie: " + this.serialNumber.toString();
    }

    @Override
    public void verify(PublicKey puk) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void verify(PublicKey puk, String s) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new UnsupportedOperationException();
    }
}

