/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card.dnie;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnection;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.CardNotPresentException;
import es.gob.jmulticard.apdu.connection.LostChannelException;
import es.gob.jmulticard.apdu.connection.NoReadersFoundException;
import es.gob.jmulticard.apdu.connection.cwa14890.Cwa14890OneConnection;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.apdu.dnie.GetChipInfoApduCommand;
import es.gob.jmulticard.apdu.iso7816eight.PsoSignHashApduCommand;
import es.gob.jmulticard.apdu.iso7816four.ExternalAuthenticateApduCommand;
import es.gob.jmulticard.apdu.iso7816four.InternalAuthenticateApduCommand;
import es.gob.jmulticard.apdu.iso7816four.MseSetAuthenticationKeyApduCommand;
import es.gob.jmulticard.apdu.iso7816four.MseSetSignatureKeyApduCommand;
import es.gob.jmulticard.asn1.der.pkcs1.DigestInfo;
import es.gob.jmulticard.asn1.der.pkcs15.Cdf;
import es.gob.jmulticard.asn1.der.pkcs15.PrKdf;
import es.gob.jmulticard.card.Atr;
import es.gob.jmulticard.card.BadPinException;
import es.gob.jmulticard.card.CryptoCard;
import es.gob.jmulticard.card.CryptoCardException;
import es.gob.jmulticard.card.InvalidCardException;
import es.gob.jmulticard.card.Location;
import es.gob.jmulticard.card.PrivateKeyReference;
import es.gob.jmulticard.card.cwa14890.Cwa14890Card;
import es.gob.jmulticard.card.dnie.BurnedDnieCardException;
import es.gob.jmulticard.card.dnie.DnieCardException;
import es.gob.jmulticard.card.dnie.DnieCwa14890Constants;
import es.gob.jmulticard.card.dnie.DniePrivateKeyReference;
import es.gob.jmulticard.card.dnie.FakeX509Certificate;
import es.gob.jmulticard.card.iso7816eight.Iso7816EightCard;
import es.gob.jmulticard.card.iso7816four.FileNotFoundException;
import es.gob.jmulticard.card.iso7816four.Iso7816FourCardException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.security.auth.callback.PasswordCallback;

public final class Dnie
extends Iso7816EightCard
implements CryptoCard,
Cwa14890Card {
    private static final boolean SHOW_SIGN_CONFIRM_DIALOG = true;
    private static final byte[] CERT_ICC_FILE_ID = new byte[]{96, 31};
    private static final String MASTER_FILE_NAME = "Master.File";
    private static final String AUTH_CERT_ALIAS = "CertAutenticacion";
    private static final String SIGN_CERT_ALIAS = "CertFirmaDigital";
    private static final String INTERMEDIATE_CA_CERT_ALIAS = "CertCAIntermediaDGP";
    private static final String AUTH_KEY_LABEL = "KprivAutenticacion";
    private static final String SIGN_KEY_LABEL = "KprivFirmaDigital";
    private static final Location CDF_LOCATION = new Location("50156004");
    private static final Location PRKDF_LOCATION = new Location("50156001");
    private static final String FAST_MODE_PROPERTY = "es.gob.jmulticard.fastmode";
    private X509Certificate authCert;
    private X509Certificate signCert;
    private X509Certificate intermediateCaCert;
    private Location authCertPath;
    private Location signCertPath;
    private DniePrivateKeyReference authKeyRef;
    private DniePrivateKeyReference signKeyRef;
    private boolean needsRealCertificates = false;
    private CryptoHelper cryptoHelper = null;
    private static final byte[] ATR_MASK;
    private static final Atr ATR;
    private static final Atr BURNED_DNI_ATR;
    private final PasswordCallback passwordCallback;
    private final boolean fastMode;

    static {
        byte[] byArray = new byte[20];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        ATR_MASK = byArray;
        byte[] byArray2 = new byte[20];
        byArray2[0] = 59;
        byArray2[1] = 127;
        byArray2[6] = 106;
        byArray2[7] = 68;
        byArray2[8] = 78;
        byArray2[9] = 73;
        byArray2[10] = 101;
        byArray2[18] = -112;
        ATR = new Atr(byArray2, ATR_MASK);
        byte[] byArray3 = new byte[20];
        byArray3[0] = 59;
        byArray3[1] = 127;
        byArray3[6] = 106;
        byArray3[7] = 68;
        byArray3[8] = 78;
        byArray3[9] = 73;
        byArray3[10] = 101;
        byArray3[18] = 101;
        byArray3[19] = -127;
        BURNED_DNI_ATR = new Atr(byArray3, ATR_MASK);
    }

    private void connect(ApduConnection conn) throws BurnedDnieCardException, InvalidCardException, ApduConnectionException {
        if (conn == null) {
            throw new IllegalArgumentException("La conexion no puede ser nula");
        }
        InvalidCardException invalidCardException = null;
        CardNotPresentException cardNotPresentException = null;
        long[] terminals = conn.getTerminals(false);
        if (terminals.length < 1) {
            throw new NoReadersFoundException();
        }
        long[] lArray = terminals;
        int n = terminals.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                byte[] responseAtr;
                long terminal = lArray[n2];
                conn.setTerminal((int)terminal);
                try {
                    responseAtr = conn.reset();
                }
                catch (CardNotPresentException e) {
                    cardNotPresentException = e;
                    break block10;
                }
                Atr actualAtr = new Atr(responseAtr, ATR_MASK);
                if (BURNED_DNI_ATR.equals(actualAtr)) {
                    throw new BurnedDnieCardException();
                }
                if (!ATR.equals(actualAtr)) {
                    invalidCardException = new InvalidCardException(this.getCardName(), ATR, responseAtr);
                } else {
                    return;
                }
            }
            ++n2;
        }
        if (invalidCardException != null) {
            throw invalidCardException;
        }
        if (cardNotPresentException != null) {
            throw cardNotPresentException;
        }
        throw new ApduConnectionException("No se ha podido conectar con ningun lector de tarjetas");
    }

    public Dnie(ApduConnection conn, PasswordCallback pwc, CryptoHelper cryptoHelper) throws ApduConnectionException, InvalidCardException, BurnedDnieCardException {
        super((byte)0, conn);
        this.connect(conn);
        this.passwordCallback = pwc;
        if (cryptoHelper == null) {
            throw new IllegalArgumentException("El CryptoHelper no puede ser nula");
        }
        this.cryptoHelper = cryptoHelper;
        this.fastMode = Boolean.getBoolean(FAST_MODE_PROPERTY);
        this.preloadCertificates();
        this.loadKeyReferences();
    }

    private void loadKeyReferences() {
        PrKdf prKdf = new PrKdf();
        try {
            prKdf.setDerValue(this.selectFileByLocationAndRead(PRKDF_LOCATION));
        }
        catch (Exception e) {
            throw new IllegalStateException("No se ha podido cargar el PrKDF de la tarjeta: " + e.toString());
        }
        int i = 0;
        while (i < prKdf.getKeyCount()) {
            if (AUTH_KEY_LABEL.equals(prKdf.getKeyName(i))) {
                this.authKeyRef = new DniePrivateKeyReference(this, prKdf.getKeyIdentifier(i), new Location(prKdf.getKeyPath(i)), AUTH_KEY_LABEL);
            } else if (SIGN_KEY_LABEL.equals(prKdf.getKeyName(i))) {
                this.signKeyRef = new DniePrivateKeyReference(this, prKdf.getKeyIdentifier(i), new Location(prKdf.getKeyPath(i)), SIGN_KEY_LABEL);
            }
            ++i;
        }
    }

    @Override
    public byte[] getSerialNumber() throws ApduConnectionException {
        ResponseApdu response = this.getConnection().transmit(new GetChipInfoApduCommand());
        if (response.isOk()) {
            return response.getData();
        }
        throw new ApduConnectionException("Respuesta invalida en la obtencion del numero de serie con el codigo: " + response.getStatusWord());
    }

    @Override
    public String getCardName() {
        return "DNIe";
    }

    @Override
    public String[] getAliases() {
        return new String[]{AUTH_CERT_ALIAS, SIGN_CERT_ALIAS};
    }

    private void preloadCertificates() {
        Cdf cdf = new Cdf();
        try {
            this.selectMasterFile();
            cdf.setDerValue(this.selectFileByLocationAndRead(CDF_LOCATION));
        }
        catch (Exception e) {
            throw new IllegalStateException("No se ha podido cargar el CDF de la tarjeta: " + e.toString());
        }
        int i = 0;
        while (i < cdf.getCertificateCount()) {
            FakeX509Certificate tmpCert = new FakeX509Certificate(cdf.getCertificateSubjectPrincipal(i), cdf.getCertificateIssuerPrincipal(i), cdf.getCertificateSerialNumber(i), AUTH_CERT_ALIAS.equals(cdf.getCertificateAlias(i)));
            if (AUTH_CERT_ALIAS.equals(cdf.getCertificateAlias(i))) {
                this.authCert = tmpCert;
                this.authCertPath = new Location(cdf.getCertificatePath(i));
            } else if (SIGN_CERT_ALIAS.equals(cdf.getCertificateAlias(i))) {
                this.signCert = tmpCert;
                this.signCertPath = new Location(cdf.getCertificatePath(i));
            } else {
                try {
                    byte[] intermediateCaCertEncoded = Dnie.deflate(this.selectFileByLocationAndRead(new Location(cdf.getCertificatePath(i))));
                    this.intermediateCaCert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(intermediateCaCertEncoded));
                }
                catch (Exception e) {
                    Logger.getLogger("es.gob.jmulticard").warning("No se ha podido cargar el certificado de la autoridad intermedia de la DGP: " + e.toString());
                    this.intermediateCaCert = null;
                }
            }
            ++i;
        }
    }

    private void loadCertificates() throws CryptoCardException, BadPinException {
        if (this.isSecurityChannelOpen()) {
            return;
        }
        this.verifyAndLoadCertificates();
    }

    @Override
    public X509Certificate getCertificate(String alias) throws CryptoCardException, BadPinException {
        if (this.needsRealCertificates || this.authCert instanceof FakeX509Certificate && !this.fastMode) {
            this.loadCertificates();
        }
        if (AUTH_CERT_ALIAS.equals(alias)) {
            return this.authCert;
        }
        if (SIGN_CERT_ALIAS.equals(alias)) {
            return this.signCert;
        }
        if (INTERMEDIATE_CA_CERT_ALIAS.equals(alias)) {
            return this.intermediateCaCert;
        }
        return null;
    }

    @Override
    public void verifyCaIntermediateIcc() throws CertificateException, IOException {
    }

    @Override
    public void verifyIcc() throws CertificateException, IOException {
    }

    @Override
    public byte[] getIccCertEncoded() throws IOException {
        byte[] iccCertEncoded;
        try {
            iccCertEncoded = this.selectFileByIdAndRead(CERT_ICC_FILE_ID);
        }
        catch (ApduConnectionException e) {
            throw new IOException("Error en el envio de APDU para la seleccion del certificado de componente de la tarjeta: " + e, e);
        }
        catch (Iso7816FourCardException e) {
            throw new IOException("Error en la seleccion del certificado de componente de la tarjeta: " + e, e);
        }
        return iccCertEncoded;
    }

    @Override
    public void verifyIfdCertificateChain() throws ApduConnectionException {
        try {
            this.setPublicKeyToVerification(DnieCwa14890Constants.REF_C_CV_CA_PUBLIC_KEY);
        }
        catch (SecureChannelException e) {
            throw new SecureChannelException("Error al seleccionar para verificacion la clave publica de la CA raiz de los certificados verificables por la tarjeta", e);
        }
        try {
            this.verifyCertificate(DnieCwa14890Constants.C_CV_CA);
        }
        catch (SecureChannelException e) {
            throw new SecureChannelException("Error en la verificacion del certificado de la CA intermedia de Terminal", e);
        }
        try {
            this.setPublicKeyToVerification(DnieCwa14890Constants.CHR_C_CV_CA);
        }
        catch (SecureChannelException e) {
            throw new SecureChannelException("Error al establecer la clave publica del certificado de CA intermedia de Terminal para su verificacion en tarjeta", e);
        }
        try {
            this.verifyCertificate(DnieCwa14890Constants.C_CV_IFD);
        }
        catch (SecureChannelException e) {
            throw new SecureChannelException("Error en la verificacion del certificado de Terminal", e);
        }
    }

    @Override
    public byte[] getRefIccPrivateKey() {
        return DnieCwa14890Constants.REF_ICC_PRIVATE_KEY;
    }

    @Override
    public byte[] getChrCCvIfd() {
        return DnieCwa14890Constants.CHR_C_CV_IFD;
    }

    @Override
    public RSAPrivateKey getIfdPrivateKey() {
        return DnieCwa14890Constants.IFD_PRIVATE_KEY;
    }

    @Override
    public void setKeysToAuthentication(byte[] refPublicKey, byte[] refPrivateKey) throws ApduConnectionException {
        MseSetAuthenticationKeyApduCommand apdu = new MseSetAuthenticationKeyApduCommand(0, refPublicKey, refPrivateKey);
        ResponseApdu res = this.getConnection().transmit(apdu);
        if (!res.isOk()) {
            throw new SecureChannelException("Error durante el establecimiento de las claves publica y privada para atenticacion (error: " + HexUtils.hexify(res.getBytes(), true) + ")");
        }
    }

    @Override
    public byte[] getInternalAuthenticateMessage(byte[] randomIfd, byte[] chrCCvIfd) throws ApduConnectionException {
        InternalAuthenticateApduCommand apdu = new InternalAuthenticateApduCommand(0, randomIfd, chrCCvIfd);
        ResponseApdu res = this.getConnection().transmit(apdu);
        if (res.isOk()) {
            return res.getData();
        }
        throw new ApduConnectionException("Respuesta invalida en la obtencion del mensaje de autenticacion interna con el codigo: " + res.getStatusWord());
    }

    @Override
    public boolean externalAuthentication(byte[] extAuthenticationData) throws ApduConnectionException {
        ExternalAuthenticateApduCommand apdu = new ExternalAuthenticateApduCommand(0, extAuthenticationData);
        return this.getConnection().transmit(apdu).isOk();
    }

    @Override
    public PrivateKeyReference getPrivateKey(String alias) {
        this.needsRealCertificates = true;
        if (AUTH_CERT_ALIAS.equals(alias)) {
            return this.authKeyRef;
        }
        if (SIGN_CERT_ALIAS.equals(alias)) {
            return this.signKeyRef;
        }
        return null;
    }

    @Override
    public byte[] sign(byte[] data, String algorithm, PrivateKeyReference privateKeyReference) throws CryptoCardException, BadPinException {
        boolean permissionDenied;
        if (!(privateKeyReference instanceof DniePrivateKeyReference)) {
            throw new IllegalArgumentException("La referencia a la clave privada tiene que ser de tipo DniePrivateKeyReference");
        }
        try {
            Class<?> dialogBuilderClass = Class.forName("es.gob.jmulticard.ui.passwordcallback.DialogBuilder");
            Class<?> componentClass = Class.forName("java.awt.Component");
            Method showSignatureConfirmDialogMethod = dialogBuilderClass.getMethod("showSignatureConfirmDialog", componentClass, Boolean.TYPE);
            Integer result = (Integer)showSignatureConfirmDialogMethod.invoke(null, null, !AUTH_KEY_LABEL.equals(((DniePrivateKeyReference)privateKeyReference).toString()));
            permissionDenied = result == 1;
        }
        catch (Exception e) {
            Logger.getLogger("es.gob.afirma").severe("No se ha podido mostrar el dialogo grafico para la autorizacion de la firma, se realizara sin aprobacion expresa: " + e);
            permissionDenied = false;
        }
        if (permissionDenied) {
            RuntimeException re;
            try {
                Class<?> cancelledOperationExceptionClass = Class.forName("es.gob.jmulticard.ui.passwordcallback.CancelledOperationException");
                Constructor<?> cancelledOperationExceptionConstructor = cancelledOperationExceptionClass.getConstructor(String.class);
                re = (RuntimeException)cancelledOperationExceptionConstructor.newInstance("Operacion de firma no autorizada por el usuario");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("No se ha instanciar CancelledOperationException", e);
            }
            throw re;
        }
        return this.signOperation(data, algorithm, privateKeyReference);
    }

    private byte[] signOperation(byte[] data, String algorithm, PrivateKeyReference privateKeyReference) throws CryptoCardException, BadPinException {
        ResponseApdu res;
        if (!this.isSecurityChannelOpen()) {
            this.verifyAndLoadCertificates();
        }
        try {
            byte[] digestInfo;
            CommandApdu apdu = new MseSetSignatureKeyApduCommand(0, ((DniePrivateKeyReference)privateKeyReference).getKeyPath().getLastFilePath());
            res = this.getConnection().transmit(apdu);
            if (!res.isOk()) {
                throw new DnieCardException("Error en el establecimiento de las variables de entorno para firma", res.getStatusWord());
            }
            try {
                digestInfo = DigestInfo.encode(algorithm, data, this.cryptoHelper);
            }
            catch (IOException e) {
                throw new DnieCardException("Error en el calculo del hash para firmar", e);
            }
            apdu = new PsoSignHashApduCommand(0, digestInfo);
            res = this.getConnection().transmit(apdu);
            if (!res.isOk()) {
                throw new DnieCardException("Error durante la operacion de firma", res.getStatusWord());
            }
        }
        catch (LostChannelException e) {
            try {
                this.getConnection().close();
                if (this.getConnection() instanceof Cwa14890OneConnection) {
                    this.setConnection(((Cwa14890OneConnection)this.getConnection()).getSubConnection());
                }
            }
            catch (Exception ex) {
                throw new DnieCardException("No se pudo recuperar el canal seguro para firmar: " + ex, ex);
            }
            return this.signOperation(data, algorithm, privateKeyReference);
        }
        catch (ApduConnectionException e) {
            throw new DnieCardException("Error en la transmision de comandos a la tarjeta", e);
        }
        return res.getData();
    }

    private void verifyAndLoadCertificates() throws CryptoCardException, BadPinException {
        if (!this.isSecurityChannelOpen()) {
            if (!(this.getConnection() instanceof Cwa14890OneConnection)) {
                Cwa14890OneConnection secureConnection = new Cwa14890OneConnection(this, this.getConnection(), this.cryptoHelper);
                try {
                    this.setConnection(secureConnection);
                }
                catch (ApduConnectionException e) {
                    throw new CryptoCardException("Error en el establecimiento del canal seguro", e);
                }
            }
            try {
                this.verifyPin(this.passwordCallback);
                if (this.passwordCallback != null) {
                    this.passwordCallback.clearPassword();
                }
            }
            catch (ApduConnectionException e) {
                throw new CryptoCardException("Error en la apertura del canal seguro: " + e, e);
            }
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            byte[] authCertEncoded = Dnie.deflate(this.selectFileByLocationAndRead(this.authCertPath));
            this.authCert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(authCertEncoded));
            byte[] signCertEncoded = Dnie.deflate(this.selectFileByLocationAndRead(this.signCertPath));
            this.signCert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signCertEncoded));
        }
        catch (CertificateException e) {
            throw new CryptoCardException("Error al cargar los certificados reales del DNIe, no es posible obtener una factoria de certificados X.509", e);
        }
        catch (IOException e) {
            throw new CryptoCardException("Error al cargar los certificados reales del DNIe, error en la descompresion de los datos", e);
        }
        catch (Iso7816FourCardException e) {
            throw new CryptoCardException("Error al cargar los certificados reales del DNIe, no es posible obtener una factoria de certificados X.509", e);
        }
    }

    @Override
    protected void selectMasterFile() throws ApduConnectionException, FileNotFoundException {
        this.selectFileByName(MASTER_FILE_NAME);
    }

    private static byte[] deflate(byte[] compressedCertificate) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedCertificate, 8, compressedCertificate.length - 8);
        byte[] buf = new byte[1024];
        try {
            while (!decompressor.finished()) {
                int count = decompressor.inflate(buf);
                if (count == 0) {
                    throw new DataFormatException();
                }
                buffer.write(buf, 0, count);
            }
            return buffer.toByteArray();
        }
        catch (DataFormatException ex) {
            throw new IOException("Error al descomprimir el certificado: " + ex, ex);
        }
    }

    private boolean isSecurityChannelOpen() {
        return this.getConnection() instanceof Cwa14890OneConnection && this.getConnection().isOpen() && !(this.authCert instanceof FakeX509Certificate);
    }
}

