/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.card;

import es.gob.jmulticard.HexUtils;
import java.util.Hashtable;
import java.util.Vector;

public final class Location {
    private static final int MASTER_FILE_ID = 16128;
    private Vector<Integer> path = new Vector();
    private static final Hashtable<String, Integer> HEXBYTES = new Hashtable();

    static {
        String[] hex = new String[]{"a", "b", "c", "d", "e", "f"};
        int i = 0;
        while (i < 9) {
            HEXBYTES.put(String.valueOf(i), Integer.valueOf(String.valueOf(i)));
            ++i;
        }
        i = 10;
        while (i < 16) {
            HEXBYTES.put(hex[i - 10], Integer.valueOf(String.valueOf(i)));
            HEXBYTES.put(hex[i - 10].toUpperCase(), Integer.valueOf(String.valueOf(i)));
            ++i;
        }
    }

    public Location(String absolutePath) {
        this.init(absolutePath);
    }

    public Location(String absolutePath, char pathSeparator) {
        StringBuffer auxPathVar = new StringBuffer();
        int i = 0;
        while (i < absolutePath.length()) {
            if (absolutePath.charAt(i) != pathSeparator) {
                auxPathVar.append(absolutePath.charAt(i));
            }
            ++i;
        }
        this.init(auxPathVar.toString());
    }

    private Location(Vector<Integer> path) {
        if (path != null) {
            int numElements = path.size();
            this.path = new Vector(numElements);
            int i = 0;
            while (i < numElements) {
                this.path.insertElementAt(path.elementAt(i), i);
                ++i;
            }
        }
    }

    public Location getChild() {
        Location aux = new Location(this.path);
        if (aux.path != null && aux.path.size() > 1) {
            aux.path.removeElementAt(0);
            return aux;
        }
        return null;
    }

    public byte[] getFile() {
        int address = this.path.elementAt(0);
        return new byte[]{(byte)(address >> 8 & 0xFF), (byte)(address & 0xFF)};
    }

    public byte[] getLastFilePath() {
        if (this.path.size() < 1) {
            return null;
        }
        int address = this.path.elementAt(this.path.size() - 1);
        return new byte[]{(byte)(address >> 8 & 0xFF), (byte)(address & 0xFF)};
    }

    private static boolean isValidPath(String absolutePath) {
        if (absolutePath.length() == 0) {
            return false;
        }
        String aux = absolutePath.toLowerCase();
        int i = 0;
        while (i < absolutePath.length()) {
            if (!(aux.charAt(i) >= '0' && aux.charAt(i) <= '9' || aux.charAt(i) >= 'a' && aux.charAt(i) <= 'f')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void init(String absolutePath) {
        if (absolutePath == null || "".equals(absolutePath.trim()) || absolutePath.trim().length() % 4 != 0) {
            throw new IllegalArgumentException("Un location valido debe estar compuesto por grupos de pares octetos.");
        }
        if (!Location.isValidPath(absolutePath)) {
            throw new IllegalArgumentException("La ruta contiene caracteres no validos.");
        }
        int i = 0;
        while (i < absolutePath.length()) {
            int ll;
            int mm = HEXBYTES.get(absolutePath.substring(i, i + 1));
            int ml = HEXBYTES.get(absolutePath.substring(i + 1, i + 2));
            int lm = HEXBYTES.get(absolutePath.substring(i + 2, i + 3));
            int id = ll = HEXBYTES.get(absolutePath.substring(i + 3, i + 4)).intValue();
            id += lm << 4;
            id += ml << 8;
            if ((id += mm << 4 << 8) != 16128) {
                this.path.addElement(Integer.valueOf(String.valueOf(id)));
            }
            i += 4;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.path != null && !this.path.isEmpty()) {
            buffer.append("3F00");
            int i = 0;
            while (i < this.path.size()) {
                Integer integer = this.path.elementAt(i);
                buffer.append('/').append(HexUtils.hexify(new byte[]{(byte)(integer.shortValue() >> 8), integer.byteValue()}, false));
                ++i;
            }
        }
        return buffer.toString();
    }
}

