/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs15;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.der.ContextSpecific;
import es.gob.jmulticard.asn1.der.pkcs15.X509CertificateAttributes;
import java.math.BigInteger;

public final class X509CertificateAttributesContextSpecific
extends ContextSpecific {
    private static final byte TAG = -95;

    public X509CertificateAttributesContextSpecific() {
        super(X509CertificateAttributes.class);
    }

    @Override
    public void checkTag(byte tag) throws Asn1Exception {
        if (-95 != tag) {
            throw new Asn1Exception("Se esperaba una etiqueta especifica de contexto " + HexUtils.hexify(new byte[]{-95}, false) + " pero se ha encontrado " + HexUtils.hexify(new byte[]{tag}, false));
        }
    }

    public String toString() {
        return this.getObject().toString();
    }

    String getIssuer() {
        return ((X509CertificateAttributes)this.getObject()).getIssuer();
    }

    String getSubject() {
        return ((X509CertificateAttributes)this.getObject()).getSubject();
    }

    String getPath() {
        return ((X509CertificateAttributes)this.getObject()).getPath();
    }

    BigInteger getSerialNumber() {
        return ((X509CertificateAttributes)this.getObject()).getSerialNumber();
    }
}

