/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs15;

import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.asn1.der.Record;
import es.gob.jmulticard.asn1.der.pkcs15.CertificateObject;
import java.math.BigInteger;

public final class Cdf
extends Record {
    private static final int BUFFER_SIZE = 150;

    public Cdf() {
        super(new Class[]{CertificateObject.class, CertificateObject.class, CertificateObject.class});
    }

    public int getCertificateCount() {
        return this.getElementCount();
    }

    public String getCertificateIssuerPrincipal(int index) {
        return ((CertificateObject)this.getElementAt(index)).getIssuer();
    }

    public String getCertificateSubjectPrincipal(int index) {
        return ((CertificateObject)this.getElementAt(index)).getSubject();
    }

    public BigInteger getCertificateSerialNumber(int index) {
        return ((CertificateObject)this.getElementAt(index)).getSerialNumber();
    }

    public byte[] getCertificateIdentifier(int index) {
        return ((CertificateObject)this.getElementAt(index)).getIdentifier();
    }

    public String getCertificatePath(int index) {
        return ((CertificateObject)this.getElementAt(index)).getPath();
    }

    public String getCertificateAlias(int index) {
        return ((CertificateObject)this.getElementAt(index)).getAlias();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(150);
        sb.append("Fichero de Descripcion de Certificados:\n");
        int index = 0;
        while (index < this.getCertificateCount()) {
            sb.append(" Certificado ");
            sb.append(Integer.toString(index));
            sb.append("\n  Alias: ");
            sb.append(this.getCertificateAlias(index));
            sb.append("\n  Titular: ");
            sb.append(this.getCertificateSubjectPrincipal(index));
            sb.append("\n  Emisor: ");
            sb.append(this.getCertificateIssuerPrincipal(index));
            sb.append("\n  Numero de serie: ");
            sb.append(this.getCertificateSerialNumber(index).toString());
            sb.append("\n  Identificador: ");
            sb.append(HexUtils.hexify(this.getCertificateIdentifier(index), true));
            sb.append("\n  Ruta PKCS#15: ");
            sb.append(this.getCertificatePath(index));
            sb.append('\n');
            ++index;
        }
        return sb.toString();
    }
}

