/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der.pkcs1;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.asn1.der.OctectString;
import es.gob.jmulticard.asn1.der.Sequence;
import es.gob.jmulticard.asn1.der.pkcs1.AlgorithmIdentifer;
import java.io.IOException;

public final class DigestInfo
extends Sequence {
    private static final String SHA1_NORMALIZED_ALGO_NAME = "SHA-1";
    private static final String SHA256_NORMALIZED_ALGO_NAME = "SHA-256";
    private static final String SHA384_NORMALIZED_ALGO_NAME = "SHA-384";
    private static final String SHA512_NORMALIZED_ALGO_NAME = "SHA-512";
    private static final String SHA1WITHRSA_NORMALIZED_ALGO_NAME = "SHA1withRSA";
    private static final String SHA256WITHRSA_NORMALIZED_ALGO_NAME = "SHA256withRSA";
    private static final String SHA384WITHRSA_NORMALIZED_ALGO_NAME = "SHA384withRSA";
    private static final String SHA512WITHRSA_NORMALIZED_ALGO_NAME = "SHA512withRSA";
    private static final byte[] SHA1_DIGESTINFO_HEADER;
    private static final byte[] SHA256_DIGESTINFO_HEADER;
    private static final byte[] SHA384_DIGESTINFO_HEADER;
    private static final byte[] SHA512_DIGESTINFO_HEADER;

    static {
        byte[] byArray = new byte[15];
        byArray[0] = 48;
        byArray[1] = 33;
        byArray[2] = 48;
        byArray[3] = 9;
        byArray[4] = 6;
        byArray[5] = 5;
        byArray[6] = 43;
        byArray[7] = 14;
        byArray[8] = 3;
        byArray[9] = 2;
        byArray[10] = 26;
        byArray[11] = 5;
        byArray[13] = 4;
        byArray[14] = 20;
        SHA1_DIGESTINFO_HEADER = byArray;
        byte[] byArray2 = new byte[19];
        byArray2[0] = 48;
        byArray2[1] = 49;
        byArray2[2] = 48;
        byArray2[3] = 13;
        byArray2[4] = 6;
        byArray2[5] = 9;
        byArray2[6] = 96;
        byArray2[7] = -122;
        byArray2[8] = 72;
        byArray2[9] = 1;
        byArray2[10] = 101;
        byArray2[11] = 3;
        byArray2[12] = 4;
        byArray2[13] = 2;
        byArray2[14] = 1;
        byArray2[15] = 5;
        byArray2[17] = 4;
        byArray2[18] = 32;
        SHA256_DIGESTINFO_HEADER = byArray2;
        byte[] byArray3 = new byte[19];
        byArray3[0] = 48;
        byArray3[1] = 65;
        byArray3[2] = 48;
        byArray3[3] = 13;
        byArray3[4] = 6;
        byArray3[5] = 9;
        byArray3[6] = 96;
        byArray3[7] = -122;
        byArray3[8] = 72;
        byArray3[9] = 1;
        byArray3[10] = 101;
        byArray3[11] = 3;
        byArray3[12] = 4;
        byArray3[13] = 2;
        byArray3[14] = 2;
        byArray3[15] = 5;
        byArray3[17] = 4;
        byArray3[18] = 48;
        SHA384_DIGESTINFO_HEADER = byArray3;
        byte[] byArray4 = new byte[19];
        byArray4[0] = 48;
        byArray4[1] = 81;
        byArray4[2] = 48;
        byArray4[3] = 13;
        byArray4[4] = 6;
        byArray4[5] = 9;
        byArray4[6] = 96;
        byArray4[7] = -122;
        byArray4[8] = 72;
        byArray4[9] = 1;
        byArray4[10] = 101;
        byArray4[11] = 3;
        byArray4[12] = 4;
        byArray4[13] = 2;
        byArray4[14] = 3;
        byArray4[15] = 5;
        byArray4[17] = 4;
        byArray4[18] = 64;
        SHA512_DIGESTINFO_HEADER = byArray4;
    }

    protected static byte[] getSha1DigestinfoHeader() {
        byte[] out = new byte[SHA1_DIGESTINFO_HEADER.length];
        System.arraycopy(SHA1_DIGESTINFO_HEADER, 0, out, 0, SHA1_DIGESTINFO_HEADER.length);
        return out;
    }

    protected static byte[] getSha256DigestinfoHeader() {
        byte[] out = new byte[SHA256_DIGESTINFO_HEADER.length];
        System.arraycopy(SHA256_DIGESTINFO_HEADER, 0, out, 0, SHA256_DIGESTINFO_HEADER.length);
        return out;
    }

    protected static byte[] getSha384DigestinfoHeader() {
        byte[] out = new byte[SHA384_DIGESTINFO_HEADER.length];
        System.arraycopy(SHA384_DIGESTINFO_HEADER, 0, out, 0, SHA384_DIGESTINFO_HEADER.length);
        return out;
    }

    protected static byte[] getSha512DigestinfoHeader() {
        byte[] out = new byte[SHA512_DIGESTINFO_HEADER.length];
        System.arraycopy(SHA512_DIGESTINFO_HEADER, 0, out, 0, SHA512_DIGESTINFO_HEADER.length);
        return out;
    }

    public DigestInfo() {
        super(new Class[]{AlgorithmIdentifer.class, OctectString.class});
    }

    public static byte[] encode(String signingAlgorithm, byte[] data, CryptoHelper cryptoHelper) throws IOException {
        String normalizedSignningAlgorithm = DigestInfo.getNormalizedSigningAlgorithm(signingAlgorithm);
        String digestAlgorithm = DigestInfo.getDigestAlgorithm(normalizedSignningAlgorithm);
        byte[] header = DigestInfo.selectHeaderTemplate(digestAlgorithm);
        byte[] md = cryptoHelper.digest(digestAlgorithm, data);
        byte[] digestInfo = new byte[header.length + md.length];
        System.arraycopy(header, 0, digestInfo, 0, header.length);
        System.arraycopy(md, 0, digestInfo, header.length, md.length);
        return digestInfo;
    }

    private static String getNormalizedSigningAlgorithm(String algorithm) {
        if (SHA1WITHRSA_NORMALIZED_ALGO_NAME.equalsIgnoreCase(algorithm) || "SHAwithRSA".equalsIgnoreCase(algorithm) || "SHA-1withRSA".equalsIgnoreCase(algorithm) || "SHA1withRSAEncryption".equalsIgnoreCase(algorithm) || "SHA-1withRSAEncryption".equalsIgnoreCase(algorithm)) {
            return SHA1WITHRSA_NORMALIZED_ALGO_NAME;
        }
        if (SHA256WITHRSA_NORMALIZED_ALGO_NAME.equalsIgnoreCase(algorithm) || "SHA-256withRSA".equalsIgnoreCase(algorithm) || "SHA-256withRSAEncryption".equalsIgnoreCase(algorithm) || "SHA256withRSAEncryption".equalsIgnoreCase(algorithm)) {
            return SHA256WITHRSA_NORMALIZED_ALGO_NAME;
        }
        if (SHA384WITHRSA_NORMALIZED_ALGO_NAME.equalsIgnoreCase(algorithm) || "SHA-384withRSA".equalsIgnoreCase(algorithm) || "SHA-384withRSAEncryption".equalsIgnoreCase(algorithm) || "SHA384withRSAEncryption".equalsIgnoreCase(algorithm)) {
            return SHA384WITHRSA_NORMALIZED_ALGO_NAME;
        }
        if (SHA512WITHRSA_NORMALIZED_ALGO_NAME.equalsIgnoreCase(algorithm) || "SHA-512withRSA".equalsIgnoreCase(algorithm) || "SHA-512withRSAEncryption".equalsIgnoreCase(algorithm) || "SHA512withRSAEncryption".equalsIgnoreCase(algorithm)) {
            return SHA512WITHRSA_NORMALIZED_ALGO_NAME;
        }
        return algorithm;
    }

    private static byte[] selectHeaderTemplate(String algorithm) {
        if (SHA1_NORMALIZED_ALGO_NAME.equals(algorithm)) {
            return DigestInfo.getSha1DigestinfoHeader();
        }
        if (SHA256_NORMALIZED_ALGO_NAME.equals(algorithm)) {
            return DigestInfo.getSha256DigestinfoHeader();
        }
        if (SHA384_NORMALIZED_ALGO_NAME.equals(algorithm)) {
            return DigestInfo.getSha384DigestinfoHeader();
        }
        if (SHA512_NORMALIZED_ALGO_NAME.equals(algorithm)) {
            return DigestInfo.getSha512DigestinfoHeader();
        }
        return new byte[0];
    }

    private static String getDigestAlgorithm(String signatureAlgorithm) {
        if (SHA1WITHRSA_NORMALIZED_ALGO_NAME.equals(signatureAlgorithm)) {
            return SHA1_NORMALIZED_ALGO_NAME;
        }
        if (SHA256WITHRSA_NORMALIZED_ALGO_NAME.equals(signatureAlgorithm)) {
            return SHA256_NORMALIZED_ALGO_NAME;
        }
        if (SHA384WITHRSA_NORMALIZED_ALGO_NAME.equals(signatureAlgorithm)) {
            return SHA384_NORMALIZED_ALGO_NAME;
        }
        if (SHA512WITHRSA_NORMALIZED_ALGO_NAME.equals(signatureAlgorithm)) {
            return SHA512_NORMALIZED_ALGO_NAME;
        }
        return signatureAlgorithm;
    }
}

