/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;
import java.util.Vector;

public abstract class SequenceOf
extends DecoderObject {
    private static final byte TAG_SEQUENCE = 48;
    private final Class<? extends DecoderObject> elementsType;
    private Vector<DecoderObject> sequenceObjects = null;

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        Tlv tlv = new Tlv(this.getRawDerValue());
        this.checkTag(tlv.getTag());
        int offset = 0;
        byte[] valueBytes = tlv.getValue();
        this.sequenceObjects = new Vector();
        while (offset < valueBytes.length) {
            DecoderObject tmpDo;
            byte[] remainingBytes = new byte[valueBytes.length - offset];
            System.arraycopy(valueBytes, offset, remainingBytes, 0, remainingBytes.length);
            tlv = new Tlv(remainingBytes);
            try {
                tmpDo = this.elementsType.newInstance();
            }
            catch (Exception e) {
                throw new Asn1Exception("No se ha podido instanciar un " + this.elementsType.getName() + " en la secuencia: " + e, e);
            }
            offset += tlv.getBytes().length;
            tmpDo.checkTag(tlv.getTag());
            tmpDo.setDerValue(tlv.getBytes());
            this.sequenceObjects.add(tmpDo);
        }
    }

    protected SequenceOf(Class<? extends DecoderObject> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.elementsType = type;
    }

    @Override
    protected byte getDefaultTag() {
        return 48;
    }

    protected DecoderObject getElementAt(int index) {
        return this.sequenceObjects.elementAt(index);
    }

    protected int getElementCount() {
        return this.sequenceObjects.size();
    }
}

