/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.der;

import es.gob.jmulticard.asn1.Asn1Exception;
import es.gob.jmulticard.asn1.DecoderObject;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.TlvException;

public abstract class Sequence
extends DecoderObject {
    private static final byte TAG_SEQUENCE = 48;
    private final DecoderObject[] elements;
    private final Class<? extends DecoderObject>[] elementsTypes;

    protected Sequence(Class<? extends DecoderObject>[] types) {
        if (types == null) {
            throw new IllegalArgumentException();
        }
        this.elementsTypes = new Class[types.length];
        System.arraycopy(types, 0, this.elementsTypes, 0, types.length);
        this.elements = new DecoderObject[types.length];
    }

    @Override
    protected void decodeValue() throws Asn1Exception, TlvException {
        Tlv mainTlv = new Tlv(this.getRawDerValue());
        this.checkTag(mainTlv.getTag());
        int offset = 0;
        byte[] rawValue = mainTlv.getValue();
        int i = 0;
        while (i < this.elementsTypes.length) {
            DecoderObject tmpDo;
            byte[] remainingBytes = new byte[rawValue.length - offset];
            System.arraycopy(rawValue, offset, remainingBytes, 0, remainingBytes.length);
            Tlv tlv = new Tlv(remainingBytes);
            try {
                tmpDo = this.elementsTypes[i].newInstance();
            }
            catch (Exception e) {
                throw new Asn1Exception("No se ha podido instanciar un " + this.elementsTypes[i].getName() + " en la posicion " + Integer.toString(i) + " de la secuencia: " + e, e);
            }
            tmpDo.checkTag(tlv.getTag());
            tmpDo.setDerValue(tlv.getBytes());
            offset += tlv.getBytes().length;
            this.elements[i] = tmpDo;
            ++i;
        }
    }

    @Override
    protected byte getDefaultTag() {
        return 48;
    }

    protected DecoderObject getElementAt(int index) {
        return this.elements[index];
    }
}

