/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1.bertlv;

import es.gob.jmulticard.asn1.bertlv.BitManipulationHelper;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;

public final class BerTlvIdentifier {
    private byte[] value;

    public int getTagValue() {
        if (this.value == null) {
            return 0;
        }
        if (this.value.length == 1) {
            return this.value[0];
        }
        byte[] tagBytes = new byte[this.value.length - 1];
        System.arraycopy(this.value, 1, tagBytes, 0, this.value.length - 1);
        int i = 0;
        while (i < tagBytes.length - 1) {
            tagBytes[i] = (byte)BitManipulationHelper.setBitValue(tagBytes[i], 8, false);
            ++i;
        }
        return new BigInteger(tagBytes).intValue();
    }

    void decode(ByteArrayInputStream stream) {
        int tlvIdFirstOctet = stream.read();
        this.value = new byte[]{(byte)tlvIdFirstOctet};
        int mask = 31;
        if ((tlvIdFirstOctet & 0x1F) == 31) {
            boolean lastOctet;
            do {
                int tlvIdNextOctet = stream.read();
                lastOctet = false;
                if (!BitManipulationHelper.getBitValue(tlvIdNextOctet, 8)) {
                    lastOctet = true;
                }
                this.value = BitManipulationHelper.mergeArrays(this.value, new byte[]{(byte)tlvIdNextOctet});
            } while (!lastOctet);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BerTlvIdentifier) {
            BerTlvIdentifier bti = (BerTlvIdentifier)obj;
            if (this.value.length != bti.value.length) {
                return false;
            }
            int i = 0;
            while (i < this.value.length) {
                try {
                    if (this.value[i] != bti.value[i]) {
                        return false;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return new BigInteger(this.value).intValue();
    }

    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < this.value.length) {
            buf.append("0x").append(Integer.toHexString(this.value[i])).append(' ');
            ++i;
        }
        buf.append(']');
        return buf.toString();
    }
}

