/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.asn1;

import es.gob.jmulticard.asn1.TlvException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public final class Tlv {
    private final byte tag;
    private final int length;
    private final byte[] bytes;
    private final int valueOffset;

    public Tlv(byte t, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("El valor del TLV no puede ser nulo");
        }
        this.valueOffset = 2;
        this.tag = t;
        this.length = value.length;
        this.bytes = new byte[value.length + 2];
        this.bytes[0] = t;
        this.bytes[1] = (byte)value.length;
        System.arraycopy(value, 0, this.bytes, 2, value.length);
    }

    public Tlv(byte[] buffer) throws TlvException {
        int size;
        boolean indefinite;
        if (buffer == null || buffer.length < 3) {
            throw new IllegalArgumentException("El TLV no puede ser nulo ni medir menos de tres octetos");
        }
        int offset = 0;
        byte[] tempBytes = new byte[buffer.length];
        System.arraycopy(buffer, 0, tempBytes, 0, buffer.length);
        this.tag = tempBytes[offset++];
        if ((this.tag & 0x1F) == 31) {
            throw new TlvException("El tipo del TLV es invalido");
        }
        boolean bl = indefinite = (size = tempBytes[offset++] & 0xFF) == 128;
        if (indefinite) {
            if ((this.tag & 0x20) == 0) {
                throw new TlvException("Longitud del TLV invalida");
            }
        } else if (size >= 128) {
            int sizeLen = size - 128;
            if (sizeLen > 3) {
                throw new TlvException("TLV demasiado largo");
            }
            size = 0;
            while (sizeLen > 0) {
                size = (size << 8) + (tempBytes[offset++] & 0xFF);
                --sizeLen;
            }
        }
        this.length = size;
        this.valueOffset = offset;
        this.bytes = new byte[this.valueOffset + this.length];
        System.arraycopy(tempBytes, 0, this.bytes, 0, this.valueOffset + this.length);
    }

    public byte[] getBytes() {
        byte[] out = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, out, 0, this.bytes.length);
        return out;
    }

    public int getLength() {
        return this.length;
    }

    public byte getTag() {
        return this.tag;
    }

    public byte[] getValue() {
        byte[] out = new byte[this.length];
        System.arraycopy(this.bytes, this.valueOffset, out, 0, this.length);
        return out;
    }

    public static Tlv decode(ByteArrayInputStream recordOfTlv) throws IOException {
        byte[] value;
        boolean indefinite;
        byte tag = (byte)recordOfTlv.read();
        if ((tag & 0x1F) == 31) {
            throw new IOException("El tipo del TLV es invalido");
        }
        int size = recordOfTlv.read() & 0xFF;
        boolean bl = indefinite = size == 128;
        if (indefinite) {
            if ((tag & 0x20) == 0) {
                throw new IOException("Longitud del TLV invalida");
            }
        } else if (size >= 128) {
            int sizeLen = size - 128;
            if (sizeLen > 3) {
                throw new IOException("TLV demasiado largo");
            }
            size = 0;
            while (sizeLen > 0) {
                size = (size << 8) + (recordOfTlv.read() & 0xFF);
                --sizeLen;
            }
        }
        if ((value = new byte[size]).length != recordOfTlv.read(value)) {
            throw new IndexOutOfBoundsException("La longitud de los datos leidos no coincide con el parametro indicado");
        }
        return new Tlv(tag, value);
    }
}

