/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.iso7816four;

import es.gob.jmulticard.apdu.Apdu;
import es.gob.jmulticard.apdu.ResponseApdu;

public final class SelectFileApduResponse
extends ResponseApdu {
    private byte[] dfName = null;
    private byte[] fileId = null;
    private byte[] fileLength = null;

    public SelectFileApduResponse(Apdu apduResponse) {
        super(apduResponse.getBytes());
        this.decode();
    }

    private void decode() {
        if (this.isOk()) {
            byte length = this.getData()[1];
            if (this.getData().length - 2 == length) {
                int propInformationIndex = 2;
                if (this.getData()[propInformationIndex] == -124) {
                    byte nameLength = this.getData()[++propInformationIndex];
                    this.dfName = this.getBytesFromData(++propInformationIndex, nameLength);
                    propInformationIndex += nameLength;
                }
                if (this.getData()[propInformationIndex] == -123 && this.getData()[propInformationIndex + 1] == 10) {
                    this.fileId = this.getBytesFromData(propInformationIndex + 3, 2);
                    this.fileLength = this.getBytesFromData(propInformationIndex + 5, 2);
                }
            }
        }
    }

    private byte[] getBytesFromData(int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(this.getData(), offset, result, 0, length);
        return result;
    }

    byte[] getDfName() {
        byte[] out = new byte[this.dfName.length];
        System.arraycopy(this.dfName, 0, out, 0, this.dfName.length);
        return out;
    }

    byte[] getFileId() {
        byte[] out = new byte[this.fileId.length];
        System.arraycopy(this.fileId, 0, out, 0, this.fileId.length);
        return out;
    }

    public int getFileLength() {
        return (this.fileLength[0] & 0xFF) << 8 | this.fileLength[1] & 0xFF;
    }

    @Override
    public boolean isOk() {
        this.getBytesFromData(this.getData().length - 2, 2);
        return super.isOk() && this.getData()[0] == 111 && this.getData().length > 2;
    }
}

