/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.iso7816four;

import es.gob.jmulticard.apdu.CommandApdu;

public final class MseSetAuthenticationKeyApduCommand
extends CommandApdu {
    private static final byte INS_MANAGE_ENVIROMENT = 34;
    private static final byte SET_FOR_AUTHENTICATION = -63;
    private static final byte AT = -92;
    private static final byte TAG_FILE_ID = -125;
    private static final byte TAG_DF_NAME = -124;

    public MseSetAuthenticationKeyApduCommand(byte cla, byte[] publicKeyFileId, byte[] privateKeyRef) {
        super(cla, (byte)34, (byte)-63, (byte)-92, MseSetAuthenticationKeyApduCommand.buidData(publicKeyFileId, privateKeyRef), null);
    }

    private static byte[] buidData(byte[] publicKeyFileId, byte[] privateKeyRef) {
        byte[] publicKeyFileIdCompleted = new byte[12];
        System.arraycopy(publicKeyFileId, 0, publicKeyFileIdCompleted, publicKeyFileIdCompleted.length - publicKeyFileId.length, publicKeyFileId.length);
        int i = 0;
        while (i < publicKeyFileIdCompleted.length - publicKeyFileId.length) {
            publicKeyFileIdCompleted[i] = 0;
            ++i;
        }
        byte[] ret = new byte[publicKeyFileIdCompleted.length + privateKeyRef.length + 4];
        ret[0] = -125;
        ret[1] = (byte)publicKeyFileIdCompleted.length;
        System.arraycopy(publicKeyFileIdCompleted, 0, ret, 2, publicKeyFileIdCompleted.length);
        int idx = 1 + publicKeyFileIdCompleted.length;
        ret[++idx] = -124;
        ret[++idx] = (byte)privateKeyRef.length;
        System.arraycopy(privateKeyRef, 0, ret, ++idx, privateKeyRef.length);
        return ret;
    }
}

