/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection.cwa14890;

import es.gob.jmulticard.apdu.CommandApdu;

final class CipheredApdu
extends CommandApdu {
    private static final byte TAG_CRYPTOGRAPHIC_CHECKSUM = -114;
    private final byte[] mac;
    private final byte[] data;

    byte[] getMac() {
        byte[] out = new byte[this.mac.length];
        System.arraycopy(this.mac, 0, out, 0, this.mac.length);
        return out;
    }

    byte[] getCryptogramData() {
        byte[] out = new byte[this.data.length];
        System.arraycopy(this.data, 0, out, 0, this.data.length);
        return out;
    }

    CipheredApdu(byte cla, byte ins, byte p1, byte p2, byte[] data, byte[] mac) {
        super(cla, ins, p1, p2, CipheredApdu.buildData(data, mac), null);
        this.mac = new byte[mac.length];
        System.arraycopy(mac, 0, this.mac, 0, mac.length);
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    private static byte[] buildData(byte[] data, byte[] mac) {
        if (data == null || mac == null) {
            throw new IllegalArgumentException("Ni los datos (TLV) ni el MAC pueden ser nulos");
        }
        if (mac.length != 4) {
            throw new IllegalArgumentException("El MAC debe medir exactamente cuatro octetos");
        }
        int retLength = data.length + mac.length + 2;
        byte[] ret = new byte[retLength];
        if (data.length > 0) {
            System.arraycopy(data, 0, ret, 0, data.length);
        }
        ret[ret.length - 1] = mac[3];
        ret[ret.length - 2] = mac[2];
        ret[ret.length - 3] = mac[1];
        ret[ret.length - 4] = mac[0];
        ret[ret.length - 5] = 4;
        ret[ret.length - 6] = -114;
        return ret;
    }

    @Override
    public void setLe(int le) {
        throw new UnsupportedOperationException("No se puede establecer el Le en una APDU cifrada");
    }
}

