/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.apdu.connection.cwa14890;

import es.gob.jmulticard.CryptoHelper;
import es.gob.jmulticard.HexUtils;
import es.gob.jmulticard.apdu.CommandApdu;
import es.gob.jmulticard.apdu.ResponseApdu;
import es.gob.jmulticard.apdu.connection.ApduConnectionException;
import es.gob.jmulticard.apdu.connection.cwa14890.CipheredApdu;
import es.gob.jmulticard.apdu.connection.cwa14890.InvalidCryptographicChecksum;
import es.gob.jmulticard.apdu.connection.cwa14890.SecureChannelException;
import es.gob.jmulticard.asn1.Tlv;
import es.gob.jmulticard.asn1.bertlv.BerTlv;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class ApduEncrypter {
    private static final byte ISO7816_PADDING_PREFIX = -128;
    private static final byte TLV_VALUE_PREFIX_TO_MAC = 1;
    private static final byte TAG_DATA_TLV = -121;
    private static final byte TAG_LE_TLV = -105;
    private static final byte TAG_SW_TLV = -103;
    private static final byte TAG_MAC_TLV = -114;
    private static final byte CLA_OF_PROTECTED_APDU = 12;

    private ApduEncrypter() {
    }

    static CipheredApdu protectAPDU(CommandApdu unprotectedAPDU, byte[] keyCipher, byte[] keyMac, byte[] sendSequenceCounter, CryptoHelper cryptoHelper) throws IOException {
        byte cla = unprotectedAPDU.getCla();
        byte ins = unprotectedAPDU.getIns();
        byte p1 = unprotectedAPDU.getP1();
        byte p2 = unprotectedAPDU.getP2();
        byte[] data = unprotectedAPDU.getData();
        Integer le = unprotectedAPDU.getLe();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] tlvDataBytes = new byte[]{};
        if (data != null && data.length > 0) {
            baos.write(1);
            byte[] paddedData = ApduEncrypter.addPadding7816(data);
            baos.write(cryptoHelper.desedeEncrypt(paddedData, keyCipher));
            int i = 0;
            while (i < paddedData.length) {
                paddedData[i] = 0;
                ++i;
            }
            i = 0;
            while (i < data.length) {
                data[i] = 0;
                ++i;
            }
            tlvDataBytes = new Tlv(-121, baos.toByteArray()).getBytes();
        }
        byte[] tlvLeBytes = new byte[]{};
        if (le != null) {
            tlvLeBytes = new Tlv(-105, new byte[]{le.byteValue()}).getBytes();
        }
        byte[] completeDataBytes = new byte[tlvDataBytes.length + tlvLeBytes.length];
        System.arraycopy(tlvDataBytes, 0, completeDataBytes, 0, tlvDataBytes.length);
        System.arraycopy(tlvLeBytes, 0, completeDataBytes, tlvDataBytes.length, tlvLeBytes.length);
        cla = (byte)(cla | 0xC);
        baos.reset();
        baos.write(ApduEncrypter.addPadding7816(new byte[]{cla, ins, p1, p2}));
        baos.write(completeDataBytes);
        byte[] encryptedDataPadded = ApduEncrypter.addPadding7816(baos.toByteArray());
        byte[] mac = ApduEncrypter.generateMac(encryptedDataPadded, sendSequenceCounter, keyMac, cryptoHelper);
        return new CipheredApdu(cla, ins, p1, p2, completeDataBytes, mac);
    }

    private static byte[] addPadding7816(byte[] data) {
        byte[] paddedData = new byte[(data.length / 8 + 1) * 8];
        System.arraycopy(data, 0, paddedData, 0, data.length);
        paddedData[data.length] = -128;
        int i = data.length + 1;
        while (i < paddedData.length) {
            paddedData[i] = 0;
            ++i;
        }
        return paddedData;
    }

    private static byte[] removePadding7816(byte[] paddedData) {
        int i = paddedData.length - 1;
        while (i >= 0) {
            if (paddedData[i] == -128) {
                if (i == 0) {
                    return new byte[0];
                }
                return HexUtils.subArray(paddedData, 0, i);
            }
            if (paddedData[i] != 0) {
                return paddedData;
            }
            --i;
        }
        return paddedData;
    }

    private static byte[] generateMac(byte[] dataPadded, byte[] ssc, byte[] kMac, CryptoHelper cryptoHelper) throws IOException {
        byte[] keyDesBytes = new byte[8];
        System.arraycopy(kMac, 0, keyDesBytes, 0, 8);
        byte[] tmpData = cryptoHelper.desEncrypt(ssc, keyDesBytes);
        int i = 0;
        while (i < dataPadded.length - 8) {
            tmpData = cryptoHelper.desEncrypt(HexUtils.xor(tmpData, HexUtils.subArray(dataPadded, i, 8)), keyDesBytes);
            i += 8;
        }
        byte[] keyTdesBytes = new byte[24];
        System.arraycopy(kMac, 0, keyTdesBytes, 0, 16);
        System.arraycopy(kMac, 0, keyTdesBytes, 16, 8);
        byte[] ret = HexUtils.subArray(cryptoHelper.desedeEncrypt(HexUtils.xor(tmpData, HexUtils.subArray(dataPadded, i, 8)), keyTdesBytes), 0, 4);
        return ret;
    }

    static ResponseApdu decryptResponseApdu(ResponseApdu responseApdu, byte[] keyCipher, byte[] ssc, byte[] kMac, CryptoHelper cryptoHelper) throws IOException {
        if (!responseApdu.isOk()) {
            return new ResponseApdu(responseApdu.getStatusWord().getBytes());
        }
        ByteArrayInputStream recordOfTlvs = new ByteArrayInputStream(responseApdu.getData());
        BerTlv dataTlv = null;
        BerTlv swTlv = null;
        BerTlv macTlv = null;
        try {
            BerTlv tlv = BerTlv.getInstance(recordOfTlvs);
            if (tlv.getTag().getTagValue() == -121) {
                dataTlv = tlv;
                tlv = BerTlv.getInstance(recordOfTlvs);
            }
            if (tlv.getTag().getTagValue() == -103) {
                swTlv = tlv;
                tlv = BerTlv.getInstance(recordOfTlvs);
            }
            if (tlv.getTag().getTagValue() == -114) {
                macTlv = tlv;
            }
        }
        catch (NegativeArraySizeException e) {
            throw new ApduConnectionException("Error en el formato de la respuesta remitida por el canal seguro", e);
        }
        if (macTlv == null) {
            throw new SecureChannelException("No se ha encontrado el TLV del MAC en la APDU");
        }
        if (swTlv == null) {
            throw new SecureChannelException("No se ha encontrado el TLV del StatusWord en la APDU cifrada");
        }
        int tlvsLenght = (dataTlv != null ? 2 + dataTlv.getValue().length / 128 + dataTlv.getValue().length : 0) + (2 + swTlv.getValue().length);
        ApduEncrypter.verifyMac(HexUtils.subArray(responseApdu.getData(), 0, tlvsLenght), macTlv.getValue(), ssc, kMac, cryptoHelper);
        if (dataTlv == null) {
            return new ResponseApdu(swTlv.getValue());
        }
        byte[] decryptedData = ApduEncrypter.removePadding7816(cryptoHelper.desedeDecrypt(HexUtils.subArray(dataTlv.getValue(), 1, dataTlv.getValue().length - 1), keyCipher));
        byte[] responseApduBytes = new byte[decryptedData.length + swTlv.getValue().length];
        System.arraycopy(decryptedData, 0, responseApduBytes, 0, decryptedData.length);
        System.arraycopy(swTlv.getValue(), 0, responseApduBytes, decryptedData.length, swTlv.getValue().length);
        return new ResponseApdu(responseApduBytes);
    }

    private static void verifyMac(byte[] verificableData, byte[] macTlvBytes, byte[] ssc, byte[] kMac, CryptoHelper cryptoHelper) {
        byte[] calculatedMac;
        try {
            calculatedMac = ApduEncrypter.generateMac(ApduEncrypter.addPadding7816(verificableData), ssc, kMac, cryptoHelper);
        }
        catch (IOException e) {
            throw new SecurityException("No se pudo calcular el MAC teorico de la respuesta del DNIe para su verificacion");
        }
        if (!HexUtils.arrayEquals(macTlvBytes, calculatedMac)) {
            throw new InvalidCryptographicChecksum();
        }
    }
}

