/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard;

import java.math.BigInteger;

public final class HexUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexUtils() {
    }

    public static boolean arrayEquals(byte[] v, byte[] w) {
        return HexUtils.arrayEquals(v, 0, v.length, w, 0, w.length);
    }

    public static boolean arrayEquals(byte[] v, int vOffset, int vLen, byte[] w, int wOffset, int wLen) {
        if (vLen != wLen || v.length < vOffset + vLen || w.length < wOffset + wLen) {
            return false;
        }
        int i = 0;
        while (i < vLen) {
            if (v[i + vOffset] != w[i + wOffset]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static short getShort(byte[] data, int offset) {
        return (short)HexUtils.getUnsignedInt(data, offset);
    }

    public static int getUnsignedInt(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 8 | data[offset + 1] & 0xFF;
    }

    public static String hexify(byte[] abyte, boolean separator) {
        if (abyte == null) {
            return "null";
        }
        StringBuffer stringbuffer = new StringBuffer(256);
        int i = 0;
        byte[] byArray = abyte;
        int n = abyte.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            if (separator && i > 0) {
                stringbuffer.append('-');
            }
            stringbuffer.append(HEX_CHARS[element >> 4 & 0xF]);
            stringbuffer.append(HEX_CHARS[element & 0xF]);
            if (++i == 16) {
                if (separator) {
                    stringbuffer.append('\n');
                }
                i = 0;
            }
            ++n2;
        }
        return stringbuffer.toString();
    }

    public static byte[] subArray(byte[] src, int srcPos, int length) {
        if (length == 0) {
            return null;
        }
        if (src.length < srcPos + length) {
            return null;
        }
        byte[] temp = new byte[length];
        System.arraycopy(src, srcPos, temp, 0, length);
        return temp;
    }

    public static byte[] xor(byte[] v, byte[] w) {
        byte[] xored = null;
        byte[] trimmedXor = null;
        xored = new BigInteger(1, v).xor(new BigInteger(1, w)).toByteArray();
        if (xored.length >= (trimmedXor = new byte[v.length]).length) {
            System.arraycopy(xored, xored.length - trimmedXor.length, trimmedXor, 0, trimmedXor.length);
        } else {
            System.arraycopy(xored, 0, trimmedXor, trimmedXor.length - xored.length, xored.length);
        }
        return trimmedXor;
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            int offset = (b.length - 1 - i) * 8;
            b[3 - i] = (byte)(value >>> offset & 0xFF);
            ++i;
        }
        return b;
    }
}

