/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.ui.AOUIManager;
import es.gob.afirma.core.ui.NameCertificateBean;
import es.gob.afirma.ui.core.jse.CertificateSelectionDialog;
import es.gob.afirma.ui.core.jse.FileExtensionFilter;
import es.gob.afirma.ui.core.jse.JSEUIMessages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JSEUIManager
implements AOUIManager {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final int ASCII_LOWER_INDEX = 32;
    private static final int ASCII_HIGHER_INDEX = 126;

    @Override
    public final char[] getPassword(String text, Object c) {
        return this.getPassword(text, null, false, c);
    }

    @Override
    public final char[] getPassword(String text, String charSet, boolean beep, Object c) {
        final JPasswordField pwd = new JPasswordField(10);
        if (charSet != null) {
            pwd.setDocument(new JTextFieldFilter(charSet, beep));
        }
        JLabel lbText = new JLabel(text != null ? text : JSEUIMessages.getString("JSEUIManager.24"));
        lbText.setMinimumSize(new Dimension(lbText.getFontMetrics(lbText.getFont()).stringWidth(text), lbText.getSize().height));
        lbText.setLabelFor(pwd);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(lbText);
        panel.add(pwd);
        JOptionPane pane = new JOptionPane(panel, 3, 2){
            private static final long serialVersionUID = -3012522768561175760L;

            @Override
            public void selectInitialValue() {
                pwd.requestFocusInWindow();
            }
        };
        Component parent = null;
        if (c instanceof Component) {
            parent = (Component)c;
        }
        pane.createDialog(parent, JSEUIMessages.getString("JSEUIManager.24")).setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return new char[0];
        }
        if ((Integer)selectedValue == 0) {
            return pwd.getPassword();
        }
        throw new AOCancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
    }

    @Override
    public final Object showInputDialog(Object parentComponent, Object message, String title, int messageType, Object icon, Object[] selectionValues, Object initialSelectionValue) {
        Component parent = null;
        if (parentComponent instanceof Component) {
            parent = (Component)parentComponent;
        }
        Icon dialogIcon = null;
        if (icon instanceof Icon) {
            dialogIcon = (Icon)icon;
        }
        if (selectionValues == null) {
            return JOptionPane.showInputDialog(parent, message, title, messageType);
        }
        return JOptionPane.showInputDialog(parent, message, title, messageType, dialogIcon, selectionValues, initialSelectionValue);
    }

    @Override
    public final Object showCertificateSelectionDialog(Object parentComponent, NameCertificateBean[] selectionValues) {
        Component parent = null;
        if (parentComponent instanceof Component) {
            parent = (Component)parentComponent;
        }
        return new CertificateSelectionDialog(selectionValues, parent).showDialog();
    }

    @Override
    public final int showConfirmDialog(Object parentComponent, Object message, String title, int optionType, int messageType) {
        Component parent = null;
        if (parentComponent instanceof Component) {
            parent = (Component)parentComponent;
        }
        return JOptionPane.showConfirmDialog(parent, message, title, optionType);
    }

    @Override
    public final int getPlainMessageCode() {
        return -1;
    }

    @Override
    public final int getYesNoOptionCode() {
        return 0;
    }

    @Override
    public final int getWarningMessageCode() {
        return 2;
    }

    @Override
    public final int getYesOptionCode() {
        return 0;
    }

    @Override
    public final int getNoOptionCode() {
        return 1;
    }

    @Override
    public final int getOkCancelOptionCode() {
        return 2;
    }

    @Override
    public final int getOkOptionCode() {
        return 0;
    }

    @Override
    public final int getInformationMessageCode() {
        return 1;
    }

    @Override
    public final int getQuestionMessageCode() {
        return 3;
    }

    @Override
    public File[] getLoadFiles(String dialogTitle, String currentDir, String filename, String[] extensions, String description, boolean selectDirectory, boolean multiSelect, Object parent) {
        int ret;
        Component parentComponent = null;
        if (parent instanceof Component) {
            parentComponent = (Component)parent;
        }
        JFileChooser jfc = new JFileChooser();
        if (selectDirectory) {
            jfc.setFileSelectionMode(1);
        }
        if (currentDir != null) {
            jfc.setCurrentDirectory(new File(currentDir));
        }
        if (filename != null) {
            if (currentDir != null) {
                jfc.setSelectedFile(new File(currentDir, filename));
            } else {
                jfc.setSelectedFile(new File(filename));
            }
        }
        jfc.setMultiSelectionEnabled(multiSelect);
        if (dialogTitle != null && dialogTitle.length() > 0) {
            jfc.setDialogTitle(dialogTitle);
        }
        if (extensions != null && extensions.length > 0) {
            jfc.setFileFilter(new ExtFilter(extensions, description));
        }
        if ((ret = jfc.showOpenDialog(parentComponent)) == 0) {
            File[] files = multiSelect ? jfc.getSelectedFiles() : new File[]{jfc.getSelectedFile()};
            return files;
        }
        throw new AOCancelledOperationException();
    }

    @Override
    public File saveDataToFile(byte[] data, String dialogTitle, String currentDir, String selectedFile, String[] exts, String description, Object parent) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("No se introdujeron datos que almacenar");
        }
        Component parentComponent = null;
        if (parent instanceof Component) {
            parentComponent = (Component)parent;
        }
        File resultFile = null;
        boolean tryAgain = true;
        while (tryAgain) {
            tryAgain = false;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.getAccessibleContext().setAccessibleName(JSEUIMessages.getString("JSEUIManager.81"));
            fileChooser.getAccessibleContext().setAccessibleDescription(JSEUIMessages.getString("JSEUIManager.82"));
            fileChooser.setToolTipText(JSEUIMessages.getString("JSEUIManager.81"));
            if (dialogTitle != null) {
                fileChooser.setDialogTitle(dialogTitle);
            }
            if (selectedFile != null && currentDir != null) {
                fileChooser.setSelectedFile(new File(currentDir, selectedFile));
            } else if (selectedFile != null) {
                fileChooser.setSelectedFile(new File(selectedFile));
            } else if (currentDir != null) {
                fileChooser.setCurrentDirectory(new File(currentDir));
            }
            if (exts != null && exts.length > 0) {
                fileChooser.setFileFilter(new FileExtensionFilter(exts, description));
            }
            int selectedOption = 0;
            int returnCode = fileChooser.showSaveDialog(parentComponent);
            switch (returnCode) {
                case 1: {
                    throw new AOCancelledOperationException();
                }
                case 0: {
                    File file = fileChooser.getSelectedFile();
                    if (file.exists() && (selectedOption = JOptionPane.showConfirmDialog(parentComponent, JSEUIMessages.getString("JSEUIManager.77", file.getAbsolutePath()), JSEUIMessages.getString("JSEUIManager.85"), 1)) == 2) {
                        LOGGER.info("Se ha cancelado la operacion de guardado.");
                        return null;
                    }
                    if (selectedOption == 1) {
                        tryAgain = true;
                        break;
                    }
                    try {
                        FileOutputStream fos = new FileOutputStream(file);
                        fos.write(data);
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception ex) {
                        LOGGER.warning("No se pudo guardar la informacion en el fichero indicado: " + ex);
                        JOptionPane.showMessageDialog(parentComponent, JSEUIMessages.getString("JSEUIManager.88"), JSEUIMessages.getString("JSEUIManager.89"), 0);
                        tryAgain = true;
                    }
                    return file;
                }
                default: {
                    throw new IOException("Error al seleccionar el fichero: " + returnCode);
                }
            }
        }
        return resultFile;
    }

    private static final class ExtFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private final String[] extensions;
        private final String description;

        public ExtFilter(String[] exts, String desc) {
            if (exts == null || exts.length < 1) {
                throw new IllegalArgumentException("No se puede crear un filtro vacio");
            }
            this.extensions = (String[])exts.clone();
            this.description = desc != null ? desc : JSEUIMessages.getString("JSEUIManager.0");
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = ExtFilter.getExtension(f);
            String[] stringArray = this.extensions;
            int n = this.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension2 = stringArray[n2];
                if (extension2.equalsIgnoreCase(extension)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        private static String getExtension(File f) {
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                return s.substring(i + 1).toLowerCase();
            }
            return "";
        }
    }

    public static final class JTextFieldASCIIFilter
    extends PlainDocument {
        private static final long serialVersionUID = 1979726487852842735L;
        private boolean beep = false;

        public JTextFieldASCIIFilter(boolean beepOnError) {
            this.beep = beepOnError;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            int i = 0;
            while (i < str.length()) {
                if (str.charAt(i) < ' ' || str.charAt(i) > '~') {
                    if (this.beep) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    return;
                }
                ++i;
            }
            super.insertString(offset, str, attr);
        }
    }

    private static final class JTextFieldFilter
    extends PlainDocument {
        private static final long serialVersionUID = -5746396042117084830L;
        private String acceptedChars = null;
        private boolean beep = false;

        JTextFieldFilter(String acceptedchars, boolean beepOnError) {
            this.beep = beepOnError;
            this.acceptedChars = acceptedchars;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            int i = 0;
            while (i < str.length()) {
                if (this.acceptedChars.indexOf(String.valueOf(str.charAt(i))) == -1) {
                    if (this.beep) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    return;
                }
                ++i;
            }
            super.insertString(offset, str, attr);
        }
    }
}

