/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import java.io.File;
import javax.swing.filechooser.FileFilter;

class FileExtensionFilter
extends FileFilter {
    private final String[] exts;
    private final String desc;

    FileExtensionFilter(String[] extensions, String description) {
        this.exts = (String[])extensions.clone();
        this.desc = description;
    }

    @Override
    public String getDescription() {
        if (this.desc != null) {
            return this.desc;
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < this.exts.length) {
            buffer.append(i == 0 ? "*." : ",*.").append(this.exts[i]);
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String[] stringArray = this.exts;
        int n = this.exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (f.getName().endsWith("." + ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

