/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.ui.core.jse.JSEUIManager;
import es.gob.afirma.ui.core.jse.JSEUIMessages;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;

final class CertificateUtils {
    private static final String CERTIFICATE_DEFAULT_EXTENSION = ".cer";

    private CertificateUtils() {
    }

    static void openCert(Component parent, X509Certificate certificate) {
        Class<?> desktopClass;
        try {
            desktopClass = Class.forName("java.awt.Desktop");
        }
        catch (ClassNotFoundException e) {
            desktopClass = null;
        }
        if (desktopClass != null) {
            try {
                File certFile = CertificateUtils.saveTemp(certificate.getEncoded(), CERTIFICATE_DEFAULT_EXTENSION);
                Method getDesktopMethod = desktopClass.getDeclaredMethod("getDesktop", null);
                Object desktopObject = getDesktopMethod.invoke(null, null);
                Method openMethod = desktopClass.getDeclaredMethod("open", File.class);
                openMethod.invoke(desktopObject, certFile);
                return;
            }
            catch (Exception e) {
                Logger.getLogger("es.gob.afirma").warning("No ha sido posible abrir el certificado: " + e);
            }
        }
        if (Platform.getOS() == Platform.OS.WINDOWS) {
            try {
                File certFile = CertificateUtils.saveTemp(certificate.getEncoded(), CERTIFICATE_DEFAULT_EXTENSION);
                new ProcessBuilder("cmd", "/C", "start", "\"" + JSEUIMessages.getString("CertificateUtils.0") + "\"", "\"" + certFile.getAbsolutePath() + "\"").start();
                return;
            }
            catch (Exception e) {
                Logger.getLogger("es.gob.afirma").warning("No ha sido posible abrir el certificado: " + e);
            }
        }
        try {
            AOUIFactory.getSaveDataToFile(certificate.getEncoded(), JSEUIMessages.getString("CertificateUtils.1"), null, String.valueOf(JSEUIMessages.getString("CertificateUtils.5")) + CERTIFICATE_DEFAULT_EXTENSION, new String[]{CERTIFICATE_DEFAULT_EXTENSION}, JSEUIMessages.getString("CertificateUtils.3"), parent);
        }
        catch (IOException e) {
            new JSEUIManager().showConfirmDialog(parent, JSEUIMessages.getString("CertificateUtils.2"), JSEUIMessages.getString("CertificateUtils.3"), -1, 0);
        }
        catch (CertificateEncodingException e) {
            new JSEUIManager().showConfirmDialog(parent, JSEUIMessages.getString(JSEUIMessages.getString("CertificateUtils.4")), JSEUIMessages.getString("CertificateUtils.3"), -1, 0);
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            // empty catch block
        }
    }

    private static boolean saveFile(File file, byte[] dataToSave) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(dataToSave);
        fos.close();
        return true;
    }

    private static File saveTemp(byte[] data, String suffix) throws IOException {
        File tempFile = File.createTempFile("afirma", suffix);
        tempFile.deleteOnExit();
        if (CertificateUtils.saveFile(tempFile, data)) {
            return tempFile;
        }
        return null;
    }
}

