/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import com.sun.jndi.toolkit.dir.SearchFilter;
import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.ui.NameCertificateBean;
import es.gob.afirma.ui.core.jse.CertificateUtils;
import es.gob.afirma.ui.core.jse.JSEUIMessages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

final class CertificateSelectionPanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 6288294705582545804L;
    private static final String VERDANA_FONT_NAME = "Verdana";
    private static final Font TITLE_FONT = new Font("Verdana", 1, 14);
    private static final Font TEXT_FONT = new Font("Verdana", 0, 12);
    private static final int CERT_LIST_ELEMENT_HEIGHT = 86;
    private JList certList;
    private int selectedIndex;
    private final NameCertificateBean[] certificateBeans;

    CertificateSelectionPanel(NameCertificateBean[] el) {
        this.certificateBeans = el == null ? new NameCertificateBean[]{} : (NameCertificateBean[])el.clone();
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(13, 15, 8, 15);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridy = 0;
        JLabel mainMessage = new JLabel(JSEUIMessages.getString("CertificateSelectionPanel.0"));
        mainMessage.setFont(TITLE_FONT);
        mainMessage.setForeground(Color.decode("0x0033BC"));
        this.add((Component)mainMessage, c);
        if (this.certificateBeans.length == 1) {
            c.insets = new Insets(0, 15, 4, 15);
            ++c.gridy;
            JTextPane textMessage = new JTextPane();
            textMessage.setText(JSEUIMessages.getString("CertificateSelectionPanel.1"));
            textMessage.setFont(TEXT_FONT);
            textMessage.setBorder(null);
            textMessage.setPreferredSize(new Dimension(370, 40));
            this.add((Component)textMessage, c);
        }
        c.insets = new Insets(4, 15, 8, 15);
        ++c.gridy;
        this.add((Component)new JSeparator(), c);
        c.insets = new Insets(8, 18, 13, 18);
        c.weighty = 1.0;
        ++c.gridy;
        Vector<CertificateLine> certLines = new Vector<CertificateLine>();
        NameCertificateBean[] nameCertificateBeanArray = this.certificateBeans;
        int n = this.certificateBeans.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                CertificateLine certLine;
                NameCertificateBean nameCert = nameCertificateBeanArray[n2];
                try {
                    certLine = CertificateSelectionPanel.createCertLine(nameCert.getName(), nameCert.getCertificate());
                }
                catch (Exception e) {
                    break block5;
                }
                certLine.setPreferredSize(new Dimension(0, 86));
                certLines.add(certLine);
            }
            ++n2;
        }
        this.certList = new JList();
        this.certList.setCellRenderer(new CertListCellRendered());
        this.certList.setListData(certLines);
        this.certList.setVisibleRowCount(Math.max(Math.min(4, certLines.size()), 1));
        if (certLines.size() > 0) {
            this.certList.setSelectedIndex(0);
        }
        JScrollPane sPane = new JScrollPane(this.certList, 20, 31);
        this.certList.addListSelectionListener(this);
        CertLinkMouseListener listener = new CertLinkMouseListener();
        this.certList.addMouseMotionListener(listener);
        this.certList.addMouseListener(listener);
        this.certList.setSelectedIndex(0);
        this.selectedIndex = 0;
        sPane.setBorder(null);
        sPane.setPreferredSize(new Dimension(435, 86 * this.certList.getVisibleRowCount()));
        this.add((Component)sPane, c);
    }

    void selectCertificateList() {
        this.certList.requestFocusInWindow();
    }

    String getSelectedCertificate() {
        return this.selectedIndex == -1 ? null : this.certificateBeans[this.selectedIndex].getAlias();
    }

    void addCertificateListMouseListener(MouseListener listener) {
        this.certList.addMouseListener(listener);
    }

    private static CertificateLine createCertLine(String friendlyName, X509Certificate cert) {
        CertificateLine certLine = new CertificateLine(friendlyName, cert);
        certLine.setFocusable(true);
        return certLine;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.selectedIndex = this.certList.getSelectedIndex();
    }

    private final class CertLinkMouseListener
    extends MouseAdapter {
        private boolean entered = false;

        CertLinkMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 1 && ((CertificateLine)((JList)me.getSource()).getSelectedValue()).getCertificateLinkBounds().contains(me.getX(), me.getY() % 86)) {
                try {
                    CertificateUtils.openCert(CertificateSelectionPanel.this, ((CertificateLine)((JList)me.getSource()).getSelectedValue()).getCertificate());
                }
                catch (AOCancelledOperationException aOCancelledOperationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            if (((CertificateLine)((JList)me.getSource()).getSelectedValue()).getCertificateLinkBounds().contains(me.getX(), me.getY() % 86)) {
                if (!this.entered) {
                    ((JList)me.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                    this.entered = true;
                }
            } else if (this.entered) {
                ((JList)me.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.entered = false;
            }
        }
    }

    private static final class CertListCellRendered
    implements ListCellRenderer {
        CertListCellRendered() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CertificateLine line = (CertificateLine)value;
            if (isSelected) {
                line.setBackground(Color.decode("0xD9EAFF"));
                line.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.WHITE, 1), BorderFactory.createLineBorder(Color.decode("0x84ACDD"), 1)));
            } else {
                line.setBackground(Color.WHITE);
                line.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
            }
            return line;
        }
    }

    private static class CertificateLine
    extends JPanel {
        private static final long serialVersionUID = 5012625058876812352L;
        private static final Font SUBJECT_FONT = new Font("Verdana", 1, 14);
        private static final Font DETAILS_FONT = new Font("Verdana", 0, 11);
        private JLabel propertiesLink = null;
        private final String friendlyName;
        private final X509Certificate cert;

        CertificateLine(String friendlyName, X509Certificate cert) {
            this.friendlyName = friendlyName;
            this.cert = cert;
            this.createUI();
        }

        private static boolean isDNIeCert(X509Certificate certificate) {
            try {
                BasicAttributes attrs = new BasicAttributes(true);
                for (Rdn rdn : new LdapName(certificate.getIssuerDN().toString()).getRdns()) {
                    attrs.put(rdn.getType(), rdn.getValue());
                }
                return new SearchFilter("(&(cn=AC DNIE *)(ou=DNIE)(o=DIRECCION GENERAL DE LA POLICIA)(c=ES))").check(attrs);
            }
            catch (Exception e) {
                return false;
            }
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        @Override
        public String toString() {
            return this.friendlyName;
        }

        private void createUI() {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.WHITE);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.gridheight = 4;
            URL urlIcon = CertificateLine.isDNIeCert(this.cert) ? CertificateSelectionPanel.class.getClassLoader().getResource("resources/dnieicon.png") : CertificateSelectionPanel.class.getClassLoader().getResource("resources/certicon.png");
            JLabel icon = urlIcon != null ? new JLabel(new ImageIcon(urlIcon)) : new JLabel();
            c.insets = new Insets(2, 2, 2, 5);
            this.add((Component)icon, c);
            c.fill = 2;
            c.weightx = 1.0;
            ++c.gridx;
            c.gridheight = 1;
            c.insets = new Insets(5, 0, 0, 5);
            JLabel alias = new JLabel(this.friendlyName);
            alias.setFont(SUBJECT_FONT);
            this.add((Component)alias, c);
            ++c.gridy;
            c.insets = new Insets(0, 0, 0, 5);
            JLabel issuer = new JLabel(String.valueOf(JSEUIMessages.getString("CertificateSelectionPanel.2")) + AOUtil.getCN(this.cert.getIssuerDN().toString()));
            issuer.setFont(DETAILS_FONT);
            this.add((Component)issuer, c);
            ++c.gridy;
            JLabel dates = new JLabel(JSEUIMessages.getString("CertificateSelectionPanel.3", new String[]{CertificateLine.formatDate(this.cert.getNotBefore()), CertificateLine.formatDate(this.cert.getNotAfter())}));
            dates.setFont(DETAILS_FONT);
            this.add((Component)dates, c);
            ++c.gridy;
            this.propertiesLink = new JLabel("<html><u>" + JSEUIMessages.getString("CertificateSelectionPanel.5") + "</u></html>");
            this.propertiesLink.setFont(DETAILS_FONT);
            this.add((Component)this.propertiesLink, c);
        }

        private static String formatDate(Date date) {
            return new SimpleDateFormat("dd/MM/yyyy").format(date);
        }

        Rectangle getCertificateLinkBounds() {
            return this.propertiesLink.getBounds();
        }
    }
}

