/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.ui.core.jse;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.ui.core.jse.JSEUIManager;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;

public final class AWTUIManager
extends JSEUIManager {
    @Override
    public File saveDataToFile(byte[] data, String dialogTitle, String currentDir, String selectedFile, final String[] exts, String description, Object parent) throws IOException {
        FileDialog fd = new FileDialog(parent instanceof Frame ? (Frame)parent : null, dialogTitle, 1);
        if (selectedFile != null && currentDir != null && Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            fd.setFile(new File(currentDir, selectedFile).getAbsolutePath());
        } else {
            if (selectedFile != null) {
                fd.setFile(selectedFile);
            }
            if (currentDir != null) {
                fd.setDirectory(currentDir);
            }
        }
        if (exts != null) {
            fd.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String[] stringArray = exts;
                    int n = exts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ext = stringArray[n2];
                        if (name.endsWith(ext)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            });
        }
        fd.setVisible(true);
        if (fd.getFile() == null) {
            throw new AOCancelledOperationException();
        }
        File file = new File(String.valueOf(fd.getDirectory()) + fd.getFile());
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(data);
        fos.flush();
        fos.close();
        return file;
    }

    @Override
    public File[] getLoadFiles(String dialogTitle, String currentDir, String filename, final String[] extensions, String description, boolean selectDirectory, boolean multiSelect, Object parent) {
        FileDialog fd = new FileDialog(parent instanceof Frame ? (Frame)parent : null, dialogTitle);
        fd.setMode(0);
        if (currentDir != null) {
            fd.setDirectory(currentDir);
        }
        if (multiSelect) {
            try {
                Method setMultipleModeMethod = FileDialog.class.getMethod("setMultipleMode", Boolean.TYPE);
                setMultipleModeMethod.invoke((Object)fd, multiSelect);
            }
            catch (Exception e) {
                LOGGER.warning("No es posible utilizar la seleccion multiple de ficheros con los dialogos del sistema con versiones anteriores de Java 7, se utilizara Swing");
                return super.getLoadFiles(dialogTitle, currentDir, filename, extensions, description, selectDirectory, multiSelect, parent);
            }
        }
        if (filename != null) {
            fd.setFile(filename);
        }
        if (extensions != null && extensions.length > 0) {
            if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
                String ext = extensions[0];
                if (!ext.startsWith("*.")) {
                    ext = ext.startsWith(".") ? "*" + ext : "*." + ext;
                }
                fd.setFile(ext);
            } else {
                fd.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String[] stringArray = extensions;
                        int n = extensions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String ext = stringArray[n2];
                            if (name.endsWith(ext)) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                });
            }
        }
        fd.setVisible(true);
        if (fd.getFile() == null) {
            throw new AOCancelledOperationException();
        }
        if (multiSelect && AWTUIManager.isJava7()) {
            File[] files;
            try {
                Method getFilesMethod = FileDialog.class.getMethod("getFiles", new Class[0]);
                files = (File[])getFilesMethod.invoke((Object)fd, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.warning("Error de reflexion al recuperar la seleccion multiple del dialogo de carga, se devolvera un unico fichero: " + e);
                files = new File[]{new File(fd.getFile())};
            }
            if (files == null) {
                files = new File[]{};
            }
            return files;
        }
        return new File[]{new File(fd.getDirectory(), fd.getFile())};
    }

    private static boolean isJava7() {
        return System.getProperty("java.version").startsWith("1.7");
    }
}

