/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.tsp.pkcs7;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.URI;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cmp.PKIFailureInfo;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public final class CMSTimestamper {
    public static final String CATCERT_TSP = "http://psis.catcert.net/psis/catcert/tsp";
    public static final String CATCERT_POLICY = "0.4.0.2023.1.1";
    public static final Boolean CATCERT_REQUIRECERT = Boolean.TRUE;
    private static final String SIGNATURE_TIMESTAMP_TOKEN_OID = "1.2.840.113549.1.9.16.2.14";
    private final TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
    private final URI tsaURL;
    private final String tsaUsername;
    private final String tsaPassword;

    public CMSTimestamper(boolean requireCert, String policy, URI tsa, String tsaUsr, String tsaPwd, TsaRequestExtension[] extensions) {
        if (extensions != null) {
            TsaRequestExtension[] tsaRequestExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                TsaRequestExtension ext = tsaRequestExtensionArray[n2];
                this.tsqGenerator.addExtension(new ASN1ObjectIdentifier(ext.getOid()), ext.isCritical(), ext.getValue());
                Logger.getLogger("es.gob.afirma").info("Anadida extension a la solicitud de sello de tiempo: " + ext);
                ++n2;
            }
        }
        this.tsqGenerator.setCertReq(requireCert);
        this.tsqGenerator.setReqPolicy(new ASN1ObjectIdentifier(policy));
        this.tsaURL = tsa;
        this.tsaPassword = tsaPwd;
        this.tsaUsername = tsaUsr;
    }

    public byte[] addTimestamp(byte[] pkcs7, String hashAlgorithm) throws NoSuchAlgorithmException, AOException, IOException {
        CMSSignedData signedData;
        try {
            signedData = new CMSSignedData(pkcs7);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Los datos de entrada no son un SignedData de CMS: " + e);
        }
        SignerInformationStore origSignerInfoStore = signedData.getSignerInfos();
        ArrayList<SignerInformation> vNewSigners = new ArrayList<SignerInformation>();
        Collection ovSigners = origSignerInfoStore.getSigners();
        for (Object name : ovSigners) {
            SignerInformation si = (SignerInformation)name;
            byte[] tsToken = this.getTimeStampToken(si.getSignature(), hashAlgorithm);
            ASN1InputStream is = new ASN1InputStream(new ByteArrayInputStream(tsToken));
            ASN1Primitive derObj = is.readObject();
            is.close();
            DERSet derSet = new DERSet(derObj);
            Attribute unsignAtt = new Attribute(new ASN1ObjectIdentifier(SIGNATURE_TIMESTAMP_TOKEN_OID), (ASN1Set)derSet);
            Hashtable<ASN1ObjectIdentifier, Attribute> ht = new Hashtable<ASN1ObjectIdentifier, Attribute>();
            ht.put(new ASN1ObjectIdentifier(SIGNATURE_TIMESTAMP_TOKEN_OID), unsignAtt);
            AttributeTable unsignedAtts = new AttributeTable(ht);
            vNewSigners.add(SignerInformation.replaceUnsignedAttributes(si, unsignedAtts));
        }
        return CMSSignedData.replaceSigners(signedData, new SignerInformationStore(vNewSigners)).getEncoded();
    }

    private byte[] getTSAResponse(byte[] request) throws IOException {
        if (this.tsaURL.getScheme().equals("socket")) {
            return this.getTSAResponseSocket(request);
        }
        if (this.tsaURL.getScheme().equals("http")) {
            return this.getTSAResponseHttp(request);
        }
        throw new UnsupportedOperationException("Protocolo de conexion con TSA no soportado: " + this.tsaURL.getScheme());
    }

    private byte[] getTSAResponseSocket(byte[] request) throws IOException {
        Socket socket = new Socket(this.tsaURL.getHost(), this.tsaURL.getPort());
        socket.setSoTimeout(500000);
        byte[] ret = CMSTimestamper.getTSAResponseExternalSocket(request, socket);
        socket.close();
        return ret;
    }

    private static byte[] getTSAResponseExternalSocket(byte[] request, Socket socket) throws IOException {
        DataOutputStream dataoutputstream = new DataOutputStream(socket.getOutputStream());
        dataoutputstream.writeInt(request.length + 1);
        dataoutputstream.writeByte(0);
        dataoutputstream.write(request);
        dataoutputstream.flush();
        socket.getOutputStream().flush();
        DataInputStream datainputstream = new DataInputStream(socket.getInputStream());
        int size = datainputstream.readInt();
        byte byte0 = datainputstream.readByte();
        byte[] resp = new byte[size - 1];
        datainputstream.readFully(resp);
        if (byte0 != 5 && byte0 != 6) {
            throw new IOException("Obtenida resuesta incorrecta del servidor TSA: " + new String(resp));
        }
        socket.close();
        return resp;
    }

    private byte[] getTSAResponseHttp(byte[] requestBytes) throws IOException {
        URLConnection tsaConnection = this.tsaURL.toURL().openConnection();
        tsaConnection.setDoInput(true);
        tsaConnection.setDoOutput(true);
        tsaConnection.setUseCaches(false);
        tsaConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        tsaConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        if (this.tsaUsername != null && !"".equals(this.tsaUsername)) {
            String userPassword = String.valueOf(this.tsaUsername) + ":" + this.tsaPassword;
            tsaConnection.setRequestProperty("Authorization", "Basic " + new String(Base64.encode(userPassword.getBytes())));
        }
        OutputStream out = tsaConnection.getOutputStream();
        out.write(requestBytes);
        out.flush();
        out.close();
        byte[] respBytes = AOUtil.getDataFromInputStream(tsaConnection.getInputStream());
        String encoding = tsaConnection.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("base64")) {
            return Base64.decode(new String(respBytes));
        }
        return respBytes;
    }

    private byte[] getTimeStampToken(byte[] imprint, String hashAlgorithm) throws AOException, IOException {
        int value;
        TimeStampResponse response;
        TimeStampRequest request = this.tsqGenerator.generate(new ASN1ObjectIdentifier(hashAlgorithm != null ? AOAlgorithmID.getOID(hashAlgorithm) : X509ObjectIdentifiers.id_SHA1.getId()), imprint, BigInteger.valueOf(System.currentTimeMillis()));
        byte[] requestBytes = request.getEncoded();
        byte[] rawResponse = this.getTSAResponse(requestBytes);
        try {
            response = new TimeStampResponse(rawResponse);
        }
        catch (Exception e) {
            throw new AOException("Error obteniendo la respuesta de la TSA", e);
        }
        try {
            response.validate(request);
        }
        catch (Exception e) {
            throw new AOException("Error validando la respuesta de la TSA", e);
        }
        PKIFailureInfo failure = response.getFailInfo();
        int n = value = failure == null ? 0 : failure.intValue();
        if (value != 0) {
            throw new AOException("Respuesta invalida de la TSA ('" + this.tsaURL + "') con el codigo " + value);
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new AOException("La respuesta de la TSA ('" + this.tsaURL + "') no es un sello de tiempo valido: " + new String(rawResponse));
        }
        return tsToken.getEncoded();
    }

    public static class TsaRequestExtension {
        private final String oid;
        private final boolean critical;
        private final byte[] value;

        public String toString() {
            return "Extension [OID: " + this.oid + ", citical: " + this.critical + ", value: " + new String(this.value) + "]";
        }

        public TsaRequestExtension(String oid, boolean isCritical, byte[] value) {
            if (oid == null || "".equals(oid)) {
                throw new IllegalArgumentException("Las extensiones TSA necesitan obligatoriamente un OID");
            }
            if (value == null || value.length < 1) {
                throw new IllegalArgumentException("Las extensiones TSA necesitan obligatoriamente un valor");
            }
            this.oid = oid;
            this.critical = isCritical;
            this.value = (byte[])value.clone();
        }

        boolean isCritical() {
            return this.critical;
        }

        String getOid() {
            return this.oid;
        }

        byte[] getValue() {
            return (byte[])this.value.clone();
        }
    }
}

