/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;

public final class SignedAndEnvelopedData
extends ASN1Object {
    private final DERInteger version;
    private final ASN1Set recipientInfos;
    private final ASN1Set digestAlgorithms;
    private final EncryptedContentInfo encryptedContentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private final ASN1Set signerInfos;

    public SignedAndEnvelopedData(ASN1Set recipientInfos, ASN1Set digestAlgorithms, EncryptedContentInfo encryptedContentInfo, ASN1Set certificates, ASN1Set crls, ASN1Set signerInfos) {
        this.version = new DERInteger(1);
        this.recipientInfos = recipientInfos;
        this.digestAlgorithms = digestAlgorithms;
        this.encryptedContentInfo = encryptedContentInfo;
        this.certificates = certificates;
        this.crls = crls;
        this.signerInfos = signerInfos;
    }

    public SignedAndEnvelopedData(ASN1Sequence seq) {
        int index = 0;
        this.version = (DERInteger)seq.getObjectAt(index++);
        this.recipientInfos = ASN1Set.getInstance(seq.getObjectAt(index++));
        this.digestAlgorithms = ASN1Set.getInstance(seq.getObjectAt(index++));
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(seq.getObjectAt(index++));
        if (seq.size() > 5) {
            if (seq.size() == 6) {
                this.certificates = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(index++), false);
            } else {
                this.certificates = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(index++), false);
                this.crls = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(index++), false);
            }
        }
        this.signerInfos = ASN1Set.getInstance(seq.getObjectAt(index++));
    }

    public static SignedAndEnvelopedData getInstance(Object obj) {
        if (obj == null || obj instanceof SignedAndEnvelopedData) {
            return (SignedAndEnvelopedData)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new SignedAndEnvelopedData((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("EnvelopedData invalido: " + obj.getClass().getName());
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.recipientInfos);
        v.add(this.digestAlgorithms);
        v.add(this.encryptedContentInfo);
        if (this.certificates != null) {
            v.add(new DERTaggedObject(false, 1, this.certificates));
        }
        if (this.crls != null) {
            v.add(new DERTaggedObject(false, 1, this.crls));
        }
        v.add(this.signerInfos);
        return new BERSequence(v);
    }
}

