/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOSimpleSignInfo;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.core.util.tree.AOTreeNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public final class ReadNodesTree {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private String stringRetorn = "";
    private AOTreeNode rama;
    private AOTreeNode rama2;
    private int[] seleccionados;
    private final List<String> lista = new ArrayList<String>();
    private final List<X509Certificate[]> listaCert = new ArrayList<X509Certificate[]>();

    int[] getSeleccionados() {
        return this.seleccionados;
    }

    void setSeleccionados(int[] seleccionados) {
        this.seleccionados = (int[])seleccionados.clone();
    }

    String getStringRetorn() {
        return this.stringRetorn;
    }

    void setStringRetorn(String stringRetorn) {
        this.stringRetorn = stringRetorn;
    }

    public AOTreeModel readNodesTree(byte[] data, boolean asSimpleSignInfo) throws IOException {
        AOTreeNode raiz;
        block5: {
            ASN1Set certificates;
            ASN1Set signerInfosSd;
            block4: {
                ASN1InputStream is = new ASN1InputStream(data);
                ASN1Sequence dsq = (ASN1Sequence)is.readObject();
                is.close();
                Enumeration contentsData = dsq.getObjects();
                contentsData.nextElement();
                ASN1TaggedObject doj = (ASN1TaggedObject)contentsData.nextElement();
                ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
                signerInfosSd = null;
                certificates = null;
                try {
                    SignedData sd = SignedData.getInstance(contentSignedData);
                    signerInfosSd = sd.getSignerInfos();
                    certificates = sd.getCertificates();
                }
                catch (Exception e) {
                    LOGGER.severe("Error obteniendo los SignerInfos del SignedData: " + e);
                }
                raiz = new AOTreeNode("Datos");
                if (!asSimpleSignInfo || signerInfosSd == null) break block4;
                int i = 0;
                while (i < signerInfosSd.size()) {
                    ASN1Sequence atribute = (ASN1Sequence)signerInfosSd.getObjectAt(i);
                    IssuerAndSerialNumber issuerSerial = new IssuerAndSerialNumber((ASN1Sequence)atribute.getObjectAt(1));
                    X509Certificate[] nameSigner = ReadNodesTree.searchCert(certificates, issuerSerial.getSerialNumber());
                    SignerInfo si = new SignerInfo(atribute);
                    Date signingTime = ReadNodesTree.getSigningTime(si);
                    AOSimpleSignInfo aossi = new AOSimpleSignInfo(nameSigner, signingTime);
                    aossi.setPkcs1(si.getEncryptedDigest().getOctets());
                    this.rama = new AOTreeNode(aossi);
                    this.listaCert.add(nameSigner);
                    this.getUnsignedAtributesWithCertificates(si.getUnauthenticatedAttributes(), this.rama, certificates);
                    raiz.add(this.rama);
                    ++i;
                }
                break block5;
            }
            if (signerInfosSd == null) break block5;
            int i = 0;
            while (i < signerInfosSd.size()) {
                ASN1Sequence atribute = (ASN1Sequence)signerInfosSd.getObjectAt(i);
                IssuerAndSerialNumber issuerSerial = new IssuerAndSerialNumber((ASN1Sequence)atribute.getObjectAt(1));
                String nameSigner = ReadNodesTree.searchName(certificates, issuerSerial.getSerialNumber());
                SignerInfo si = new SignerInfo(atribute);
                this.rama = new AOTreeNode(nameSigner);
                this.lista.add(nameSigner);
                this.getUnsignedAtributes(si.getUnauthenticatedAttributes(), this.rama, certificates);
                raiz.add(this.rama);
                ++i;
            }
        }
        return new AOTreeModel(raiz);
    }

    private void getUnsignedAtributesWithCertificates(ASN1Set signerInfouAtrib, AOTreeNode ramahija, ASN1Set certificates) {
        if (signerInfouAtrib != null) {
            Enumeration eAtributes = signerInfouAtrib.getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) continue;
                ASN1Set setInto = data.getAttrValues();
                Enumeration eAtributesData = setInto.getObjects();
                while (eAtributesData.hasMoreElements()) {
                    Object obj = eAtributesData.nextElement();
                    if (!(obj instanceof ASN1Sequence)) continue;
                    ASN1Sequence atrib = (ASN1Sequence)obj;
                    IssuerAndSerialNumber issuerSerial = new IssuerAndSerialNumber((ASN1Sequence)atrib.getObjectAt(1));
                    SignerInfo si = new SignerInfo(atrib);
                    X509Certificate[] nameSigner = ReadNodesTree.searchCert(certificates, issuerSerial.getSerialNumber());
                    Date signingTime = ReadNodesTree.getSigningTime(si);
                    AOSimpleSignInfo aossi = new AOSimpleSignInfo(nameSigner, signingTime);
                    aossi.setPkcs1(si.getEncryptedDigest().getOctets());
                    this.rama2 = new AOTreeNode(aossi);
                    this.listaCert.add(nameSigner);
                    ramahija.add(this.rama2);
                    this.getUnsignedAtributesWithCertificates(si.getUnauthenticatedAttributes(), this.rama2, certificates);
                }
            }
        }
    }

    private void getUnsignedAtributes(ASN1Set signerInfouAtrib, AOTreeNode ramahija, ASN1Set certificates) {
        if (signerInfouAtrib != null) {
            Enumeration eAtributes = signerInfouAtrib.getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) continue;
                ASN1Set setInto = data.getAttrValues();
                Enumeration eAtributesData = setInto.getObjects();
                while (eAtributesData.hasMoreElements()) {
                    Object obj = eAtributesData.nextElement();
                    if (!(obj instanceof ASN1Sequence)) continue;
                    ASN1Sequence atrib = (ASN1Sequence)obj;
                    IssuerAndSerialNumber issuerSerial = new IssuerAndSerialNumber((ASN1Sequence)atrib.getObjectAt(1));
                    SignerInfo si = new SignerInfo(atrib);
                    String nameSigner = ReadNodesTree.searchName(certificates, issuerSerial.getSerialNumber());
                    this.rama2 = new AOTreeNode(nameSigner);
                    this.lista.add(nameSigner);
                    ramahija.add(this.rama2);
                    this.getUnsignedAtributes(si.getUnauthenticatedAttributes(), this.rama2, certificates);
                }
            }
        }
    }

    public int[] readNodesFromSigners(String[] signers, byte[] data) throws IOException {
        this.readNodesTree(data, false);
        List<String> listaComp = this.lista;
        int[] nodesToSign = new int[listaComp.size()];
        int cont = 0;
        int i = 0;
        while (i < listaComp.size()) {
            String[] stringArray = signers;
            int n = signers.length;
            int n2 = 0;
            while (n2 < n) {
                String aux2 = stringArray[n2];
                String aux = listaComp.get(i);
                if (aux.equals(aux2)) {
                    nodesToSign[cont] = i;
                    ++cont;
                }
                ++n2;
            }
            ++i;
        }
        int[] solucion = new int[cont];
        System.arraycopy(nodesToSign, 0, solucion, 0, cont);
        solucion = ReadNodesTree.simplyArray(solucion);
        Arrays.sort(solucion);
        return solucion;
    }

    public static int[] simplyArray(int[] nodes) {
        ArrayList<Integer> devolver = new ArrayList<Integer>();
        int i = 0;
        while (i < nodes.length) {
            if (!devolver.contains(nodes[i])) {
                devolver.add(nodes[i]);
            }
            ++i;
        }
        int[] simplificado = new int[devolver.size()];
        int i2 = 0;
        while (i2 < devolver.size()) {
            simplificado[i2] = (Integer)devolver.get(i2);
            ++i2;
        }
        return simplificado;
    }

    private static String searchName(ASN1Set certificates, DERInteger serialNumber) {
        Enumeration certSet = certificates.getObjects();
        while (certSet.hasMoreElements()) {
            X509Certificate c;
            try {
                c = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(((ASN1Sequence)certSet.nextElement()).getEncoded()));
            }
            catch (Exception e) {
                LOGGER.severe("Error extrayendo los certificados del Set ASN.1, puede que se haya omitido un elemento valido" + e);
                continue;
            }
            if (!c.getSerialNumber().equals(serialNumber.getValue())) continue;
            return AOUtil.getCN(c);
        }
        LOGGER.info("No se ha encontrado el certificado indicado, se devolvera una cadena vacia");
        return "";
    }

    private static X509Certificate[] searchCert(ASN1Set certificates, DERInteger serialNumber) {
        Enumeration certSet = certificates.getObjects();
        while (certSet.hasMoreElements()) {
            X509Certificate c;
            try {
                c = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(((ASN1Sequence)certSet.nextElement()).getEncoded()));
            }
            catch (Exception e) {
                LOGGER.severe("Error extrayendo los certificados del Set ASN.1, puede que se haya omitido un elemento valido" + e);
                continue;
            }
            if (!c.getSerialNumber().equals(serialNumber.getValue())) continue;
            return new X509Certificate[]{c};
        }
        LOGGER.severe("El certificados pedido no estaba en la lista, se devolvera un array vacio");
        return new X509Certificate[0];
    }

    private static Date getSigningTime(SignerInfo si) {
        Date returnDate = null;
        if (si.getAuthenticatedAttributes() != null) {
            Enumeration eAtributes = si.getAuthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(CMSAttributes.signingTime)) continue;
                ASN1Set time = data.getAttrValues();
                DERUTCTime d = (DERUTCTime)time.getObjectAt(0);
                try {
                    returnDate = d.getDate();
                }
                catch (ParseException ex) {
                    LOGGER.warning("No es posible convertir la fecha");
                }
            }
        }
        return returnDate;
    }
}

