/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class ObtainContentSignedData {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private ObtainContentSignedData() {
    }

    public static byte[] obtainData(byte[] data) throws IOException {
        byte[] contenido = null;
        ASN1InputStream is = new ASN1InputStream(data);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        DERObjectIdentifier doi = (DERObjectIdentifier)e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        if (doi.equals(PKCSObjectIdentifiers.signedData)) {
            SignedData sd = SignedData.getInstance(doj.getObject());
            ContentInfo ci = sd.getEncapContentInfo();
            if (ci.getContent() != null) {
                contenido = ((DEROctetString)ci.getContent()).getOctets();
            } else {
                LOGGER.warning("No existe contenido en esta firma.");
            }
        } else {
            LOGGER.warning("No se puede obtener el contenido de esta firma.");
        }
        return contenido;
    }

    public static byte[] obtainMessageDigest(byte[] signature, String digestAlgorithm) throws IOException {
        ASN1InputStream is = new ASN1InputStream(signature);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        DERObjectIdentifier doi = (DERObjectIdentifier)e.nextElement();
        if (!doi.equals(PKCSObjectIdentifiers.signedData)) {
            LOGGER.warning("No se puede obtener el contenido de esta firma.");
            return null;
        }
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        SignedData sd = SignedData.getInstance(doj.getObject());
        ASN1Set signerInfosSd = sd.getSignerInfos();
        byte[] messageDigest = null;
        int i = 0;
        while (i < signerInfosSd.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i));
            AlgorithmIdentifier algHash = si.getDigestAlgorithm();
            if (algHash.getAlgorithm().toString().equals(AOAlgorithmID.getOID(digestAlgorithm))) {
                ASN1Set signedAttrib = si.getAuthenticatedAttributes();
                int s = 0;
                while (s < signedAttrib.size()) {
                    ASN1Sequence elemento = (ASN1Sequence)signedAttrib.getObjectAt(s);
                    DERObjectIdentifier oids = (DERObjectIdentifier)elemento.getObjectAt(0);
                    if (CMSAttributes.messageDigest.getId().equals(oids.toString())) {
                        DERSet derSetHash = (DERSet)elemento.getObjectAt(1);
                        DEROctetString derHash = (DEROctetString)derSetHash.getObjectAt(0);
                        messageDigest = derHash.getOctets();
                        break;
                    }
                    ++s;
                }
                if (messageDigest != null) break;
            }
            ++i;
        }
        if (messageDigest == null) {
            LOGGER.warning("No se ha encontrado en la firma una huella digital generada con el algoritmo: " + digestAlgorithm);
        }
        return messageDigest;
    }
}

