/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class DigestedData
implements ASN1Encodable {
    private final DERInteger version;
    private final AlgorithmIdentifier digestAlgorithm;
    private final ContentInfo contentInfo;
    private final ASN1OctetString digest;

    static DigestedData getInstance(Object o) {
        if (o instanceof DigestedData) {
            return (DigestedData)o;
        }
        if (o instanceof ASN1Sequence) {
            return new DigestedData((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Objeto desconocido: " + o.getClass().getName());
    }

    public DigestedData(AlgorithmIdentifier digestAlgo, ContentInfo contentInfo, ASN1OctetString digest) {
        this.version = new DERInteger(0);
        this.digestAlgorithm = digestAlgo;
        this.contentInfo = contentInfo;
        this.digest = digest;
    }

    public DigestedData(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = (DERInteger)e.nextElement();
        this.digestAlgorithm = new AlgorithmIdentifier((ASN1Sequence)e.nextElement());
        this.contentInfo = new ContentInfo((ASN1Sequence)e.nextElement());
        this.digest = (ASN1OctetString)e.nextElement();
    }

    public String getVersion() {
        return this.version.toString();
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm.getAlgorithm().toString();
    }

    ASN1OctetString getDigest() {
        return this.digest;
    }

    public String getContentType() {
        return this.contentInfo.getContentType().toString();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.digestAlgorithm);
        v.add(this.contentInfo);
        v.add(this.digest);
        return new BERSequence(v);
    }
}

