/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.pkcs7;

import java.util.Dictionary;
import java.util.Hashtable;

public final class AOAlgorithmID {
    private static final String OID_SHA1 = "1.3.14.3.2.26";
    private static final String OID_SHA512 = "2.16.840.1.101.3.4.2.3";
    private static final String OID_MD2 = "1.2.840.113549.2.2";
    private static final String OID_MD5 = "1.2.840.113549.2.5";
    private static final String OID_SHA256 = "2.16.840.1.101.3.4.2.1";
    private static final String OID_SHA384 = "2.16.840.1.101.3.4.2.2";
    private static final String OID_RSA = "1.2.840.113549.1.1.1";
    private static final Dictionary<String, String> OIDS = new Hashtable<String, String>();

    static {
        OIDS.put("SHA1", OID_SHA1);
        OIDS.put("SHA-1", OID_SHA1);
        OIDS.put("SHA", OID_SHA1);
        OIDS.put(OID_SHA1, OID_SHA1);
        OIDS.put("SHA-512", OID_SHA512);
        OIDS.put("SHA512", OID_SHA512);
        OIDS.put(OID_SHA512, OID_SHA512);
        OIDS.put("MD2", OID_MD2);
        OIDS.put(OID_MD2, OID_MD2);
        OIDS.put("MD5", OID_MD5);
        OIDS.put(OID_MD5, OID_MD5);
        OIDS.put("SHA-256", OID_SHA256);
        OIDS.put("SHA256", OID_SHA256);
        OIDS.put(OID_SHA256, OID_SHA256);
        OIDS.put("SHA-384", OID_SHA384);
        OIDS.put("SHA384", OID_SHA384);
        OIDS.put(OID_SHA384, OID_SHA384);
        OIDS.put("RSA", OID_RSA);
        OIDS.put(OID_RSA, OID_RSA);
    }

    private AOAlgorithmID() {
    }

    public static String getOID(String name) {
        if (name == null) {
            return null;
        }
        String res = OIDS.get(name.toUpperCase());
        if (res == null) {
            throw new IllegalArgumentException("Se deconoce el algoritmo '" + name + "'");
        }
        return res;
    }
}

