/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

public final class CAdESTriPhaseCounterSigner {
    public static final int PKCS1_DEFAULT_SIZE = 128;
    private int counterIndex = 0;
    private ArrayList<byte[]> signedDatas = new ArrayList();

    public CAdESPreCounterSignResult preCounterSign(P7ContentSignerParameters parameters, byte[] data, CounterSignTarget targetType, PrivateKey key, java.security.cert.Certificate[] certChain, AdESPolicy policy, boolean signingCertificateV2, String contentType, String contentDescription) throws IOException, NoSuchAlgorithmException, CertificateException, AOException {
        this.counterIndex = 0;
        this.signedDatas = new ArrayList();
        ASN1InputStream is = new ASN1InputStream(data);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedData sd = SignedData.getInstance(contentSignedData);
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1Set certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (certChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            java.security.cert.Certificate[] certificateArray = certChain;
            int n = certChain.length;
            int n2 = 0;
            while (n2 < n) {
                java.security.cert.Certificate element = certificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        ASN1Set certrevlist = null;
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        if (CounterSignTarget.TREE.equals((Object)targetType)) {
            signerInfos = this.counterTree(signerInfosSd, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2);
        } else if (CounterSignTarget.LEAFS.equals((Object)targetType)) {
            signerInfos = this.counterLeaf(signerInfosSd, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2);
        } else {
            throw new IllegalArgumentException("Modo de contrafirma no soportado: " + (Object)((Object)targetType));
        }
        return new CAdESPreCounterSignResult(new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(sd.getDigestAlgorithms(), sd.getEncapContentInfo(), certificates, certrevlist, new DERSet(signerInfos))).getEncoded("DER"), this.signedDatas);
    }

    private ASN1EncodableVector counterTree(ASN1Set signerInfosRaiz, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosRaiz.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosRaiz.getObjectAt(i));
            counterSigners.add(this.getCounterSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
            ++i;
        }
        return counterSigners;
    }

    private ASN1EncodableVector counterLeaf(ASN1Set signerInfosRaiz, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosRaiz.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosRaiz.getObjectAt(i));
            counterSigners.add(this.getLeafSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
            ++i;
        }
        return counterSigners;
    }

    private SignerInfo getCounterSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Attribute uAtrib;
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        SignerInfo si = new SignerInfo((ASN1Sequence)eAtributesData.nextElement());
                        signerInfosU.add(this.getCounterSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            counterSigner = this.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, certChain, contentType, contentDescription, policy, signingCertificateV2);
            signerInfosU.add(counterSigner);
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(this.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, certChain, contentType, contentDescription, policy, signingCertificateV2));
                    uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
                    contexExpecific.add(uAtrib);
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
            }
        } else {
            signerInfosU2.add(this.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, certChain, contentType, contentDescription, policy, signingCertificateV2));
            Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
        }
        return counterSigner;
    }

    private SignerInfo getLeafSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Attribute uAtrib;
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        SignerInfo si = new SignerInfo((ASN1Sequence)eAtributesData.nextElement());
                        signerInfosU.add(this.getLeafSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(this.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, certChain, contentType, contentDescription, policy, signingCertificateV2));
                    uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
                    contexExpecific.add(uAtrib);
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
            }
        } else {
            signerInfosU2.add(this.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, certChain, contentType, contentDescription, policy, signingCertificateV2));
            Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
        }
        return counterSigner;
    }

    private SignerInfo generateSignerInfo(String signatureAlgorithm, SignerInfo si, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException {
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        ASN1EncodableVector contextExcepcific = CAdESUtils.generateSignerInfo((X509Certificate)certChain[0], digestAlgorithm, si.getEncryptedDigest().getOctets(), policy, signingCertificateV2, null, new Date(), false, contentType, contentDescription);
        ASN1Set signedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExcepcific));
        this.signedDatas.add(this.counterIndex, signedAttr.getEncoded("DER"));
        DEROctetString sign2 = new DEROctetString(this.firma());
        ++this.counterIndex;
        if (this.counterIndex > 9) {
            throw new UnsupportedOperationException("No se soportan mas de 10 contrafirmas en una misma firma");
        }
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certChain[0]).getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        ASN1Set unsignedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExcepcific));
        return new SignerInfo(identifier, digAlgId, unsignedAttr, encAlgId, sign2, null);
    }

    private byte[] firma() {
        byte[] dummy = new byte[128];
        Arrays.fill(dummy, (byte)Integer.toString(this.counterIndex).toCharArray()[0]);
        return dummy;
    }

    public static final class CAdESPreCounterSignResult {
        private final ArrayList<byte[]> preSigns;
        private final byte[] sign;

        CAdESPreCounterSignResult(byte[] s, ArrayList<byte[]> sDatas) {
            this.preSigns = sDatas;
            this.sign = (byte[])s.clone();
        }

        public byte[] getSign() {
            return this.sign;
        }

        public ArrayList<byte[]> getPreSigns() {
            return this.preSigns;
        }
    }
}

