/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;

public final class CAdESTriPhaseCoSigner {
    private CAdESTriPhaseCoSigner() {
    }

    public static byte[] preCoSign(byte[] content, String signatureAlgorithm, X509Certificate[] signerCertificateChain, AdESPolicy policy, boolean signingCertificateV2, byte[] messageDigest, String contentType, String contentDescription, Date signDate) throws CertificateEncodingException, NoSuchAlgorithmException, IOException {
        return CAdESTriPhaseCoSigner.getSignedAttributes(messageDigest, signerCertificateChain, AOSignConstants.getDigestAlgorithmName(signatureAlgorithm), content, signingCertificateV2, policy, contentType, contentDescription, signDate).getEncoded("DER");
    }

    private static ASN1Set getSignedAttributes(byte[] messageDigest, X509Certificate[] signerCertificateChain, String digestAlgorithm, byte[] content, boolean signingCertificateV2, AdESPolicy policy, String contentType, String contentDescription, Date signDate) throws CertificateEncodingException, NoSuchAlgorithmException, IOException {
        ASN1EncodableVector contextExpecific = CAdESUtils.generateSignerInfo(signerCertificateChain[0], digestAlgorithm, content, policy, signingCertificateV2, messageDigest, signDate, false, contentType, contentDescription);
        return SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
    }

    public static byte[] postCoSign(byte[] pkcs1sign, byte[] preCoSign, byte[] content, String signatureAlgorithm, X509Certificate[] signerCertificateChain, byte[] sign) throws IOException, CertificateEncodingException {
        DEROctetString asn1sign = new DEROctetString(pkcs1sign);
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(signerCertificateChain[0].getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(AOSignConstants.getDigestAlgorithmName(signatureAlgorithm)));
        ASN1Sequence contentSignedData = CAdESTriPhaseCoSigner.getContentSignedData(sign);
        SignedData sd = SignedData.getInstance(contentSignedData);
        ASN1Set certificatesSigned = sd.getCertificates();
        Enumeration certs = certificatesSigned.getObjects();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        ASN1Set certificates = null;
        if (signerCertificateChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            X509Certificate[] x509CertificateArray = signerCertificateChain;
            int n = signerCertificateChain.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate element = x509CertificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosSd.size()) {
            signerInfos.add(new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i)));
            ++i;
        }
        signerInfos.add(new SignerInfo(identifier, digAlgId, ASN1Set.getInstance(preCoSign), encAlgId, asn1sign, null));
        ContentInfo encInfo = CAdESTriPhaseCoSigner.getContentInfoFromContent(content);
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(sd.getDigestAlgorithms(), encInfo, certificates, null, new DERSet(signerInfos))).getEncoded("DER");
    }

    private static ContentInfo getContentInfoFromContent(byte[] content) throws IOException {
        ASN1ObjectIdentifier contentTypeOID = new ASN1ObjectIdentifier(PKCSObjectIdentifiers.data.getId());
        if (content != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            CMSProcessableByteArray msg = new CMSProcessableByteArray(content);
            try {
                msg.write(bOut);
            }
            catch (CMSException ex) {
                throw new IOException("Error en la escritura del procesable CMS: " + ex, ex);
            }
            return new ContentInfo(contentTypeOID, new BEROctetString(bOut.toByteArray()));
        }
        return new ContentInfo(contentTypeOID, null);
    }

    private static ASN1Sequence getContentSignedData(byte[] sign) {
        ASN1Sequence dsq = ASN1Sequence.getInstance(sign);
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        return (ASN1Sequence)doj.getObject();
    }
}

