/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import es.gob.afirma.signers.pkcs7.SignedAndEnvelopedData;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

final class CAdESCounterSignerEnveloped {
    private int actualIndex = 0;
    private ASN1Set signedAttr2;
    private AdESPolicy globalPolicy;
    private boolean globalSigningCertificateV2;

    CAdESCounterSignerEnveloped() {
    }

    private void setGlobalPolicy(AdESPolicy pol) {
        this.globalPolicy = pol;
    }

    private AdESPolicy getGlobalPolicy() {
        return this.globalPolicy;
    }

    private boolean isGlobalSigningCertificateV2() {
        return this.globalSigningCertificateV2;
    }

    private void setGlobalsigningCertificateV2(boolean globalsigningCertificateV2) {
        this.globalSigningCertificateV2 = globalsigningCertificateV2;
    }

    byte[] counterSigner(P7ContentSignerParameters parameters, byte[] data, CounterSignTarget targetType, int[] targets, PrivateKey key, java.security.cert.Certificate[] certChain, AdESPolicy policy, boolean signingCertificateV2, String contentType, String contentDescription) throws IOException, NoSuchAlgorithmException, CertificateException, AOException {
        this.setGlobalPolicy(policy);
        this.setGlobalsigningCertificateV2(signingCertificateV2);
        ASN1InputStream is = new ASN1InputStream(data);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedAndEnvelopedData sd = new SignedAndEnvelopedData(contentSignedData);
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1Set certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (certChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            java.security.cert.Certificate[] certificateArray = certChain;
            int n = certChain.length;
            int n2 = 0;
            while (n2 < n) {
                java.security.cert.Certificate element = certificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        ASN1Set certrevlist = null;
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        if (targetType.equals((Object)CounterSignTarget.TREE)) {
            signerInfos = this.counterTree(signerInfosSd, parameters, key, certChain, contentType, contentDescription);
        } else if (targetType.equals((Object)CounterSignTarget.LEAFS)) {
            signerInfos = this.counterLeaf(signerInfosSd, parameters, key, certChain, contentType, contentDescription);
        } else {
            if (targetType.equals((Object)CounterSignTarget.NODES)) {
                SignedAndEnvelopedData aux = sd;
                int nodo = 0;
                int i = targets.length - 1;
                while (i >= 0) {
                    nodo = targets[i];
                    signerInfos = this.counterNode(aux, parameters, key, certChain, contentType, contentDescription, nodo);
                    SignedAndEnvelopedData sigDat = new SignedAndEnvelopedData(sd.getRecipientInfos(), sd.getDigestAlgorithms(), sd.getEncryptedContentInfo(), certificates, certrevlist, new DERSet(signerInfos));
                    ASN1InputStream sd2 = new ASN1InputStream(sigDat.toASN1Primitive().getEncoded("DER"));
                    ASN1Sequence contentSignedData2 = (ASN1Sequence)sd2.readObject();
                    sd2.close();
                    aux = new SignedAndEnvelopedData(contentSignedData2);
                    --i;
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, aux).getEncoded("DER");
            }
            if (targetType.equals((Object)CounterSignTarget.SIGNERS)) {
                SignedAndEnvelopedData aux = sd;
                int nodo = 0;
                int i = targets.length - 1;
                while (i >= 0) {
                    nodo = targets[i];
                    signerInfos = this.counterNode(aux, parameters, key, certChain, contentType, contentDescription, nodo);
                    SignedAndEnvelopedData sigDat = new SignedAndEnvelopedData(sd.getRecipientInfos(), sd.getDigestAlgorithms(), sd.getEncryptedContentInfo(), certificates, certrevlist, new DERSet(signerInfos));
                    ASN1InputStream sd2 = new ASN1InputStream(sigDat.getEncoded("DER"));
                    ASN1Sequence contentSignedData2 = (ASN1Sequence)sd2.readObject();
                    sd2.close();
                    aux = new SignedAndEnvelopedData(contentSignedData2);
                    --i;
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, aux).getEncoded("DER");
            }
        }
        return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, new SignedAndEnvelopedData(sd.getRecipientInfos(), sd.getDigestAlgorithms(), sd.getEncryptedContentInfo(), certificates, certrevlist, new DERSet(signerInfos))).getEncoded("DER");
    }

    private ASN1EncodableVector counterTree(ASN1Set signerInfosRaiz, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosRaiz.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosRaiz.getObjectAt(i));
            counterSigners.add(this.getCounterSignerInfo(si, parameters, key, certChain, contentType, contentDescription));
            ++i;
        }
        return counterSigners;
    }

    private ASN1EncodableVector counterLeaf(ASN1Set signerInfosRaiz, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosRaiz.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosRaiz.getObjectAt(i));
            counterSigners.add(this.getCounterLeafSignerInfo(si, parameters, key, certChain, contentType, contentDescription));
            ++i;
        }
        return counterSigners;
    }

    private ASN1EncodableVector counterNode(SignedAndEnvelopedData sd, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, int nodo) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1Set signerInfosRaiz = sd.getSignerInfos();
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        ASN1Set auxSignerRaiz = signerInfosRaiz;
        this.actualIndex = 0;
        int i = 0;
        while (i < auxSignerRaiz.size()) {
            ASN1Sequence atribute = (ASN1Sequence)auxSignerRaiz.getObjectAt(i);
            SignerInfo si = new SignerInfo(atribute);
            SignerInfo counterSigner = null;
            if (this.actualIndex == nodo) {
                counterSigner = this.getCounterNodeSignerInfo(si, parameters, key, certChain, contentType, contentDescription);
            } else if (this.actualIndex != nodo) {
                counterSigner = this.getCounterNodeSignerInfo(si, parameters, key, certChain, contentType, contentDescription, nodo);
            }
            ++this.actualIndex;
            counterSigners.add(counterSigner);
            ++i;
        }
        return counterSigners;
    }

    private SignerInfo getCounterSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        SignerInfo si = new SignerInfo((ASN1Sequence)eAtributesData.nextElement());
                        signerInfosU.add(this.getCounterSignerInfo(si, parameters, key, certChain, contentType, contentDescription));
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            counterSigner = this.generateSignerInfo(parameters, signerInfo, key, certChain, contentType, contentDescription);
            signerInfosU.add(counterSigner);
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(this.generateSignerInfo(parameters, signerInfo, key, certChain, contentType, contentDescription));
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2)));
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
            }
        } else {
            signerInfosU2.add(this.generateSignerInfo(parameters, signerInfo, key, certChain, contentType, contentDescription));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2))));
        }
        return counterSigner;
    }

    private SignerInfo getCounterLeafSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Enumeration eAttributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAttributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAttributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        SignerInfo si = new SignerInfo((ASN1Sequence)eAtributesData.nextElement());
                        signerInfosU.add(this.getCounterLeafSignerInfo(si, parameters, key, certChain, contentType, contentDescription));
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                ASN1Set a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU))));
            }
        } else {
            signerInfosU2.add(this.generateSignerInfo(parameters, signerInfo, key, certChain, contentType, contentDescription));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2))));
        }
        return counterSigner;
    }

    private SignerInfo getCounterNodeSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription) throws NoSuchAlgorithmException, IOException, CertificateException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Enumeration eAttributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAttributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAttributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        signerInfosU.add(new SignerInfo((ASN1Sequence)eAtributesData.nextElement()));
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            signerInfosU.add(this.generateSignerInfo(parameters, signerInfo, key, certChain, contentType, contentDescription));
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable(contexExpecific)));
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(this.generateSignerInfo(parameters, signerInfo, key, certChain, contentType, contentDescription));
                    Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
                    contexExpecific.add(uAtrib);
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable(contexExpecific)));
            } else {
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU))));
            }
        } else {
            signerInfosU2.add(this.generateSignerInfo(parameters, signerInfo, key, certChain, contentType, contentDescription));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2))));
        }
        return counterSigner;
    }

    private SignerInfo getCounterNodeSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, int node) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    Enumeration eAtributesData = data.getAttrValues().getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        ASN1Sequence atrib = (ASN1Sequence)eAtributesData.nextElement();
                        SignerInfo si = new SignerInfo(atrib);
                        ++this.actualIndex;
                        if (this.actualIndex != node) {
                            if (this.actualIndex < node) {
                                signerInfosU.add(this.getCounterNodeSignerInfo(si, parameters, key, certChain, contentType, contentDescription, node));
                                continue;
                            }
                            signerInfosU.add(si);
                            continue;
                        }
                        signerInfosU.add(this.getCounterNodeSignerInfo(si, parameters, key, certChain, contentType, contentDescription));
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable(contexExpecific)));
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), SigUtils.getAttributeSet(new AttributeTable(contexExpecific)));
            } else {
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU))));
            }
        } else {
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), null);
        }
        return counterSigner;
    }

    private SignerInfo generateSignerInfo(P7ContentSignerParameters parameters, SignerInfo si, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription) throws NoSuchAlgorithmException, IOException, CertificateException {
        ASN1OctetString sign2;
        String signatureAlgorithm = parameters.getSignatureAlgorithm();
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        ASN1EncodableVector contextExcepcific = CAdESUtils.generateSignerInfo((X509Certificate)certChain[0], digestAlgorithm, si.getEncryptedDigest().getOctets(), this.getGlobalPolicy(), this.isGlobalSigningCertificateV2(), null, new Date(), false, contentType, contentDescription);
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contextExcepcific));
        ASN1Set unsignedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExcepcific));
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certChain[0]).getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        try {
            sign2 = this.firma(signatureAlgorithm, key, certChain);
        }
        catch (AOException ex) {
            throw new IOException("Error al realizar la firma electronica: " + ex, ex);
        }
        return new SignerInfo(identifier, digAlgId, unsignedAttr, encAlgId, sign2, null);
    }

    private ASN1OctetString firma(String signatureAlgorithm, PrivateKey key, java.security.cert.Certificate[] certChain) throws AOException {
        byte[] tmp;
        try {
            tmp = this.signedAttr2.getEncoded("DER");
        }
        catch (Exception ex) {
            throw new AOException("Error obteniendo los atributos firmados: " + ex);
        }
        return new DEROctetString(new AOPkcs1Signer().sign(tmp, signatureAlgorithm, key, certChain, null));
    }
}

