/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

final class CAdESCounterSigner {
    private int actualIndex = 0;

    CAdESCounterSigner() {
    }

    byte[] counterSigner(P7ContentSignerParameters parameters, byte[] data, CounterSignTarget targetType, int[] targets, PrivateKey key, java.security.cert.Certificate[] certChain, AdESPolicy policy, boolean signingCertificateV2, String contentType, String contentDescription) throws IOException, NoSuchAlgorithmException, CertificateException, AOException {
        ASN1InputStream is = new ASN1InputStream(data);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedData sd = SignedData.getInstance(contentSignedData);
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1Set certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (certChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            java.security.cert.Certificate[] certificateArray = certChain;
            int n = certChain.length;
            int n2 = 0;
            while (n2 < n) {
                java.security.cert.Certificate element = certificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        ASN1Set certrevlist = null;
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        if (targetType.equals((Object)CounterSignTarget.TREE)) {
            signerInfos = this.counterTree(signerInfosSd, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2);
        } else if (targetType.equals((Object)CounterSignTarget.LEAFS)) {
            signerInfos = this.counterLeaf(signerInfosSd, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2);
        } else {
            if (targetType.equals((Object)CounterSignTarget.NODES)) {
                SignedData aux = sd;
                int nodo = 0;
                int i = targets.length - 1;
                while (i >= 0) {
                    nodo = targets[i];
                    signerInfos = this.counterNode(aux, parameters, key, certChain, contentType, contentDescription, nodo, policy, signingCertificateV2);
                    SignedData sigDat = new SignedData(sd.getDigestAlgorithms(), sd.getEncapContentInfo(), certificates, certrevlist, new DERSet(signerInfos));
                    ASN1InputStream sd2 = new ASN1InputStream(sigDat.getEncoded("DER"));
                    ASN1Sequence contentSignedData2 = (ASN1Sequence)sd2.readObject();
                    sd2.close();
                    aux = SignedData.getInstance(contentSignedData2);
                    --i;
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedData, aux).getEncoded("DER");
            }
            if (targetType.equals((Object)CounterSignTarget.SIGNERS)) {
                SignedData aux = sd;
                int nodo = 0;
                int i = targets.length - 1;
                while (i >= 0) {
                    nodo = targets[i];
                    signerInfos = this.counterNode(aux, parameters, key, certChain, contentType, contentDescription, nodo, policy, signingCertificateV2);
                    SignedData sigDat = new SignedData(sd.getDigestAlgorithms(), sd.getEncapContentInfo(), certificates, certrevlist, new DERSet(signerInfos));
                    ASN1InputStream sd2 = new ASN1InputStream(sigDat.getEncoded("DER"));
                    ASN1Sequence contentSignedData2 = (ASN1Sequence)sd2.readObject();
                    sd2.close();
                    aux = SignedData.getInstance(contentSignedData2);
                    --i;
                }
                return new ContentInfo(PKCSObjectIdentifiers.signedData, aux).getEncoded("DER");
            }
        }
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(sd.getDigestAlgorithms(), sd.getEncapContentInfo(), certificates, certrevlist, new DERSet(signerInfos))).getEncoded("DER");
    }

    private ASN1EncodableVector counterTree(ASN1Set signerInfosRaiz, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosRaiz.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosRaiz.getObjectAt(i));
            counterSigners.add(this.getCounterSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
            ++i;
        }
        return counterSigners;
    }

    private ASN1EncodableVector counterLeaf(ASN1Set signerInfosRaiz, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosRaiz.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosRaiz.getObjectAt(i));
            counterSigners.add(this.getLeafSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
            ++i;
        }
        return counterSigners;
    }

    private ASN1EncodableVector counterNode(SignedData sd, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, int nodo, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1Set signerInfosRaiz = sd.getSignerInfos();
        ASN1EncodableVector counterSigners = new ASN1EncodableVector();
        ASN1Set auxSignerRaiz = signerInfosRaiz;
        this.actualIndex = 0;
        int i = 0;
        while (i < auxSignerRaiz.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)auxSignerRaiz.getObjectAt(i));
            SignerInfo counterSigner = null;
            if (this.actualIndex == nodo) {
                counterSigner = CAdESCounterSigner.getNodeSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2);
            } else if (this.actualIndex != nodo) {
                counterSigner = this.getNodeSignerInfo(si, parameters, key, certChain, contentType, contentDescription, nodo, policy, signingCertificateV2);
            }
            ++this.actualIndex;
            counterSigners.add(counterSigner);
            ++i;
        }
        return counterSigners;
    }

    private SignerInfo getCounterSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Attribute uAtrib;
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        SignerInfo si = new SignerInfo((ASN1Sequence)eAtributesData.nextElement());
                        signerInfosU.add(this.getCounterSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            counterSigner = CAdESCounterSigner.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, key, certChain, contentType, contentDescription, policy, signingCertificateV2);
            signerInfosU.add(counterSigner);
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(CAdESCounterSigner.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
                    uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
                    contexExpecific.add(uAtrib);
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
            }
        } else {
            signerInfosU2.add(CAdESCounterSigner.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
            Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
        }
        return counterSigner;
    }

    private SignerInfo getLeafSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Attribute uAtrib;
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        SignerInfo si = new SignerInfo((ASN1Sequence)eAtributesData.nextElement());
                        signerInfosU.add(this.getLeafSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(CAdESCounterSigner.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
                    uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
                    contexExpecific.add(uAtrib);
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
            }
        } else {
            signerInfosU2.add(CAdESCounterSigner.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
            Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
        }
        return counterSigner;
    }

    private static SignerInfo getNodeSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        ASN1EncodableVector signerInfosU2 = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            Attribute uAtrib;
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        signerInfosU.add(new SignerInfo((ASN1Sequence)eAtributesData.nextElement()));
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            signerInfosU.add(CAdESCounterSigner.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                    signerInfosU2.add(CAdESCounterSigner.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
                    uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
                    contexExpecific.add(uAtrib);
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
            }
        } else {
            signerInfosU2.add(CAdESCounterSigner.generateSignerInfo(parameters.getSignatureAlgorithm(), signerInfo, key, certChain, contentType, contentDescription, policy, signingCertificateV2));
            Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU2));
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
        }
        return counterSigner;
    }

    private SignerInfo getNodeSignerInfo(SignerInfo signerInfo, P7ContentSignerParameters parameters, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, int node, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException, AOException {
        ASN1EncodableVector signerInfosU = new ASN1EncodableVector();
        SignerInfo counterSigner = null;
        if (signerInfo.getUnauthenticatedAttributes() != null) {
            ASN1Set a1;
            Enumeration eAtributes = signerInfo.getUnauthenticatedAttributes().getObjects();
            while (eAtributes.hasMoreElements()) {
                Attribute data = Attribute.getInstance(eAtributes.nextElement());
                if (!data.getAttrType().equals(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) {
                    ASN1Set setInto = data.getAttrValues();
                    Enumeration eAtributesData = setInto.getObjects();
                    while (eAtributesData.hasMoreElements()) {
                        SignerInfo si = new SignerInfo((ASN1Sequence)eAtributesData.nextElement());
                        ++this.actualIndex;
                        if (this.actualIndex != node) {
                            if (this.actualIndex < node) {
                                signerInfosU.add(this.getNodeSignerInfo(si, parameters, key, certChain, contentType, contentDescription, node, policy, signingCertificateV2));
                                continue;
                            }
                            signerInfosU.add(si);
                            continue;
                        }
                        SignerInfo obtained = CAdESCounterSigner.getNodeSignerInfo(si, parameters, key, certChain, contentType, contentDescription, policy, signingCertificateV2);
                        signerInfosU.add(obtained);
                    }
                    continue;
                }
                signerInfosU.add(data);
            }
            ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
            if (signerInfosU.size() > 1) {
                int i = 0;
                while (i < signerInfosU.size()) {
                    if (signerInfosU.get(i) instanceof Attribute) {
                        contexExpecific.add(signerInfosU.get(i));
                    } else {
                        contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(i))));
                    }
                    ++i;
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else if (signerInfosU.size() == 1) {
                if (signerInfosU.get(0) instanceof Attribute) {
                    contexExpecific.add(signerInfosU.get(0));
                } else {
                    contexExpecific.add(new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU.get(0))));
                }
                a1 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), a1);
            } else {
                Attribute uAtrib = new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(signerInfosU));
                counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(uAtrib));
            }
        } else {
            counterSigner = new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), null);
        }
        return counterSigner;
    }

    private static SignerInfo generateSignerInfo(String signatureAlgorithm, SignerInfo si, PrivateKey key, java.security.cert.Certificate[] certChain, String contentType, String contentDescription, AdESPolicy policy, boolean signingCertificateV2) throws NoSuchAlgorithmException, IOException, CertificateException {
        DEROctetString sign2;
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        ASN1EncodableVector contextExcepcific = CAdESUtils.generateSignerInfo((X509Certificate)certChain[0], digestAlgorithm, si.getEncryptedDigest().getOctets(), policy, signingCertificateV2, null, new Date(), false, contentType, contentDescription);
        ASN1Set signedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExcepcific));
        try {
            sign2 = new DEROctetString(CAdESCounterSigner.firma(signedAttr.getEncoded("DER"), signatureAlgorithm, key, certChain));
        }
        catch (AOException ex) {
            throw new IOException("Error al realizar la firma: " + ex, ex);
        }
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certChain[0]).getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        ASN1Set unsignedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExcepcific));
        return new SignerInfo(identifier, digAlgId, unsignedAttr, encAlgId, sign2, null);
    }

    private static byte[] firma(byte[] data, String signatureAlgorithm, PrivateKey key, java.security.cert.Certificate[] certChain) throws AOException {
        System.out.println(AOUtil.hexify(new byte[]{(byte)Integer.toString(0).toCharArray()[0]}, false));
        return new AOPkcs1Signer().sign(data, signatureAlgorithm, key, certChain, null);
    }
}

