/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import es.gob.afirma.signers.pkcs7.SignedAndEnvelopedData;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

final class CAdESCoSignerEnveloped {
    private ASN1Set signedAttr2;

    CAdESCoSignerEnveloped() {
    }

    byte[] coSigner(P7ContentSignerParameters parameters, byte[] sign, AdESPolicy policy, boolean signingCertificateV2, PrivateKey key, java.security.cert.Certificate[] certChain, byte[] messageDigest, String contentType, String contentDescription) throws IOException, NoSuchAlgorithmException, CertificateException {
        ASN1OctetString sign2;
        ASN1EncodableVector contextExpecific;
        ASN1InputStream is = new ASN1InputStream(sign);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedAndEnvelopedData sd = new SignedAndEnvelopedData(contentSignedData);
        ASN1Set certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (certChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            java.security.cert.Certificate[] certificateArray = certChain;
            int n = certChain.length;
            int n2 = 0;
            while (n2 < n) {
                java.security.cert.Certificate element = certificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        String signatureAlgorithm = parameters.getSignatureAlgorithm();
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certChain[0]).getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        ASN1Set signedAttr = null;
        if (messageDigest == null) {
            contextExpecific = CAdESUtils.generateSignerInfo((X509Certificate)certChain[0], digestAlgorithm, parameters.getContent(), policy, signingCertificateV2, null, new Date(), false, contentType, contentDescription);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
            signedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
        } else {
            contextExpecific = CAdESUtils.generateSignerInfo((X509Certificate)certChain[0], digestAlgorithm, null, policy, signingCertificateV2, messageDigest, new Date(), false, contentType, contentDescription);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
            signedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
        }
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosSd.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i));
            signerInfos.add(si);
            ++i;
        }
        try {
            sign2 = this.firma(signatureAlgorithm, key, certChain);
        }
        catch (AOException ex) {
            throw new IOException("Error al realizar la firma: " + ex, ex);
        }
        signerInfos.add(new SignerInfo(identifier, digAlgId, signedAttr, encAlgId, sign2, null));
        return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, new SignedAndEnvelopedData(sd.getRecipientInfos(), sd.getDigestAlgorithms(), sd.getEncryptedContentInfo(), certificates, null, new DERSet(signerInfos))).getEncoded("DER");
    }

    byte[] coSigner(String signatureAlgorithm, X509Certificate[] signerCertificateChain, InputStream data, AdESPolicy policy, boolean signingCertificateV2, PrivateKey key, java.security.cert.Certificate[] certChain, byte[] md, String contentType, String contentDescription) throws IOException, NoSuchAlgorithmException, CertificateException {
        ASN1OctetString sign2;
        ASN1InputStream is = new ASN1InputStream(data);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedAndEnvelopedData sd = new SignedAndEnvelopedData(contentSignedData);
        ASN1Set certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (signerCertificateChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            X509Certificate[] x509CertificateArray = signerCertificateChain;
            int n = signerCertificateChain.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate element = x509CertificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(signerCertificateChain[0].getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        byte[] messageDigest = md != null ? (byte[])md.clone() : null;
        int i = 0;
        while (i < signerInfosSd.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i));
            AlgorithmIdentifier algHash = si.getDigestAlgorithm();
            if (algHash.getAlgorithm().toString().equals(AOAlgorithmID.getOID(digestAlgorithm))) {
                ASN1Set signedAttrib = si.getAuthenticatedAttributes();
                int s = 0;
                while (s < signedAttrib.size()) {
                    ASN1Sequence elemento = (ASN1Sequence)signedAttrib.getObjectAt(s);
                    DERObjectIdentifier oids = (DERObjectIdentifier)elemento.getObjectAt(0);
                    if (CMSAttributes.messageDigest.getId().toString().equals(oids.toString())) {
                        DERSet derSetHash = (DERSet)elemento.getObjectAt(1);
                        DEROctetString derHash = (DEROctetString)derSetHash.getObjectAt(0);
                        messageDigest = derHash.getOctets();
                    }
                    ++s;
                }
            }
            signerInfos.add(si);
            ++i;
        }
        ASN1Set signedAttr = null;
        if (messageDigest == null) {
            throw new IllegalStateException("No se puede crear la firma ya que no se ha encontrado un message digest valido");
        }
        ASN1EncodableVector contextExpecific = CAdESUtils.generateSignerInfo(signerCertificateChain[0], digestAlgorithm, null, policy, signingCertificateV2, messageDigest, new Date(), false, contentType, contentDescription);
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
        signedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
        try {
            sign2 = this.firma(signatureAlgorithm, key, certChain);
        }
        catch (AOException ex) {
            throw new IOException("Error al realizar la firma: " + ex, ex);
        }
        signerInfos.add(new SignerInfo(identifier, digAlgId, signedAttr, encAlgId, sign2, null));
        return new ContentInfo(PKCSObjectIdentifiers.signedAndEnvelopedData, new SignedAndEnvelopedData(sd.getRecipientInfos(), sd.getDigestAlgorithms(), sd.getEncryptedContentInfo(), certificates, null, new DERSet(signerInfos))).getEncoded("DER");
    }

    private ASN1OctetString firma(String signatureAlgorithm, PrivateKey key, java.security.cert.Certificate[] certChain) throws AOException {
        byte[] tmp;
        try {
            tmp = this.signedAttr2.getEncoded("DER");
        }
        catch (IOException ex) {
            throw new AOException("Error al obtener los datos a firmar", ex);
        }
        return new DEROctetString(new AOPkcs1Signer().sign(tmp, signatureAlgorithm, key, certChain, null));
    }
}

