/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.ContainsNoDataException;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;

final class CAdESCoSigner {
    private ASN1Set signedAttr2;

    CAdESCoSigner() {
    }

    byte[] coSigner(P7ContentSignerParameters parameters, byte[] signature, boolean omitContent, AdESPolicy policy, boolean signingCertificateV2, PrivateKey key, java.security.cert.Certificate[] certChain, byte[] messageDigest, String contentType, String contentDescription) throws IOException, NoSuchAlgorithmException, CertificateException {
        ASN1OctetString sign2;
        ASN1EncodableVector contextExpecific;
        ASN1InputStream is = new ASN1InputStream(signature);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedData sd = SignedData.getInstance(contentSignedData);
        ContentInfo encInfo = null;
        ASN1ObjectIdentifier contentTypeOID = new ASN1ObjectIdentifier(PKCSObjectIdentifiers.data.getId());
        byte[] content2 = null;
        if (!omitContent) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            content2 = parameters.getContent();
            CMSProcessableByteArray msg = new CMSProcessableByteArray(content2);
            try {
                msg.write(bOut);
            }
            catch (CMSException ex) {
                throw new IOException("Error en la escritura del procesable CMS: " + ex, ex);
            }
            encInfo = new ContentInfo(contentTypeOID, new BEROctetString(bOut.toByteArray()));
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        ASN1Set certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (certChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            java.security.cert.Certificate[] certificateArray = certChain;
            int n = certChain.length;
            int n2 = 0;
            while (n2 < n) {
                java.security.cert.Certificate element = certificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        String signatureAlgorithm = parameters.getSignatureAlgorithm();
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(AOSignConstants.getDigestAlgorithmName(signatureAlgorithm)));
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certChain[0]).getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        ASN1Set signedAttr = null;
        if (messageDigest == null) {
            contextExpecific = CAdESUtils.generateSignerInfo((X509Certificate)certChain[0], digestAlgorithm, content2 != null ? content2 : parameters.getContent(), policy, signingCertificateV2, null, new Date(), false, contentType, contentDescription);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
            signedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
        } else {
            contextExpecific = CAdESUtils.generateSignerInfo((X509Certificate)certChain[0], digestAlgorithm, null, policy, signingCertificateV2, messageDigest, new Date(), false, contentType, contentDescription);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
            signedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
        }
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        int i = 0;
        while (i < signerInfosSd.size()) {
            signerInfos.add(new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i)));
            ++i;
        }
        try {
            sign2 = this.firma(signatureAlgorithm, key, certChain);
        }
        catch (AOException ex) {
            throw new IOException("Error al realizar la firma: " + ex, ex);
        }
        signerInfos.add(new SignerInfo(identifier, digAlgId, signedAttr, encAlgId, sign2, null));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(sd.getDigestAlgorithms(), encInfo, certificates, null, new DERSet(signerInfos))).getEncoded("DER");
    }

    byte[] coSigner(String signatureAlgorithm, X509Certificate[] signerCertificateChain, InputStream signature, AdESPolicy policy, boolean signingCertificateV2, PrivateKey key, java.security.cert.Certificate[] certChain, byte[] md, String contentType, String contentDescription) throws IOException, NoSuchAlgorithmException, CertificateException, ContainsNoDataException {
        ASN1OctetString sign2;
        ASN1Set signedAttr;
        ASN1EncodableVector contextExpecific;
        ASN1InputStream is = new ASN1InputStream(signature);
        ASN1Sequence dsq = (ASN1Sequence)is.readObject();
        is.close();
        Enumeration e = dsq.getObjects();
        e.nextElement();
        ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
        ASN1Sequence contentSignedData = (ASN1Sequence)doj.getObject();
        SignedData sd = SignedData.getInstance(contentSignedData);
        ContentInfo encInfo = sd.getEncapContentInfo();
        DEROctetString contenido = (DEROctetString)encInfo.getContent();
        byte[] contenidoDatos = null;
        if (contenido != null) {
            contenidoDatos = AOUtil.getDataFromInputStream(contenido.getOctetStream());
        }
        ASN1Set certificates = null;
        ASN1Set certificatesSigned = sd.getCertificates();
        ASN1EncodableVector vCertsSig = new ASN1EncodableVector();
        Enumeration certs = certificatesSigned.getObjects();
        while (certs.hasMoreElements()) {
            vCertsSig.add((ASN1Encodable)certs.nextElement());
        }
        if (signerCertificateChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            X509Certificate[] x509CertificateArray = signerCertificateChain;
            int n = signerCertificateChain.length;
            int n2 = 0;
            while (n2 < n) {
                X509Certificate element = x509CertificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.fillRestCerts(ce, vCertsSig);
        }
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(signerCertificateChain[0].getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        AlgorithmIdentifier encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        ASN1Set signerInfosSd = sd.getSignerInfos();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        byte[] messageDigest = md != null ? (byte[])md.clone() : null;
        int i = 0;
        while (i < signerInfosSd.size()) {
            SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i));
            AlgorithmIdentifier algHash = si.getDigestAlgorithm();
            if (algHash.getAlgorithm().toString().equals(AOAlgorithmID.getOID(digestAlgorithm))) {
                ASN1Set signedAttrib = si.getAuthenticatedAttributes();
                int s = 0;
                while (s < signedAttrib.size()) {
                    ASN1Sequence elemento = (ASN1Sequence)signedAttrib.getObjectAt(s);
                    DERObjectIdentifier oids = (DERObjectIdentifier)elemento.getObjectAt(0);
                    if (CMSAttributes.messageDigest.getId().equals(oids.toString())) {
                        DERSet derSetHash = (DERSet)elemento.getObjectAt(1);
                        DEROctetString derHash = (DEROctetString)derSetHash.getObjectAt(0);
                        messageDigest = derHash.getOctets();
                    }
                    ++s;
                }
            }
            signerInfos.add(si);
            ++i;
        }
        if (contenidoDatos != null) {
            contextExpecific = CAdESUtils.generateSignerInfo(signerCertificateChain[0], digestAlgorithm, contenidoDatos, policy, signingCertificateV2, null, new Date(), false, contentType, contentDescription);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
            signedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
        } else if (messageDigest != null) {
            contextExpecific = CAdESUtils.generateSignerInfo(signerCertificateChain[0], digestAlgorithm, null, policy, signingCertificateV2, messageDigest, new Date(), false, contentType, contentDescription);
            this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
            signedAttr = SigUtils.getAttributeSet(new AttributeTable(contextExpecific));
        } else {
            throw new ContainsNoDataException("No se puede crear la cofirma ya que no se han encontrado ni los datos firmados ni una huella digital compatible con el algoritmo de firma");
        }
        try {
            sign2 = this.firma(signatureAlgorithm, key, certChain);
        }
        catch (AOException ex) {
            throw new IOException("Error al realizar la firma: " + ex, ex);
        }
        signerInfos.add(new SignerInfo(identifier, digAlgId, signedAttr, encAlgId, sign2, null));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(sd.getDigestAlgorithms(), encInfo, certificates, null, new DERSet(signerInfos))).getEncoded("DER");
    }

    private ASN1OctetString firma(String signatureAlgorithm, PrivateKey key, java.security.cert.Certificate[] certChain) throws AOException {
        byte[] tmp;
        try {
            tmp = this.signedAttr2.getEncoded("DER");
        }
        catch (IOException ex) {
            throw new AOException("Error al obtener los datos a firmar", ex);
        }
        return new DEROctetString(new AOPkcs1Signer().sign(tmp, signatureAlgorithm, key, certChain, null));
    }
}

