/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOCounterSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.cades.CAdESValidator;
import es.gob.afirma.signers.multi.cades.CAdESCounterSigner;
import es.gob.afirma.signers.multi.cades.CAdESCounterSignerEnveloped;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.ReadNodesTree;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Properties;

public class AOCAdESCounterSigner
implements AOCounterSigner {
    @Override
    public byte[] countersign(byte[] sign, String algorithm, CounterSignTarget targetType, Object[] targets, PrivateKey key, Certificate[] certChain, Properties xParams) throws AOException, IOException {
        Properties extraParams;
        Properties properties = extraParams = xParams != null ? xParams : new Properties();
        boolean signingCertificateV2 = AOSignConstants.isSHA2SignatureAlgorithm(algorithm) ? true : (extraParams.containsKey("signingCertificateV2") ? Boolean.parseBoolean(extraParams.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(algorithm)));
        P7ContentSignerParameters csp = new P7ContentSignerParameters(sign, algorithm);
        String contentTypeOid = "1.2.840.113549.1.7.1";
        String contentDescription = "binary";
        byte[] data = new AOCAdESSigner().getData(sign);
        if (data != null) {
            MimeHelper mimeHelper = new MimeHelper(data);
            contentDescription = mimeHelper.getDescription();
            contentTypeOid = MimeHelper.transformMimeTypeToOid(mimeHelper.getMimeType());
        }
        byte[] dataSigned = null;
        if (CAdESValidator.isCAdESSignedData(sign)) {
            try {
                if (targetType == CounterSignTarget.TREE) {
                    int[] nodes = new int[1];
                    dataSigned = new CAdESCounterSigner().counterSigner(csp, sign, CounterSignTarget.TREE, nodes, key, certChain, new AdESPolicy(extraParams), signingCertificateV2, contentTypeOid, contentDescription);
                } else if (targetType == CounterSignTarget.LEAFS) {
                    int[] nodes = new int[1];
                    dataSigned = new CAdESCounterSigner().counterSigner(csp, sign, CounterSignTarget.LEAFS, nodes, key, certChain, new AdESPolicy(extraParams), signingCertificateV2, contentTypeOid, contentDescription);
                } else if (targetType == CounterSignTarget.NODES) {
                    int[] nodesID = new int[targets.length];
                    int i = 0;
                    while (i < targets.length) {
                        nodesID[i] = (Integer)targets[i];
                        ++i;
                    }
                    nodesID = ReadNodesTree.simplyArray(nodesID);
                    dataSigned = new CAdESCounterSigner().counterSigner(csp, sign, CounterSignTarget.NODES, nodesID, key, certChain, new AdESPolicy(extraParams), signingCertificateV2, contentTypeOid, contentDescription);
                } else if (targetType == CounterSignTarget.SIGNERS) {
                    String[] signers = new String[targets.length];
                    int i = 0;
                    while (i < targets.length) {
                        signers[i] = (String)targets[i];
                        ++i;
                    }
                    int[] nodes2 = new ReadNodesTree().readNodesFromSigners(signers, sign);
                    dataSigned = new CAdESCounterSigner().counterSigner(csp, sign, CounterSignTarget.SIGNERS, nodes2, key, certChain, new AdESPolicy(extraParams), signingCertificateV2, contentTypeOid, contentDescription);
                }
                return dataSigned;
            }
            catch (Exception e) {
                throw new AOException("Error generando la Contrafirma CAdES", e);
            }
        }
        try {
            if (targetType == CounterSignTarget.TREE) {
                int[] nodes = new int[1];
                dataSigned = new CAdESCounterSignerEnveloped().counterSigner(csp, sign, CounterSignTarget.TREE, nodes, key, certChain, new AdESPolicy(extraParams), signingCertificateV2, contentTypeOid, contentDescription);
            } else if (targetType == CounterSignTarget.LEAFS) {
                int[] nodes = new int[1];
                dataSigned = new CAdESCounterSignerEnveloped().counterSigner(csp, sign, CounterSignTarget.LEAFS, nodes, key, certChain, new AdESPolicy(extraParams), signingCertificateV2, contentTypeOid, contentDescription);
            } else if (targetType == CounterSignTarget.NODES) {
                int[] nodesID = new int[targets.length];
                int i = 0;
                while (i < targets.length) {
                    nodesID[i] = (Integer)targets[i];
                    ++i;
                }
                nodesID = ReadNodesTree.simplyArray(nodesID);
                dataSigned = new CAdESCounterSignerEnveloped().counterSigner(csp, sign, CounterSignTarget.NODES, nodesID, key, certChain, new AdESPolicy(extraParams), signingCertificateV2, contentTypeOid, contentDescription);
            } else if (targetType == CounterSignTarget.SIGNERS) {
                String[] signers = new String[targets.length];
                int i = 0;
                while (i < targets.length) {
                    signers[i] = (String)targets[i];
                    ++i;
                }
                int[] nodes2 = new ReadNodesTree().readNodesFromSigners(signers, sign);
                dataSigned = new CAdESCounterSignerEnveloped().counterSigner(csp, sign, CounterSignTarget.SIGNERS, nodes2, key, certChain, new AdESPolicy(extraParams), signingCertificateV2, contentTypeOid, contentDescription);
            }
            return dataSigned;
        }
        catch (Exception e) {
            throw new AOException("Error generando la Contrafirma CAdES", e);
        }
    }
}

