/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.MimeHelper;
import es.gob.afirma.core.signers.AOCoSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.signers.cades.AOCAdESSigner;
import es.gob.afirma.signers.cades.CAdESValidator;
import es.gob.afirma.signers.multi.cades.CAdESCoSigner;
import es.gob.afirma.signers.multi.cades.CAdESCoSignerEnveloped;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Logger;

public class AOCAdESCoSigner
implements AOCoSigner {
    @Override
    public byte[] cosign(byte[] data, byte[] sign, String algorithm, PrivateKey key, Certificate[] certChain, Properties xParams) throws AOException {
        Properties extraParams = xParams != null ? xParams : new Properties();
        byte[] messageDigest = null;
        String precalculatedDigest = extraParams.getProperty("precalculatedHashAlgorithm");
        if (precalculatedDigest != null) {
            messageDigest = data;
        }
        boolean signingCertificateV2 = AOSignConstants.isSHA2SignatureAlgorithm(algorithm) ? true : (extraParams.containsKey("signingCertificateV2") ? Boolean.parseBoolean(extraParams.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(algorithm)));
        P7ContentSignerParameters csp = new P7ContentSignerParameters(data, algorithm);
        String contentTypeOid = "1.2.840.113549.1.7.1";
        String contentDescription = "binary";
        if (data != null) {
            try {
                MimeHelper mimeHelper = new MimeHelper(data);
                contentDescription = mimeHelper.getDescription();
                contentTypeOid = MimeHelper.transformMimeTypeToOid(mimeHelper.getMimeType());
            }
            catch (Exception e) {
                Logger.getLogger("es.gob.afirma").warning("No se han podido cargar las librerias para identificar el tipo de dato firmado: " + e);
            }
        }
        try {
            boolean signedData = CAdESValidator.isCAdESSignedData(sign);
            if (signedData) {
                String mode = extraParams.getProperty("mode", "explicit");
                boolean omitContent = mode.equals("explicit") || precalculatedDigest != null;
                return new CAdESCoSigner().coSigner(csp, sign, omitContent, new AdESPolicy(extraParams), signingCertificateV2, key, certChain, messageDigest, contentTypeOid, contentDescription);
            }
            return new CAdESCoSignerEnveloped().coSigner(csp, sign, new AdESPolicy(extraParams), signingCertificateV2, key, certChain, messageDigest, contentTypeOid, contentDescription);
        }
        catch (Exception e) {
            throw new AOException("Error generando la Cofirma CAdES", e);
        }
    }

    @Override
    public byte[] cosign(byte[] sign, String algorithm, PrivateKey key, Certificate[] certChain, Properties xParams) throws AOException, IOException {
        Properties extraParams;
        Properties properties = extraParams = xParams != null ? xParams : new Properties();
        boolean signingCertificateV2 = AOSignConstants.isSHA2SignatureAlgorithm(algorithm) ? true : (extraParams.containsKey("signingCertificateV2") ? Boolean.parseBoolean(extraParams.getProperty("signingCertificateV2")) : !"SHA1".equals(AOSignConstants.getDigestAlgorithmName(algorithm)));
        String typeAlgorithm = algorithm;
        String contentTypeOid = "1.2.840.113549.1.7.1";
        String contentDescription = "binary";
        byte[] data = new AOCAdESSigner().getData(sign);
        if (data != null) {
            MimeHelper mimeHelper = new MimeHelper(data);
            contentDescription = mimeHelper.getDescription();
            contentTypeOid = MimeHelper.transformMimeTypeToOid(mimeHelper.getMimeType());
        }
        if (CAdESValidator.isCAdESSignedData(sign)) {
            try {
                X509Certificate[] x509CertificateArray;
                CAdESCoSigner cAdESCoSigner = new CAdESCoSigner();
                if (Boolean.parseBoolean(extraParams.getProperty("includeOnlySignningCertificate"))) {
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
                    x509CertificateArray = x509CertificateArray2;
                    x509CertificateArray2[0] = (X509Certificate)certChain[0];
                } else {
                    x509CertificateArray = (X509Certificate[])certChain;
                }
                return cAdESCoSigner.coSigner(typeAlgorithm, x509CertificateArray, new ByteArrayInputStream(sign), new AdESPolicy(extraParams), signingCertificateV2, key, certChain, null, contentTypeOid, contentDescription);
            }
            catch (Exception e) {
                throw new AOException("Error generando la Cofirma CADES", e);
            }
        }
        try {
            X509Certificate[] x509CertificateArray;
            CAdESCoSignerEnveloped cAdESCoSignerEnveloped = new CAdESCoSignerEnveloped();
            if (Boolean.parseBoolean(extraParams.getProperty("includeOnlySignningCertificate"))) {
                X509Certificate[] x509CertificateArray3 = new X509Certificate[1];
                x509CertificateArray = x509CertificateArray3;
                x509CertificateArray3[0] = (X509Certificate)certChain[0];
            } else {
                x509CertificateArray = (X509Certificate[])certChain;
            }
            return cAdESCoSignerEnveloped.coSigner(typeAlgorithm, x509CertificateArray, new ByteArrayInputStream(sign), new AdESPolicy(extraParams), signingCertificateV2, key, certChain, null, contentTypeOid, contentDescription);
        }
        catch (Exception e) {
            throw new AOException("Error generando la Cofirma CADES", e);
        }
    }
}

