/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.signers.pkcs7.BCChecker;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

final class ValidateCMSSignedData {
    private ValidateCMSSignedData() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCMSSignedData(byte[] data) throws IOException {
        new BCChecker().checkBouncyCastle();
        boolean isValid = true;
        ASN1InputStream is = null;
        try {
            try {
                is = new ASN1InputStream(data);
                ASN1Sequence dsq = (ASN1Sequence)is.readObject();
                Enumeration e = dsq.getObjects();
                DERObjectIdentifier doi = (DERObjectIdentifier)e.nextElement();
                if (!doi.equals(PKCSObjectIdentifiers.signedData)) {
                    isValid = false;
                    return isValid;
                }
                ASN1TaggedObject doj = (ASN1TaggedObject)e.nextElement();
                ASN1Sequence datos = (ASN1Sequence)doj.getObject();
                SignedData sd = SignedData.getInstance(datos);
                ASN1Set signerInfosSd = sd.getSignerInfos();
                int i = 0;
                while (isValid) {
                    if (i >= signerInfosSd.size()) {
                        return isValid;
                    }
                    SignerInfo si = new SignerInfo((ASN1Sequence)signerInfosSd.getObjectAt(i));
                    isValid = ValidateCMSSignedData.verifySignerInfo(si);
                    ++i;
                }
                return isValid;
            }
            catch (Exception ex) {
                isValid = false;
                if (is == null) return isValid;
                is.close();
                return isValid;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static boolean verifySignerInfo(SignerInfo si) {
        boolean isSignerValid = true;
        ASN1Set attrib = si.getAuthenticatedAttributes();
        Enumeration e = attrib.getObjects();
        while (isSignerValid && e.hasMoreElements()) {
            Attribute atribute = Attribute.getInstance(e.nextElement());
            if (!atribute.getAttrType().equals(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId)) continue;
            isSignerValid = false;
            Logger.getLogger("es.gob.afirma").warning("El signerInfo no es del tipo CMS, es del tipo CADES");
        }
        return isSignerValid;
    }
}

