/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.cms;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.P7ContentSignerParameters;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSProcessableByteArray;

final class GenSignedData {
    private ASN1Set signedAttr2;

    GenSignedData() {
    }

    byte[] generateSignedData(P7ContentSignerParameters parameters, boolean omitContent, boolean applyTimestamp, String dataType, PrivateKey key, java.security.cert.Certificate[] certChain, Map<String, byte[]> atrib, Map<String, byte[]> uatrib, byte[] messageDigest) throws NoSuchAlgorithmException, CertificateException, IOException, AOException {
        AlgorithmIdentifier encAlgId;
        ContentInfo encInfo;
        if (parameters == null) {
            throw new IllegalArgumentException("Los parametros no pueden ser nulos");
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        String signatureAlgorithm = parameters.getSignatureAlgorithm();
        String digestAlgorithm = AOSignConstants.getDigestAlgorithmName(signatureAlgorithm);
        AlgorithmIdentifier digAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID(digestAlgorithm));
        digestAlgs.add(digAlgId);
        ASN1ObjectIdentifier contentTypeOID = new ASN1ObjectIdentifier(dataType);
        byte[] content2 = null;
        if (!omitContent) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            content2 = parameters.getContent();
            CMSProcessableByteArray msg = new CMSProcessableByteArray(content2);
            try {
                msg.write(bOut);
            }
            catch (Exception ex) {
                throw new IOException("Error en la escritura del procesable CMS: " + ex, ex);
            }
            encInfo = new ContentInfo(contentTypeOID, new BEROctetString(bOut.toByteArray()));
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        ASN1Set certificates = null;
        if (certChain.length != 0) {
            ArrayList<ASN1Encodable> ce = new ArrayList<ASN1Encodable>();
            java.security.cert.Certificate[] certificateArray = certChain;
            int n = certChain.length;
            int n2 = 0;
            while (n2 < n) {
                java.security.cert.Certificate element = certificateArray[n2];
                ce.add(Certificate.getInstance(ASN1Primitive.fromByteArray(element.getEncoded())));
                ++n2;
            }
            certificates = SigUtils.createBerSetFromList(ce);
        }
        ASN1Set certrevlist = null;
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(((X509Certificate)certChain[0]).getTBSCertificate()));
        IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(X500Name.getInstance(tbs.getIssuer()), tbs.getSerialNumber().getValue());
        SignerIdentifier identifier = new SignerIdentifier(encSid);
        ASN1Set signedAttr = this.generateSignedInfo(digestAlgorithm, content2 != null ? content2 : parameters.getContent(), dataType, applyTimestamp, atrib, messageDigest);
        ASN1Set unSignedAttr = GenSignedData.generateUnsignedInfo(uatrib);
        try {
            encAlgId = SigUtils.makeAlgId(AOAlgorithmID.getOID("RSA"));
        }
        catch (Exception e) {
            throw new IOException("Error de codificacion: " + e, e);
        }
        ASN1OctetString sign2 = this.firma(signatureAlgorithm, key);
        signerInfos.add(new SignerInfo(identifier, digAlgId, signedAttr, encAlgId, sign2, unSignedAttr));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos))).getEncoded("DER");
    }

    private ASN1Set generateSignedInfo(String digestAlgorithm, byte[] datos, String dataType, boolean timestamp, Map<String, byte[]> atrib, byte[] messageDigest) throws NoSuchAlgorithmException {
        ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
        contexExpecific.add(new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet(new DERObjectIdentifier(dataType))));
        if (timestamp) {
            contexExpecific.add(new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet(new DERUTCTime(new Date()))));
        }
        byte[] md = messageDigest == null || messageDigest.length < 1 ? MessageDigest.getInstance(AOSignConstants.getDigestAlgorithmName(digestAlgorithm)).digest(datos) : messageDigest;
        contexExpecific.add(new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet(new DEROctetString((byte[])md.clone()))));
        if (atrib.size() != 0) {
            for (Map.Entry<String, byte[]> e : atrib.entrySet()) {
                contexExpecific.add(new Attribute(new ASN1ObjectIdentifier(e.getKey()), (ASN1Set)new DERSet(new DERPrintableString(new String(e.getValue())))));
            }
        }
        this.signedAttr2 = SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
        return SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
    }

    private static ASN1Set generateUnsignedInfo(Map<String, byte[]> uatrib) {
        ASN1EncodableVector contexExpecific = new ASN1EncodableVector();
        if (uatrib.size() != 0) {
            for (Map.Entry<String, byte[]> e : uatrib.entrySet()) {
                contexExpecific.add(new Attribute(new ASN1ObjectIdentifier(e.getKey().toString()), (ASN1Set)new DERSet(new DERPrintableString(new String(e.getValue())))));
            }
        } else {
            return null;
        }
        return SigUtils.getAttributeSet(new AttributeTable(contexExpecific));
    }

    private ASN1OctetString firma(String signatureAlgorithm, PrivateKey key) throws AOException {
        byte[] realSig;
        Signature sig;
        try {
            sig = Signature.getInstance(signatureAlgorithm);
        }
        catch (Exception e) {
            throw new AOException("Error obteniendo la clase de firma para el algoritmo " + signatureAlgorithm, e);
        }
        try {
            sig.initSign(key);
        }
        catch (Exception e) {
            throw new AOException("Error al inicializar la firma con la clave privada", e);
        }
        try {
            sig.update(this.signedAttr2.getEncoded("DER"));
        }
        catch (Exception e) {
            throw new AOException("Error al configurar la informacion de firma o al obtener los atributos a firmar", e);
        }
        try {
            realSig = sig.sign();
        }
        catch (Exception e) {
            throw new AOException("Error durante el proceso de firma", e);
        }
        return new DEROctetString(realSig);
    }
}

